/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRefsKt;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    protected final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<? extends VirtualFile> myVisibleRoots;
    @Nullable
    private final List<? extends List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<? extends VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(0);
        }
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull @NlsActions.ActionText String var1, @NotNull Collection<? extends VcsRef> var2);

    protected void createRecentAction(@NotNull List<AnAction> actionGroup, @NotNull List<String> recentItem) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(1);
        }
        if (recentItem == null) {
            BranchPopupBuilder.$$$reportNull$$$0(2);
        }
        assert (this.myRecentItems == null);
    }

    protected void createFavoritesAction(@NotNull List<AnAction> actionGroup, @NotNull List<String> favorites) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(3);
        }
        if (favorites == null) {
            BranchPopupBuilder.$$$reportNull$$$0(4);
        }
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<? extends VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(5);
        }
        Groups filteredGroups = new Groups();
        List allRefs = VcsLogRefsKt.getBranches((VcsLogRefs)dataPack.getRefs());
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            List refGroups = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getReferenceManager().groupForBranchFilter((Collection)entry.getValue());
            BranchPopupBuilder.putActionsForReferences(dataPack, refGroups, filteredGroups);
        }
        if (recentItems != null) {
            filteredGroups.recentGroups.addAll(recentItems);
        }
        return filteredGroups;
    }

    @NotNull
    private DefaultActionGroup createActions(@NotNull Groups groups) {
        if (groups == null) {
            BranchPopupBuilder.$$$reportNull$$$0(6);
        }
        ArrayList<AnAction> actionGroup = new ArrayList<AnAction>();
        for (Map.Entry<String, Collection<VcsRef>> entry : groups.singletonGroups.entrySet()) {
            actionGroup.add(this.createAction(entry.getKey(), entry.getValue()));
        }
        if (!groups.recentGroups.isEmpty()) {
            ArrayList<AnAction> recents = new ArrayList<AnAction>();
            for (List<String> list : groups.recentGroups) {
                this.createRecentAction(recents, list);
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(VcsLogBundle.message("vcs.log.filter.recent", new Object[0]), recents);
            defaultActionGroup.setPopup(true);
            actionGroup.add((AnAction)defaultActionGroup);
        }
        if (groups.favoriteGroups.size() > 1) {
            this.createFavoritesAction(actionGroup, new ArrayList<String>(ContainerUtil.map2LinkedSet((Collection)ContainerUtil.flatten(groups.favoriteGroups.values()), ref -> ref.getName())));
        }
        for (Map.Entry<String, Collection<VcsRef>> entry : groups.favoriteGroups.entrySet()) {
            actionGroup.add(this.createAction(entry.getKey(), entry.getValue()));
        }
        actionGroup.add((AnAction)Separator.getInstance());
        for (Map.Entry<String, Object> entry : groups.otherGroups.entrySet()) {
            ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
            for (Map.Entry entry2 : ((TreeMap)entry.getValue()).entrySet()) {
                arrayList.add(this.createAction((String)entry2.getKey(), (Collection)entry2.getValue()));
            }
            DefaultActionGroup popupGroup = new DefaultActionGroup(entry.getKey(), arrayList);
            popupGroup.setPopup(true);
            actionGroup.add((AnAction)popupGroup);
        }
        return new DefaultActionGroup(actionGroup);
    }

    private static void putActionsForReferences(@NotNull VcsLogDataPack pack, @NotNull List<? extends RefGroup> references, @NotNull Groups actions2) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(7);
        }
        if (references == null) {
            BranchPopupBuilder.$$$reportNull$$$0(8);
        }
        if (actions2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(9);
        }
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                VcsRef ref = ((SingletonRefGroup)refGroup).getRef();
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions2.favoriteGroups, refGroup.getName(), ref);
                    continue;
                }
                BranchPopupBuilder.append(actions2.singletonGroups, refGroup.getName(), ref);
                continue;
            }
            TreeMap<String, TreeMap<String, Collection<VcsRef>>> groups = actions2.otherGroups;
            TreeMap groupActions = groups.computeIfAbsent(refGroup.getName(), key -> new TreeMap(NaturalComparator.INSTANCE));
            for (VcsRef ref : refGroup.getRefs()) {
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions2.favoriteGroups, ref.getName(), ref);
                }
                BranchPopupBuilder.append(groupActions, ref.getName(), ref);
            }
        }
    }

    public static boolean isFavorite(@NotNull VcsLogDataPack pack, @NotNull VcsRef ref) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            BranchPopupBuilder.$$$reportNull$$$0(11);
        }
        return ((VcsLogProvider)pack.getLogProviders().get(ref.getRoot())).getReferenceManager().isFavorite(ref);
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map, @NotNull String key, @NotNull T value) {
        if (map == null) {
            BranchPopupBuilder.$$$reportNull$$$0(12);
        }
        if (key == null) {
            BranchPopupBuilder.$$$reportNull$$$0(13);
        }
        if (value == null) {
            BranchPopupBuilder.$$$reportNull$$$0(14);
        }
        BranchPopupBuilder.append(map, key, Collections.singleton(value));
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map, @NotNull String key, @NotNull Collection<? extends T> values) {
        if (map == null) {
            BranchPopupBuilder.$$$reportNull$$$0(15);
        }
        if (key == null) {
            BranchPopupBuilder.$$$reportNull$$$0(16);
        }
        if (values == null) {
            BranchPopupBuilder.$$$reportNull$$$0(17);
        }
        map.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favorites";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRecentAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFavoritesAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareGroups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createActions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "putActionsForReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isFavorite";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Groups {
        private final TreeMap<String, Collection<VcsRef>> favoriteGroups = new TreeMap();
        private final TreeMap<String, Collection<VcsRef>> singletonGroups = new TreeMap();
        private final List<List<String>> recentGroups = new ArrayList<List<String>>();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> otherGroups = new TreeMap();

        private Groups() {
        }
    }
}

