/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remoteApi;

import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryExtKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.RepositoryId;
import com.intellij.platform.vcs.impl.shared.rpc.FilePathDto;
import com.intellij.vcs.git.ref.GitCurrentRef;
import com.intellij.vcs.git.ref.GitFavoriteRefs;
import com.intellij.vcs.git.repo.GitHash;
import com.intellij.vcs.git.repo.GitOperationState;
import com.intellij.vcs.git.rpc.GitRepositoryDto;
import com.intellij.vcs.git.rpc.GitRepositoryStateDto;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitTag;
import git4idea.GitWorkingTree;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitTagType;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fH\u0007\u00a8\u0006\u0014"}, d2={"Lgit4idea/remoteApi/GitRepositoryToDtoConverter;", "", "<init>", "()V", "convertToDto", "Lcom/intellij/vcs/git/rpc/GitRepositoryDto;", "repository", "Lgit4idea/repo/GitRepository;", "convertRepositoryState", "Lcom/intellij/vcs/git/rpc/GitRepositoryStateDto;", "collectFavorites", "Lcom/intellij/vcs/git/ref/GitFavoriteRefs;", "convertOperationState", "Lcom/intellij/vcs/git/repo/GitOperationState;", "convertTrackingInfo", "", "", "Lgit4idea/GitStandardRemoteBranch;", "trackingInfo", "Lgit4idea/repo/GitBranchTrackInfo;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryToDtoConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryToDtoConverter.kt\ngit4idea/remoteApi/GitRepositoryToDtoConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,82:1\n1#2:83\n812#3,12:84\n30#4,2:96\n221#5,2:98\n*S KotlinDebug\n*F\n+ 1 GitRepositoryToDtoConverter.kt\ngit4idea/remoteApi/GitRepositoryToDtoConverter\n*L\n42#1:84,12\n52#1:96,2\n73#1:98,2\n*E\n"})
public final class GitRepositoryToDtoConverter {
    @NotNull
    public static final GitRepositoryToDtoConverter INSTANCE = new GitRepositoryToDtoConverter();

    private GitRepositoryToDtoConverter() {
    }

    @NotNull
    public final GitRepositoryDto convertToDto(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        RepositoryId repositoryId = RepositoryExtKt.repositoryId((Repository)repository2);
        String string = VcsUtil.getShortVcsRootName((Project)repository2.getProject(), (VirtualFile)repository2.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortVcsRootName(...)");
        GitRepositoryStateDto gitRepositoryStateDto = this.convertRepositoryState(repository2);
        GitFavoriteRefs gitFavoriteRefs = this.collectFavorites(repository2);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)repository2.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return new GitRepositoryDto(repositoryId, string, gitRepositoryStateDto, gitFavoriteRefs, FilePathDto.Companion.toDto(filePath));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GitRepositoryStateDto convertRepositoryState(@NotNull GitRepository repository2) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        String string;
        void it;
        GitCurrentRef gitCurrentRef;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        GitRepoInfo gitRepoInfo = repository2.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)gitRepoInfo, (String)"getInfo(...)");
        GitRepoInfo repoInfo = gitRepoInfo;
        GitCurrentRef gitCurrentRef2 = GitCurrentRef.Companion.wrap(GitRefUtil.getCurrentReference(repository2));
        String string2 = repository2.getCurrentRevision();
        if (string2 != null) {
            String string3 = string2;
            gitCurrentRef = gitCurrentRef2;
            boolean bl = false;
            string = GitHash.constructor-impl((String)it);
            gitCurrentRef2 = gitCurrentRef;
        } else {
            string = null;
        }
        Iterable iterable = repoInfo.getRemoteBranchesWithHashes().keySet();
        Set<GitLocalBranch> set = repoInfo.getLocalBranchesWithHashes().keySet();
        String string4 = string;
        gitCurrentRef = gitCurrentRef2;
        boolean $i$f$filterIsInstance = false;
        it = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GitStandardRemoteBranch)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Set set2 = CollectionsKt.toSet((Iterable)list);
        Set<GitTag> set3 = repository2.getTagHolder().getTags().keySet();
        Collection<GitWorkingTree> collection = repository2.getWorkingTreeHolder().getWorkingTrees();
        List<GitLocalBranch> list2 = repository2.getBranches().getRecentCheckoutBranches();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRecentCheckoutBranches(...)");
        DefaultConstructorMarker defaultConstructorMarker = null;
        Map<String, GitStandardRemoteBranch> map2 = this.convertTrackingInfo(repoInfo.getBranchTrackInfosMap());
        GitOperationState gitOperationState = this.convertOperationState(repository2);
        List<GitLocalBranch> list3 = list2;
        Collection<GitWorkingTree> collection2 = collection;
        Set<GitTag> set4 = set3;
        Set set5 = set2;
        Set<GitLocalBranch> set6 = set;
        String string5 = string4;
        GitCurrentRef gitCurrentRef3 = gitCurrentRef;
        return new GitRepositoryStateDto(gitCurrentRef3, string5, set6, set5, set4, collection2, list3, gitOperationState, map2, defaultConstructorMarker);
    }

    @NotNull
    public final GitFavoriteRefs collectFavorites(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager branchManager = (GitBranchManager)((Object)object);
        Set set = branchManager.getFavoriteRefs((BranchType)GitBranchType.LOCAL, repository2);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFavoriteRefs(...)");
        Set set2 = branchManager.getFavoriteRefs((BranchType)GitBranchType.REMOTE, repository2);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFavoriteRefs(...)");
        Set set3 = branchManager.getFavoriteRefs((BranchType)GitTagType.INSTANCE, repository2);
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getFavoriteRefs(...)");
        return new GitFavoriteRefs(set, set2, set3);
    }

    private final GitOperationState convertOperationState(GitRepository repository2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[repository2.getState().ordinal()]) {
            case 1 -> GitOperationState.NORMAL;
            case 2 -> GitOperationState.MERGE;
            case 3 -> GitOperationState.REBASE;
            case 4 -> GitOperationState.CHERRY_PICK;
            case 5 -> GitOperationState.REVERT;
            case 6 -> GitOperationState.DETACHED_HEAD;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, GitStandardRemoteBranch> convertTrackingInfo(@NotNull Map<String, ? extends GitBranchTrackInfo> trackingInfo) {
        Intrinsics.checkNotNullParameter(trackingInfo, (String)"trackingInfo");
        HashMap result2 = new HashMap(trackingInfo.size());
        Map<String, ? extends GitBranchTrackInfo> $this$forEach$iv = trackingInfo;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends GitBranchTrackInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            GitRemoteBranch remoteBranch;
            Map.Entry<String, ? extends GitBranchTrackInfo> element$iv;
            Map.Entry<String, ? extends GitBranchTrackInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            String branchName = entry.getKey();
            GitBranchTrackInfo trackInfo = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)trackInfo.getRemoteBranch(), (String)"getRemoteBranch(...)");
            if (!(remoteBranch instanceof GitStandardRemoteBranch)) continue;
            ((Map)result2).put(branchName, remoteBranch);
        }
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Repository.State.values().length];
            try {
                nArray[Repository.State.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.MERGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REBASING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.GRAFTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REVERTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.DETACHED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

