/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitUntrackedFilesHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/repo/GitUntrackedDirtyScopeListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "<init>", "(Lgit4idea/repo/GitRepositoryManager;)V", "filesChanged", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAffectedFilePaths", "Lcom/intellij/openapi/vcs/FilePath;", "event", "intellij.vcs.git"})
public final class GitUntrackedDirtyScopeListener
implements AsyncVfsEventsListener {
    @NotNull
    private final GitRepositoryManager repositoryManager;

    public GitUntrackedDirtyScopeListener(@NotNull GitRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        this.repositoryManager = repositoryManager;
    }

    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        if (this.repositoryManager.getRepositories().isEmpty()) {
            return Unit.INSTANCE;
        }
        MultiMap map2 = new MultiMap();
        for (VFileEvent entry : events) {
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            for (FilePath filePath : this.getAffectedFilePaths(entry)) {
                GitRepository repo;
                if ((GitRepository)this.repositoryManager.getRepositoryForFileQuick(filePath) == null) continue;
                map2.putValue((Object)repo, (Object)filePath);
            }
        }
        JobKt.ensureActive((CoroutineContext)$completion.getContext());
        for (Map.Entry entry : map2.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            GitRepository repo = (GitRepository)entry.getKey();
            Collection filePaths = (Collection)entry.getValue();
            GitUntrackedFilesHolder gitUntrackedFilesHolder = repo.getUntrackedFilesHolder();
            Intrinsics.checkNotNull((Object)filePaths);
            gitUntrackedFilesHolder.markPossiblyUntracked(filePaths);
        }
        return Unit.INSTANCE;
    }

    private final List<FilePath> getAffectedFilePaths(VFileEvent event) {
        boolean bl;
        if (event instanceof VFileContentChangeEvent) {
            return CollectionsKt.emptyList();
        }
        if (event instanceof VFilePropertyChangeEvent && !((VFilePropertyChangeEvent)event).isRename()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<FilePath> affectedFilePaths = new ArrayList<FilePath>(2);
        if (event instanceof VFileCreateEvent) {
            bl = ((VFileCreateEvent)event).isDirectory();
        } else {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            bl = virtualFile.isDirectory();
        }
        boolean isDirectory = bl;
        affectedFilePaths.add(VcsUtil.getFilePath((String)event.getPath(), (boolean)isDirectory));
        if (event instanceof VFileMoveEvent) {
            affectedFilePaths.add(VcsUtil.getFilePath((String)((VFileMoveEvent)event).getOldPath(), (boolean)isDirectory));
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename()) {
            affectedFilePaths.add(VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)event).getOldPath(), (boolean)isDirectory));
        }
        return affectedFilePaths;
    }
}

