/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LazyIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.FilteredIcon;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.ui.icons.ScaledIconCacheKt;
import com.intellij.ui.icons.SuffixPathTransform;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleKt;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00c7\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003*\u0001@\u001a\u0016\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\b\u0010\f\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u001a\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0017H\u0007\u001a6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0007\u001a\u001e\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0007\u001a,\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010,2\u000e\b\u0002\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.H\u0007\u001a*\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010*\u001a\u00020\t2\f\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.2\b\u0010+\u001a\u0004\u0018\u00010,H\u0007\u001a\u0010\u00101\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0007\u001a\u0012\u00104\u001a\u0004\u0018\u00010\u001d2\u0006\u00105\u001a\u000206H\u0000\u001a\"\u00107\u001a\u0004\u0018\u00010)2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0007\u001a\u0018\u0010:\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00109\u001a\u00020;H\u0000\u001a\u001a\u0010<\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020)2\b\b\u0002\u0010=\u001a\u00020&H\u0007\u001a\u0010\u0010>\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u001a\u001a\u0010L\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010M\u001a\u0004\u0018\u00010FH\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010A\"\u001a\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u008a\u0001\u0010D\u001a~\u0012\u000e\u0012\f0F\u00a2\u0006\u0002\bG\u00a2\u0006\u0002\bH\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012 J*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010I0I J*=\u0012\u000e\u0012\f0F\u00a2\u0006\u0002\bG\u00a2\u0006\u0002\bH\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012 J*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010I0I0K\u00a2\u0006\u0002\bG0E\u00a2\u0006\u0002\bGX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "cleaners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function0;", "", "FILE_SCHEME_PREFIX", "", "registerIconCacheCleaner", "cleaner", "clearCacheOnUpdateTransform", "updateTransform", "updater", "Lkotlin/Function1;", "Lcom/intellij/ui/icons/IconTransform;", "copyIcon", "Ljavax/swing/Icon;", "icon", "ancestor", "Ljava/awt/Component;", "deepCopy", "", "getOriginIcon", "Lcom/intellij/ui/RetrievableIcon;", "getMenuBarIcon", "dark", "convertImage", "Ljava/awt/Image;", "image", "filters", "", "Ljava/awt/image/ImageFilter;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "isUpScaleNeeded", "imageScale", "", "filterImage", "loadPngFromClassResource", "Ljava/awt/image/BufferedImage;", "path", "classLoader", "Ljava/lang/ClassLoader;", "resourceClass", "Ljava/lang/Class;", "getResourceData", "", "loadRasterImage", "stream", "Ljava/io/InputStream;", "loadCustomIcon", "url", "Ljava/net/URL;", "loadImageForStartUp", "requestedPath", "scale", "doScaleImage", "", "toRetinaAwareIcon", "sysScale", "checkIconSize", "standardDisablingFilter", "com/intellij/ui/icons/IconUtilKt$standardDisablingFilter$1", "Lcom/intellij/ui/icons/IconUtilKt$standardDisablingFilter$1;", "iconToDisabledIcon", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "iconToIconWithCustomFilter", "", "Lcom/intellij/ui/icons/RgbImageFilterSupplier;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/github/benmanes/caffeine/cache/Cache;", "kotlin.jvm.PlatformType", "", "getDisabledIcon", "disableFilter", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\niconUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 iconUtil.kt\ncom/intellij/ui/icons/IconUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n13#2:401\n1#3:402\n*S KotlinDebug\n*F\n+ 1 iconUtil.kt\ncom/intellij/ui/icons/IconUtilKt\n*L\n53#1:401\n*E\n"})
public final class IconUtilKt {
    @NotNull
    private static final CopyOnWriteArrayList<Function0<Unit>> cleaners;
    @NotNull
    public static final String FILE_SCHEME_PREFIX = "file:/";
    @NotNull
    private static final standardDisablingFilter.1 standardDisablingFilter;
    @NotNull
    private static final LoadingCache<Icon, Icon> iconToDisabledIcon;
    @NotNull
    private static final Map<RgbImageFilterSupplier, Cache<Icon, Icon>> iconToIconWithCustomFilter;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImageUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final void registerIconCacheCleaner(@NotNull Function0<Unit> cleaner) {
        Intrinsics.checkNotNullParameter(cleaner, (String)"cleaner");
        cleaners.add(cleaner);
    }

    public static final void clearCacheOnUpdateTransform() {
        Iterator<Function0<Unit>> iterator = cleaners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Function0<Unit>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Function0<Unit> cleaner = iterator2.next();
            cleaner.invoke();
        }
    }

    public static final void updateTransform(@NotNull Function1<? super IconTransform, IconTransform> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        IconTransform prev = null;
        IconTransform next = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)CachedImageIconKt.pathTransform.get(), (String)"get(...)");
        } while (!CachedImageIconKt.pathTransform.compareAndSet(prev, next = (IconTransform)updater.invoke((Object)prev)));
        CachedImageIconKt.pathTransformGlobalModCount.incrementAndGet();
        if (Intrinsics.areEqual((Object)prev, (Object)next)) {
            return;
        }
        IconUtilKt.clearCacheOnUpdateTransform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final Icon copyIcon(@NotNull Icon icon, @Nullable Component ancestor, boolean deepCopy) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon instanceof CopyableIcon) {
            Icon icon2;
            if (deepCopy) {
                Icon icon3 = ((CopyableIcon)icon).deepCopy();
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"deepCopy(...)");
            } else {
                Icon icon4 = ((CopyableIcon)icon).copy();
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"copy(...)");
            }
            return icon2;
        }
        Component component = ancestor;
        BufferedImage bufferedImage = ImageUtil.createImage(component != null ? component.getGraphicsConfiguration() : null, icon.getIconWidth(), icon.getIconHeight(), 2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon(icon, image){
            private final int originalWidth;
            private final int originalHeight;
            {
                this.originalWidth = $icon.getIconWidth();
                this.originalHeight = $icon.getIconHeight();
            }

            public final int getOriginalWidth() {
                return this.originalWidth;
            }

            public final int getOriginalHeight() {
                return this.originalHeight;
            }

            public int getIconWidth() {
                return this.originalWidth;
            }

            public int getIconHeight() {
                return this.originalHeight;
            }
        };
    }

    @NotNull
    public static final Icon getOriginIcon(@NotNull RetrievableIcon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int maxDeep = 10;
        Icon icon2 = icon.retrieveIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"retrieveIcon(...)");
        Icon origin = icon2;
        for (int level = 0; origin instanceof RetrievableIcon && level < maxDeep; ++level) {
            Intrinsics.checkNotNullExpressionValue((Object)((RetrievableIcon)origin).retrieveIcon(), (String)"retrieveIcon(...)");
        }
        if (origin instanceof RetrievableIcon) {
            IconUtilKt.getLOG().error("can't calculate origin icon (too deep in hierarchy), src: " + icon);
        }
        return origin;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon getMenuBarIcon(@NotNull Icon icon, boolean dark) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Icon effectiveIcon = icon;
        if (effectiveIcon instanceof RetrievableIcon) {
            effectiveIcon = IconUtilKt.getOriginIcon((RetrievableIcon)effectiveIcon);
        }
        if (effectiveIcon instanceof CachedImageIcon) {
            return ((CachedImageIcon)effectiveIcon).getMenuBarIcon(dark);
        }
        if (effectiveIcon instanceof MenuBarIconProvider) {
            Icon icon3 = ((MenuBarIconProvider)((Object)effectiveIcon)).getMenuBarIcon(dark);
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getMenuBarIcon(...)");
        } else {
            icon2 = effectiveIcon;
        }
        return icon2;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Image convertImage(@NotNull Image image, @NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded, float imageScale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Image result = image;
        if (isUpScaleNeeded) {
            float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            if (imageScale > 1.0f) {
                scale /= imageScale;
            }
            result = ImageLoader.scaleImage(result, scale);
        }
        result = IconUtilKt.filterImage(result, filters);
        double sysScale = scaleContext.getScale(ScaleType.SYS_SCALE);
        if (ScaleKt.isHiDPIEnabledAndApplicable((float)sysScale)) {
            return new JBHiDPIScaledImage(result, sysScale);
        }
        return result;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Image filterImage(@NotNull Image image, @NotNull List<? extends ImageFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Image result = image;
        if (!filters.isEmpty()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (ImageFilter imageFilter : filters) {
                Intrinsics.checkNotNullExpressionValue((Object)toolkit.createImage(new FilteredImageSource(ImageUtil.toBufferedImage(result, false).getSource(), imageFilter)), (String)"createImage(...)");
            }
        }
        return result;
    }

    @ApiStatus.Internal
    @Nullable
    public static final BufferedImage loadPngFromClassResource(@NotNull String path, @Nullable ClassLoader classLoader, @Nullable Class<?> resourceClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = IconUtilKt.getResourceData(path, resourceClass, classLoader);
        if (byArray == null) {
            return null;
        }
        byte[] data = byArray;
        return IconUtilKt.loadRasterImage(new ByteArrayInputStream(data));
    }

    public static /* synthetic */ BufferedImage loadPngFromClassResource$default(String string, ClassLoader classLoader, Class clazz, int n, Object object) {
        if ((n & 4) != 0) {
            clazz = null;
        }
        return IconUtilKt.loadPngFromClassResource(string, classLoader, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public static final byte[] getResourceData(@NotNull String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) {
        Object object;
        Object data;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl2 = bl = resourceClass != null || classLoader != null || StringsKt.startsWith$default((String)path, (String)FILE_SCHEME_PREFIX, (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (classLoader != null) {
            String string;
            boolean isAbsolute = StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null);
            if (isAbsolute) {
                String string2 = path.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = path;
            }
            data = ResourceUtil.getResourceAsBytes((String)string, (ClassLoader)classLoader, (boolean)true);
            if (data != null || isAbsolute) {
                return data;
            }
        }
        if ((object = resourceClass) != null && (object = ((Class)object).getResourceAsStream(path)) != null) {
            data = (Closeable)object;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)data;
                boolean bl3 = false;
                byte[] byArray = stream.readAllBytes();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)data, (Throwable)throwable);
            }
        }
        if (StringsKt.startsWith$default((String)path, (String)FILE_SCHEME_PREFIX, (boolean)false, (int)2, null)) {
            Path nioPath = Path.of(URI.create(path));
            try {
                return Files.readAllBytes(nioPath);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException e) {
                IconUtilKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final BufferedImage loadRasterImage(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        BufferedImage image = null;
        Closeable closeable = new MemoryCacheImageInputStream(stream);
        Throwable throwable = null;
        try {
            Iterator<ImageReader> iterator;
            MemoryCacheImageInputStream imageInputStream = (MemoryCacheImageInputStream)closeable;
            boolean bl = false;
            Iterator<ImageReader> it = iterator = ImageIO.getImageReaders(imageInputStream);
            boolean bl2 = false;
            Iterator<ImageReader> iterator2 = it.hasNext() ? iterator : null;
            if (iterator2 == null || (iterator2 = iterator2.next()) == null) {
                iterator2 = ImageIO.getImageReadersByFormatName("png").next();
            }
            Iterator<ImageReader> reader = iterator2;
            try {
                ((ImageReader)((Object)reader)).setInput(imageInputStream, true, true);
                BufferedImage bufferedImage = ((ImageReader)((Object)reader)).read(0, null);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
                image = bufferedImage;
            }
            finally {
                ((ImageReader)((Object)reader)).dispose();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (start != -1L) {
            IconLoadMeasurer.pngDecoding.end(start);
        }
        return image;
    }

    @Nullable
    public static final Image loadCustomIcon(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String path = string;
        ScaleContext scaleContext = ScaleContext.Companion.create();
        float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor imageDescriptor = new ImageDescriptor((Function2<? super String, ? super String, String>)((Function2)new SuffixPathTransform("")), scale, StringsKt.endsWith((String)path, (String)".svg", (boolean)true), StringsKt.contains$default((CharSequence)path, (CharSequence)"_dark.", (boolean)false, (int)2, null), StringsKt.contains$default((CharSequence)path, (CharSequence)"_stroke.", (boolean)false, (int)2, null));
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        String rawPathWithoutExt = null;
        String ext = null;
        if (lastDotIndex == -1) {
            rawPathWithoutExt = path;
            ext = "png";
        } else {
            String string2 = path.substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            rawPathWithoutExt = string2;
            String string3 = path.substring(lastDotIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            ext = string3;
        }
        Image image = ImageUtil.ensureHiDPI(ImageCacheKt.loadByDescriptor(rawPathWithoutExt, ext, imageDescriptor), scaleContext);
        if (image == null) {
            return null;
        }
        Image icon = image;
        int w = icon.getWidth(null);
        int h = icon.getHeight(null);
        if (w <= 0 || h <= 0) {
            IconUtilKt.getLOG().error("negative image size: w=" + w + ", h=" + h + ", path=" + path);
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)RangesKt.coerceAtLeast((int)w, (int)h);
            return ImageLoader.scaleImage(icon, s);
        }
        return icon;
    }

    @ApiStatus.Internal
    @Nullable
    public static final BufferedImage loadImageForStartUp(@NotNull String requestedPath, float scale, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)requestedPath, (String)"requestedPath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List<ImageDescriptor> descriptors = ImageDescriptorKt.createImageDescriptorList(requestedPath, false, false, scale);
        for (ImageDescriptor descriptor : descriptors) {
            try {
                String pathWithoutExt;
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)requestedPath, (char)'.', (int)0, (boolean)false, (int)6, null);
                Intrinsics.checkNotNullExpressionValue((Object)requestedPath.substring(0, dotIndex), (String)"substring(...)");
                Function2<String, String, String> function2 = descriptor.pathTransform;
                String string = requestedPath.substring(dotIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                byte[] byArray = IconUtilKt.getResourceData((String)function2.invoke((Object)pathWithoutExt, (Object)string), null, classLoader);
                if (byArray == null) continue;
                byte[] data = byArray;
                if (descriptor.isSvg) {
                    return SvgKt.renderSvg(data, descriptor.scale);
                }
                BufferedImage image = IconUtilKt.loadRasterImage(new ByteArrayInputStream(data));
                float effectiveScale = descriptor.scale > 1.0f ? scale / descriptor.scale : scale;
                Image image2 = IconUtilKt.doScaleImage(image, effectiveScale);
                Intrinsics.checkNotNull((Object)image2, (String)"null cannot be cast to non-null type java.awt.image.BufferedImage");
                return (BufferedImage)image2;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @NotNull
    public static final Image doScaleImage(@NotNull Image image, double scale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (scale == 1.0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(scale);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            return image;
        }
        int width = MathKt.roundToInt((double)(scale * (double)w));
        int height = MathKt.roundToInt((double)(scale * (double)h));
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{null};
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image, false), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])bufferedImageOpArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"resize(...)");
        return bufferedImage;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon toRetinaAwareIcon(@NotNull BufferedImage image, float sysScale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return new JBImageIcon(ScaleKt.isHiDPIEnabledAndApplicable(sysScale) ? (BufferedImage)new JBHiDPIScaledImage(image, sysScale) : image);
    }

    public static /* synthetic */ Icon toRetinaAwareIcon$default(BufferedImage bufferedImage, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = JBUIScale.sysScale();
        }
        return IconUtilKt.toRetinaAwareIcon(bufferedImage, f);
    }

    public static final boolean checkIconSize(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon.getIconWidth() <= 0 || icon.getIconHeight() <= 0) {
            IconUtilKt.getLOG().error("Icon " + icon + " has incorrect size: " + icon.getIconWidth() + "x" + icon.getIconHeight());
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon getDisabledIcon(@NotNull Icon icon, @Nullable RgbImageFilterSupplier disableFilter) {
        Icon effectiveIcon;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (!ScaledIconCacheKt.isIconActivated || icon instanceof EmptyIcon) {
            return icon;
        }
        Icon icon2 = effectiveIcon = icon instanceof LazyIcon ? ((LazyIcon)icon).getOrComputeIcon() : icon;
        if (disableFilter == null) {
            Object object = iconToDisabledIcon.get((Object)effectiveIcon);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Icon)object;
        }
        RgbImageFilterSupplier filter = disableFilter;
        Object object = iconToIconWithCustomFilter.computeIfAbsent(filter, arg_0 -> IconUtilKt.getDisabledIcon$lambda$1(IconUtilKt::getDisabledIcon$lambda$0, arg_0)).get((Object)effectiveIcon, arg_0 -> IconUtilKt.getDisabledIcon$lambda$3(arg_0 -> IconUtilKt.getDisabledIcon$lambda$2(filter, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Icon)object;
    }

    private static final Icon iconToDisabledIcon$lambda$0(Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return icon instanceof CachedImageIcon ? ((CachedImageIcon)icon).createWithFilter$intellij_platform_util_ui(standardDisablingFilter) : (Icon)((Object)new FilteredIcon(icon, standardDisablingFilter));
    }

    private static final Cache getDisabledIcon$lambda$0(RgbImageFilterSupplier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Caffeine caffeine = Caffeine.newBuilder().maximumSize(512L).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault()));
        long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        return caffeine.expireAfterAccess(duration).build();
    }

    private static final Cache getDisabledIcon$lambda$1(Function1 $tmp0, Object p0) {
        return (Cache)$tmp0.invoke(p0);
    }

    private static final Icon getDisabledIcon$lambda$2(RgbImageFilterSupplier $filter, Icon baseIcon) {
        Intrinsics.checkNotNullParameter((Object)baseIcon, (String)"baseIcon");
        return baseIcon instanceof CachedImageIcon ? ((CachedImageIcon)baseIcon).createWithFilter$intellij_platform_util_ui($filter) : (Icon)((Object)new FilteredIcon(baseIcon, $filter));
    }

    private static final Icon getDisabledIcon$lambda$3(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    static {
        Object object;
        cleaners = new CopyOnWriteArrayList();
        standardDisablingFilter = new RgbImageFilterSupplier(){

            public RGBImageFilter getFilter() {
                RGBImageFilter rGBImageFilter = UIUtil.getGrayFilter();
                Intrinsics.checkNotNullExpressionValue((Object)rGBImageFilter, (String)"getGrayFilter(...)");
                return rGBImageFilter;
            }
        };
        Caffeine caffeine = Caffeine.newBuilder().maximumSize(1024L).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault()));
        long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        LoadingCache it = object = caffeine.expireAfterAccess(duration).build(IconUtilKt::iconToDisabledIcon$lambda$0);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        IconUtilKt.registerIconCacheCleaner((Function0<Unit>)((Function0)new Function0<Unit>((Object)it){

            public final void invoke() {
                ((LoadingCache)this.receiver).invalidateAll();
            }
        }));
        LoadingCache loadingCache = object;
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"also(...)");
        iconToDisabledIcon = loadingCache;
        it = object = CollectionFactory.createSoftMap();
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        IconUtilKt.registerIconCacheCleaner((Function0<Unit>)((Function0)new Function0<Unit>((Object)it){

            public final void invoke() {
                ((Map)this.receiver).clear();
            }
        }));
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        iconToIconWithCustomFilter = object2;
    }
}

