import * as ts from "typescript/lib/tsserverlibrary"

import type {
  AreTypesMutuallyAssignableResponse,
  GetCompletionSymbolsResponse,
  GetElementTypeResponse,
  GetResolvedSignatureResponse,
  GetSymbolTypeResponse,
  GetTypeTextResponse,
  SymbolResponse,
  TypeRequestKind
} from "./protocol"
import {ReverseMapper} from "./ide-get-element-type"
import {IdeProjectService} from "./ide-project-service"

declare global {
  type RegularMap<K, V> = Map<K, V>

  type ErrorKind = OperationCancelledException | FileOutsideOfImportGraphException | OutdatedTypeCheckerIdException

  type OperationCancelledException = "OperationCancelledException"
  type FileOutsideOfImportGraphException = "FileOutsideOfImportGraphException"
  type OutdatedTypeCheckerIdException = "OutdatedTypeCheckerIdException"

  interface Error {
    ideKind?: ErrorKind
  }
}

declare module "typescript/lib/tsserverlibrary" {

  interface TypeChecker {
    webStormCacheInfo?: {
      ideTypeCheckerId: number,
      ideProjectId: number,
      requestedTypeIds: Set<number>,
      seenTypeIds: RegularMap<number, Type>,
      seenSymbolIds: RegularMap<number, Symbol>,
    }
  }

  interface Type {
    id: number | undefined // internal
  }

  type WebStormGetOptions = {
    ts: typeof import("typescript/lib/tsserverlibrary"),
    cancellationToken: ts.HostCancellationToken,
    reverseMapper?: ReverseMapper,
  }

  interface LanguageService {

    ideProjectId: number

    webStormGetCompletionSymbols(
      options: WebStormGetOptions & {
        fileName: string,
        position: number,
        ls: LanguageService,
      }
    ): GetCompletionSymbolsResponse

    webStormGetElementType(
      options: WebStormGetOptions & {
        fileName: string,
        startOffset: number,
        endOffset: number,
        typeRequestKind: TypeRequestKind,
        forceReturnType: boolean,
      },
    ): GetElementTypeResponse

    webStormGetSymbolType(
      options: WebStormGetOptions & {
        symbolId: number,
      },
    ): GetSymbolTypeResponse

    webStormGetTypeText(
      options: WebStormGetOptions & {
        symbolId: number,
        flags?: number,
      },
    ): GetTypeTextResponse

    webStormGetTypeProperties(
      options: WebStormGetOptions & {
        typeId: number,
      },
    ): GetElementTypeResponse

    webStormGetTypeProperty(
      options: WebStormGetOptions & {
        typeId: number,
        propertyName: string,
      },
    ): SymbolResponse

    webStormAreTypesMutuallyAssignable(
      options: Omit<WebStormGetOptions, "reverseMapper"> & {
        type1Id: number,
        type2Id: number,
      },
    ): AreTypesMutuallyAssignableResponse

    webStormGetResolvedSignature(
      options: WebStormGetOptions & {
        fileName: string,
        startOffset: number,
        endOffset: number,
      },
    ): GetResolvedSignatureResponse
  }

  namespace server {
    interface ProjectService {
      ideProjectService: IdeProjectService
    }

    interface Project {
      ideProjectId: number
    }
  }

  function getTokenAtPosition(sourceFile: ts.SourceFile, startOffset: number): ts.Node

  function isExpression(node: ts.Node): node is ts.Expression

  function isEqualityOperatorKind(kind: ts.SyntaxKind): kind is ts.EqualityOperator
}

export = ts;
