/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.packages.NodePackagesKt;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.testing.runScope.JsTestRunScopeComponent;
import com.intellij.javascript.testing.vitest.VitestCliOptionsCompletionProvider;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.javascript.testing.vitest.VitestUtil;
import com.intellij.javascript.testing.vitest.config.VitestConfig;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configPathTextFieldWithBrowseButton", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "interpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "nodeOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "vitestPackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "workingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "vitestOptionsEditor", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "scopeComponent", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "panel", "Ljavax/swing/JPanel;", "resetEditorFrom", "", "runConfiguration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "Companion", "intellij.javascript.ultimate"})
public final class VitestRunConfigurationEditor
extends SettingsEditor<VitestRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton configPathTextFieldWithBrowseButton;
    @NotNull
    private final NodeJsInterpreterField interpreterField;
    @NotNull
    private final RawCommandLineEditor nodeOptionsEditor;
    @NotNull
    private final NodePackageField vitestPackageField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirComponent;
    @NotNull
    private final TextFieldWithCompletion vitestOptionsEditor;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    @NotNull
    private final JsTestRunScopeComponent scopeComponent;
    @NotNull
    private final JPanel panel;

    public VitestRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.interpreterField = new NodeJsInterpreterField(project);
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor().withMonospaced(false);
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"withMonospaced(...)");
        this.nodeOptionsEditor = rawCommandLineEditor;
        this.workingDirComponent = VitestRunConfigurationEditor.Companion.createWorkingDirComponent(project);
        this.configPathTextFieldWithBrowseButton = VitestRunConfigurationEditor.Companion.createConfigurationFileTextField(project);
        this.vitestPackageField = new NodePackageField(this.interpreterField, VitestUtil.INSTANCE.getPKG_DESCRIPTOR(), () -> VitestRunConfigurationEditor._init_$lambda$0(this));
        this.vitestOptionsEditor = VitestRunConfigurationEditor.Companion.createVitestOptionsEditor(project);
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        int longestLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]))).getPreferredSize().width;
        this.scopeComponent = new JsTestRunScopeComponent(project, longestLabelWidth, true);
        JPanel jPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(JavaScriptBundle.message((String)"vitest.rc.configurationFile.label", (Object[])new Object[0]), (JComponent)this.configPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)this.interpreterField, 8).addLabeledComponent(JavaScriptBundle.message((String)"rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.nodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"vitest.rc.vitestPackageField.label", (Object[])new Object[0]), (JComponent)this.vitestPackageField).addLabeledComponent(JavaScriptBundle.message((String)"rc.workingDirectory.label", (Object[])new Object[0]), (JComponent)this.workingDirComponent).addLabeledComponent(JavaScriptBundle.message((String)"vitest.rc.vitestOptions.label", (Object[])new Object[0]), (JComponent)this.vitestOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.envVarsComponent).addSeparator(8).addComponent(this.scopeComponent.getComponent()).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        this.panel = jPanel;
    }

    protected void resetEditorFrom(@NotNull VitestRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        VitestRunSettings settings = runConfiguration.getSettings();
        this.configPathTextFieldWithBrowseButton.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)settings.getConfigFilePath()));
        this.interpreterField.setInterpreterRef(settings.getInterpreterRef());
        this.nodeOptionsEditor.setText(settings.getNodeOptions());
        this.vitestPackageField.setSelected(runConfiguration.getOrDetectVitestPackage());
        this.workingDirComponent.setText(FileUtil.toSystemDependentName((String)settings.getWorkingDir()));
        this.vitestOptionsEditor.setText(settings.getVitestOptions());
        this.envVarsComponent.setData(settings.getEnvData());
        this.scopeComponent.resetEditorFrom(settings.getScope());
    }

    protected void applyEditorTo(@NotNull VitestRunConfiguration runConfiguration) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        VitestRunSettings.Builder builder = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string = PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.configPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        builder.setConfigFilePath(string);
        NodeJsInterpreterRef nodeJsInterpreterRef = this.interpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        builder.setInterpreterRef(nodeJsInterpreterRef);
        String string2 = this.nodeOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        builder.setNodeOptions(string2);
        builder.setVitestPackage(NodePackagesKt.nullize$default((NodePackage)this.vitestPackageField.getSelected(), (boolean)false, (int)1, null));
        String string3 = PathShortener.getAbsolutePath((JTextField)this.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        builder.setWorkingDir(string3);
        String string4 = this.vitestOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        builder.setVitestOptions(string4);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        builder.setEnvData(environmentVariablesData);
        builder.setScope(this.scopeComponent.getScope());
        runConfiguration.setSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.panel;
    }

    private static final VirtualFile _init_$lambda$0(VitestRunConfigurationEditor this$0) {
        String string = PathShortener.getAbsolutePath((JTextField)this$0.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String text = string;
        return !(((CharSequence)text).length() == 0) ? LocalFileSystem.getInstance().findFileByPath(text) : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion;", "", "<init>", "()V", "createVitestOptionsEditor", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "project", "Lcom/intellij/openapi/project/Project;", "createConfigurationFileTextField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "createWorkingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "intellij.javascript.ultimate"})
    @SourceDebugExtension(value={"SMAP\nVitestRunConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestRunConfigurationEditor.kt\ncom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1586#2:125\n1661#2,3:126\n*S KotlinDebug\n*F\n+ 1 VitestRunConfigurationEditor.kt\ncom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion\n*L\n106#1:125\n106#1:126,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final TextFieldWithCompletion createVitestOptionsEditor(Project project) {
            VitestCliOptionsCompletionProvider provider = new VitestCliOptionsCompletionProvider();
            TextFieldWithCompletion editor = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
            editor.setPlaceholder((CharSequence)JavaScriptBundle.message((String)"vitest.rc.vitestOptions.emptyText", (Object[])new Object[0]));
            return editor;
        }

        private final TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(Project project) {
            TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
            PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), null);
            JComponent jComponent = textFieldWithHistoryWithBrowseButton.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
            TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)jComponent;
            textFieldWithHistory.setHistorySize(-1);
            textFieldWithHistory.setMinimumAndPreferredWidth(0);
            PathShortener.enablePathShortening((JTextField)textFieldWithHistory.getTextEditor(), null);
            SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> Companion.createConfigurationFileTextField$lambda$0(project));
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JavaScriptBundle.message((String)"vitest.rc.configurationFile.title", (Object[])new Object[0]));
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (FileChooserDescriptor)descriptor);
            return textFieldWithHistoryWithBrowseButton;
        }

        private final TextFieldWithBrowseButton createWorkingDirComponent(Project project) {
            TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(JavaScriptBundle.message((String)"rc.workingDirectory.browseDialogTitle", (Object[])new Object[0]));
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (FileChooserDescriptor)descriptor);
            return textFieldWithBrowseButton;
        }

        /*
         * WARNING - void declaration
         */
        private static final List createConfigurationFileTextField$lambda$0(Project $project) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = VitestConfig.INSTANCE.listPossibleConfigFilesInProject($project);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)it.getPath()), (boolean)false));
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

