/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\"\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"getClassName", "", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PROTO_PROP", "PROTOTYPE_PROP", "isPrototypeVariable", "", "variableName", "intellij.javascript.debugger.ui"})
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+[\\[(]\\d+[\\])]$");
    @NotNull
    private static final String PROTO_PROP = "__proto__";
    @NotNull
    private static final String PROTOTYPE_PROP = "[[Prototype]]";

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String className = value.getClassName();
        CharSequence charSequence = className;
        return charSequence == null || charSequence.length() == 0 ? "Object" : (Intrinsics.areEqual((Object)className, (Object)"console") ? "Console" : className);
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String description = value.getValueString();
        CharSequence charSequence = description;
        return charSequence == null || charSequence.length() == 0 ? VariableViewKt.getClassName(value) : description;
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getValueString();
        if (string == null) {
            return "";
        }
        return VariableViewKt.trimFunctionDescription(string);
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull String value) {
        int endIndex;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (endIndex = 0; endIndex < value.length() && !StringUtil.isLineBreak((char)value.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(value.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string = value.substring(0, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final XValuePresentation createNumberPresentation(String value) {
        return Intrinsics.areEqual((Object)value, (Object)"NaN") || Intrinsics.areEqual((Object)value, (Object)"Infinity") ? (XValuePresentation)new XKeywordValuePresentation(value) : (XValuePresentation)new XNumericValuePresentation(value);
    }

    private static final boolean isPrototypeVariable(String variableName) {
        return Intrinsics.areEqual((Object)variableName, (Object)PROTO_PROP) || Intrinsics.areEqual((Object)variableName, (Object)PROTOTYPE_PROP);
    }

    public static final /* synthetic */ boolean access$isPrototypeVariable(String variableName) {
        return VariableViewKt.isPrototypeVariable(variableName);
    }

    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(String value) {
        return VariableViewKt.createNumberPresentation(value);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }
}

