/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapper;
import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapperDriver;
import com.intellij.indexing.shared.git.GitHashesServiceKt;
import com.intellij.indexing.shared.ultimate.git.GitBlobKey;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004*\u0002 $\u0018\u00002\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJJ\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u001f\u0010\u0019\u001a\u001b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u001b\u0010\u001f\u001a\u00020 2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0!H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0012j\b\u0012\u0004\u0012\u00020\u0003`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%\u00a8\u0006'"}, d2={"Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper;", "", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "driver", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;", "lifetime", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;Lcom/intellij/openapi/Disposable;)V", "requestsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "blobSetHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "isCollecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "changedFilesList", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "computeGitHash", "Y", "file", "force", "", "action", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "startCollecting", "", "returnObject", "com/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$returnObject$1", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$returnObject$1;", "vfsListener", "com/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$vfsListener$1", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$vfsListener$1;", "ChangeApplier", "intellij.indexing.shared.ultimate.git"})
public final class GitHashesProjectServiceWrapper {
    @NotNull
    private final VirtualFile rootFile;
    @NotNull
    private final GitHashesProjectServiceWrapperDriver driver;
    @NotNull
    private final Disposable lifetime;
    @NotNull
    private final AtomicInteger requestsCount;
    @NotNull
    private final AtomicReference<GitBlobSet> blobSetHolder;
    @NotNull
    private final AtomicBoolean isCollecting;
    @NotNull
    private final HashSet<VirtualFile> changedFilesList;
    @NotNull
    private final vfsListener.1 vfsListener;

    public GitHashesProjectServiceWrapper(@NotNull VirtualFile rootFile, @NotNull GitHashesProjectServiceWrapperDriver driver, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.rootFile = rootFile;
        this.driver = driver;
        this.lifetime = lifetime;
        this.requestsCount = new AtomicInteger(0);
        this.blobSetHolder = new AtomicReference<Object>(null);
        this.isCollecting = new AtomicBoolean(false);
        this.changedFilesList = new HashSet();
        this.vfsListener = new AsyncFileListener(this){
            final /* synthetic */ GitHashesProjectServiceWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public ChangeApplier prepareChange(List<? extends VFileEvent> events) {
                void $this$filterTo$iv;
                Iterable $this$mapNotNullTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                GitBlobSet oldSet;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                GitBlobSet gitBlobSet = oldSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this.this$0).get();
                boolean bl = gitBlobSet != null ? gitBlobSet.isEmpty() : false;
                if (bl) {
                    return null;
                }
                Iterable iterable = events;
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VFileEvent it = (VFileEvent)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof VFilePropertyChangeEvent))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = new HashSet<E>(events.size());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile it$iv;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    VFileEvent e = (VFileEvent)element$iv;
                    boolean bl4 = false;
                    if (e.getFile() == null) continue;
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                $this$mapNotNullTo$iv = destination$iv;
                destination$iv = new HashSet<E>(events.size());
                GitHashesProjectServiceWrapper gitHashesProjectServiceWrapper = this.this$0;
                boolean $i$f$filterTo2 = false;
                for (T element$iv : $this$filterTo$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)file.getFileSystem(), (Object)LocalFileSystem.getInstance()) && !file.isDirectory() && VfsUtil.isAncestor((VirtualFile)GitHashesProjectServiceWrapper.access$getRootFile$p(gitHashesProjectServiceWrapper), (VirtualFile)file, (boolean)true))) continue;
                    destination$iv.add(element$iv);
                }
                Set allFiles = (Set)destination$iv;
                if (allFiles.isEmpty()) {
                    return null;
                }
                return this.processChanges(allFiles, oldSet, true);
            }

            private final ChangeApplier processChanges(Set<? extends VirtualFile> allFiles, GitBlobSet oldSet, boolean allowRecursion) {
                ChangeApplier changeApplier;
                if (oldSet != null) {
                    Set<GitBlobKey> mappedFiles = oldSet.mapFilesToExistingKeys((Collection<? extends VirtualFile>)allFiles);
                    if (mappedFiles.isEmpty()) {
                        return null;
                    }
                    changeApplier = this.processChangesWithMappedFiles(allFiles, oldSet, mappedFiles, allowRecursion);
                } else {
                    changeApplier = this.processChangesToIgnoreList(allFiles, allowRecursion);
                }
                return changeApplier;
            }

            private final ChangeApplier processChangesToIgnoreList(Set<? extends VirtualFile> allFiles, boolean allowRecursion) {
                return GitHashesProjectServiceWrapper.access$returnObject(this.this$0, () -> vfsListener.1.processChangesToIgnoreList$lambda$3(this.this$0, allowRecursion, this, allFiles));
            }

            private final ChangeApplier processChangesWithMappedFiles(Set<? extends VirtualFile> allFiles, GitBlobSet oldSet, Set<GitBlobKey> mappedFiles, boolean allowRecursion) {
                GitBlobSet newSet = oldSet.withIgnoredItems-GitBlobKey(mappedFiles);
                if (Intrinsics.areEqual((Object)oldSet, (Object)newSet)) {
                    return null;
                }
                return GitHashesProjectServiceWrapper.access$returnObject(this.this$0, () -> vfsListener.1.processChangesWithMappedFiles$lambda$4(this.this$0, allowRecursion, oldSet, this, allFiles, mappedFiles, newSet));
            }

            private static final Unit processChangesToIgnoreList$lambda$3(GitHashesProjectServiceWrapper this$0, boolean $allowRecursion, vfsListener.1 this$1, Set $allFiles) {
                GitBlobSet newOldSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this$0).get();
                if ($allowRecursion && newOldSet != null) {
                    ChangeApplier changeApplier = this$1.processChanges($allFiles, newOldSet, false);
                    if (changeApplier != null) {
                        changeApplier.applyNow();
                    }
                } else {
                    CollectionsKt.addAll((Collection)GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this$0), (Iterable)$allFiles);
                }
                return Unit.INSTANCE;
            }

            private static final Unit processChangesWithMappedFiles$lambda$4(GitHashesProjectServiceWrapper this$0, boolean $allowRecursion, GitBlobSet $oldSet, vfsListener.1 this$1, Set $allFiles, Set $mappedFiles, GitBlobSet $newSet) {
                GitBlobSet gitBlobSet = (GitBlobSet)GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this$0).get();
                if (gitBlobSet == null) {
                    return Unit.INSTANCE;
                }
                GitBlobSet oldSet2 = gitBlobSet;
                if ($allowRecursion && !Intrinsics.areEqual((Object)$oldSet, (Object)oldSet2)) {
                    ChangeApplier changeApplier = this$1.processChangesWithMappedFiles($allFiles, oldSet2, $mappedFiles, false);
                    if (changeApplier != null) {
                        changeApplier.applyNow();
                    }
                } else {
                    GitHashesProjectServiceWrapper.access$getBlobSetHolder$p(this$0).set($newSet);
                    GitHashesProjectServiceWrapper.access$getChangedFilesList$p(this$0).clear();
                }
                return Unit.INSTANCE;
            }
        };
    }

    @Nullable
    public final <Y> Y computeGitHash(@NotNull VirtualFile file, boolean force, @NotNull Function2<? super GitBlobSet, ? super VirtualFile, ? extends Y> action) {
        GitBlobSet blobSet;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!VfsUtil.isAncestor((VirtualFile)this.rootFile, (VirtualFile)file, (boolean)true)) {
            return null;
        }
        GitBlobSet gitBlobSet = blobSet = this.blobSetHolder.get();
        if (gitBlobSet != null) {
            return (Y)action.invoke((Object)gitBlobSet, (Object)file);
        }
        if (!force && this.requestsCount.incrementAndGet() <= Registry.Companion.intValue("shared.index.git.hashes.requestBeforeCompute")) {
            return null;
        }
        if (!this.isCollecting.compareAndSet(false, true)) {
            return null;
        }
        GitHashesServiceKt.access$getLOG$p().info("Starting collecting Git Blob hashes");
        this.startCollecting();
        return null;
    }

    public static /* synthetic */ Object computeGitHash$default(GitHashesProjectServiceWrapper gitHashesProjectServiceWrapper, VirtualFile virtualFile, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return gitHashesProjectServiceWrapper.computeGitHash(virtualFile, bl, function2);
    }

    @VisibleForTesting
    public final void startCollecting() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this.vfsListener, this.lifetime);
        this.driver.resolveGitHashesInBackground((Function1<? super GitBlobSet, Unit>)((Function1)arg_0 -> GitHashesProjectServiceWrapper.startCollecting$lambda$0(this, arg_0)));
    }

    private final returnObject.1 returnObject(Function0<Unit> action) {
        return new ChangeApplier(action){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            public void beforeVfsChange() {
                this.applyNow();
            }

            public void applyNow() {
                this.$action.invoke();
            }
        };
    }

    private static final Unit startCollecting$lambda$0$0(GitHashesProjectServiceWrapper this$0, GitBlobSet $it) {
        GitBlobSet gitBlobSet = $it;
        this$0.blobSetHolder.set(gitBlobSet != null ? gitBlobSet.withIgnoredItems-VirtualFiles((Collection<? extends VirtualFile>)this$0.changedFilesList) : null);
        this$0.changedFilesList.clear();
        return Unit.INSTANCE;
    }

    private static final Unit startCollecting$lambda$0(GitHashesProjectServiceWrapper this$0, GitBlobSet it) {
        ActionsKt.invokeLater$default(null, () -> GitHashesProjectServiceWrapper.startCollecting$lambda$0$0(this$0, it), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicReference access$getBlobSetHolder$p(GitHashesProjectServiceWrapper $this) {
        return $this.blobSetHolder;
    }

    public static final /* synthetic */ VirtualFile access$getRootFile$p(GitHashesProjectServiceWrapper $this) {
        return $this.rootFile;
    }

    public static final /* synthetic */ returnObject.1 access$returnObject(GitHashesProjectServiceWrapper $this, Function0 action) {
        return $this.returnObject((Function0<Unit>)action);
    }

    public static final /* synthetic */ HashSet access$getChangedFilesList$p(GitHashesProjectServiceWrapper $this) {
        return $this.changedFilesList;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapper$ChangeApplier;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "applyNow", "", "intellij.indexing.shared.ultimate.git"})
    private static interface ChangeApplier
    extends AsyncFileListener.ChangeApplier {
        public void applyNow();
    }
}

