/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlBinaryExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getDasType", "Lcom/intellij/database/types/DasType;", "Companion", "intellij.database.dialects.oracle"})
public class OraBinaryExpressionImpl
extends SqlBinaryExpressionImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<DasSimpleBuiltinType, DasSimpleBuiltinType> numberRoots;

    public OraBinaryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)((PsiElement)this), () -> OraBinaryExpressionImpl.getDasType$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getCacheableDasType(...)");
        return dasType;
    }

    private static final DasType getDasType$lambda$0(OraBinaryExpressionImpl this$0) {
        IElementType sign = this$0.getOpSign();
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_AND) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_OR)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_IS)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_IN)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_EQ) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_GE) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_GE_WS) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_GT) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_LE) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_LE_WS) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_LT) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_NEQ) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_NEQ2) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_NEQ3) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_NEQ4) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_NEQ_WS) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_NEQ2_WS) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_NEQ3_WS) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SQL_OP_NEQ4_WS)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_LIKE) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_LIKEC) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_LIKE2) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_LIKE4)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_MEMBER) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_SUBMULTISET)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OVERLAPS)) {
            return (DasType)OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_OP_CONCAT)) {
            return (DasType)OraTypeSystem.VARCHAR2;
        }
        SqlExpression lOperand = this$0.getLOperand();
        if (sign == SqlCommonTokens.SQL_LEFT_BRACKET) {
            return lOperand.getDasType();
        }
        DasType dasType = lOperand.getDasType();
        DasBuiltinType dasBuiltinType = dasType instanceof DasBuiltinType ? (DasBuiltinType)dasType : null;
        if (dasBuiltinType == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        DasBuiltinType lType = dasBuiltinType;
        SqlExpression sqlExpression = this$0.getROperand();
        if (sqlExpression == null) {
            return (DasType)lType;
        }
        SqlExpression rOperand = sqlExpression;
        DasType dasType2 = rOperand.getDasType();
        DasBuiltinType dasBuiltinType2 = dasType2 instanceof DasBuiltinType ? (DasBuiltinType)dasType2 : null;
        if (dasBuiltinType2 == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        DasBuiltinType rType = dasBuiltinType2;
        if (lType.getTypeClass().getCategory().isNumber() && rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS || sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV || sign == OraTypes.ORA_POWER)) {
            lType = (DasBuiltinType)numberRoots.getOrDefault(lType, (DasSimpleBuiltinType)lType);
            rType = (DasBuiltinType)numberRoots.getOrDefault(rType, (DasSimpleBuiltinType)rType);
            if (Intrinsics.areEqual((Object)lType, (Object)OraTypeSystem.BINARY_DOUBLE) || Intrinsics.areEqual((Object)rType, (Object)OraTypeSystem.BINARY_DOUBLE)) {
                return (DasType)OraTypeSystem.BINARY_DOUBLE;
            }
            if (Intrinsics.areEqual((Object)lType, (Object)OraTypeSystem.BINARY_FLOAT) || Intrinsics.areEqual((Object)rType, (Object)OraTypeSystem.BINARY_FLOAT)) {
                return (DasType)OraTypeSystem.BINARY_FLOAT;
            }
            if (sign == OraTypes.ORA_OP_DIV) {
                return (DasType)OraTypeSystem.NUMBER;
            }
            if (Intrinsics.areEqual((Object)lType, (Object)OraTypeSystem.SIMPLE_INTEGER) && Intrinsics.areEqual((Object)rType, (Object)OraTypeSystem.SIMPLE_INTEGER)) {
                return (DasType)OraTypeSystem.SIMPLE_INTEGER;
            }
            if (OraBinaryExpressionImpl.Companion.isBinaryInt(lType) && OraBinaryExpressionImpl.Companion.isBinaryInt(rType)) {
                return (DasType)OraTypeSystem.BINARY_INTEGER;
            }
            return (DasType)OraTypeSystem.NUMBER;
        }
        if (lType.getTypeClass().getCategory() == DasTypeCategory.DATE) {
            if (rType.getTypeClass().getCategory() == DasTypeCategory.DATE && sign == OraTypes.ORA_OP_MINUS) {
                return (DasType)OraTypeSystem.NUMBER;
            }
            if (!(!rType.getTypeClass().getCategory().isNumber() && rType.getTypeClass().getCategory() != DasTypeCategory.INTERVAL || sign != OraTypes.ORA_OP_PLUS && sign != OraTypes.ORA_OP_MINUS)) {
                return (DasType)lType;
            }
            if (rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP && sign == OraTypes.ORA_OP_MINUS) {
                return (DasType)OraTypeSystem.INTERVAL_DAY_TO_SECOND;
            }
        }
        if (lType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP) {
            if (rType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                return (DasType)lType;
            }
            if (rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                return (DasType)OraTypeSystem.DATE;
            }
            if ((rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP || rType.getTypeClass().getCategory() == DasTypeCategory.DATE) && sign == OraTypes.ORA_OP_MINUS) {
                return (DasType)OraTypeSystem.INTERVAL_DAY_TO_SECOND;
            }
        }
        if (lType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL) {
            if (Intrinsics.areEqual((Object)rType, (Object)lType) && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                return (DasType)lType;
            }
            if ((rType.getTypeClass().getCategory() == DasTypeCategory.DATE || rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP) && sign == OraTypes.ORA_OP_PLUS) {
                return (DasType)rType;
            }
            if (rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV)) {
                return (DasType)lType;
            }
        }
        if (lType.getTypeClass().getCategory().isNumber()) {
            if ((rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP || rType.getTypeClass().getCategory() == DasTypeCategory.DATE) && sign == OraTypes.ORA_OP_PLUS) {
                return (DasType)OraTypeSystem.DATE;
            }
            if (rType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL && sign == OraTypes.ORA_OP_MUL) {
                return (DasType)rType;
            }
        }
        return (DasType)DasTypeSystemBase.UNKNOWN;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OraTypeSystem.NATURAL, (Object)OraTypeSystem.BINARY_INTEGER), TuplesKt.to((Object)OraTypeSystem.POSITIVE, (Object)OraTypeSystem.BINARY_INTEGER), TuplesKt.to((Object)OraTypeSystem.SIGNTYPE, (Object)OraTypeSystem.BINARY_INTEGER), TuplesKt.to((Object)OraTypeSystem.NATURALN, (Object)OraTypeSystem.SIMPLE_INTEGER), TuplesKt.to((Object)OraTypeSystem.POSITIVEN, (Object)OraTypeSystem.SIMPLE_INTEGER)};
        numberRoots = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl$Companion;", "", "<init>", "()V", "numberRoots", "", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "isBinaryInt", "", "type", "Lcom/intellij/database/types/DasBuiltinType;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isBinaryInt(DasBuiltinType<?> type) {
            return Intrinsics.areEqual(type, (Object)OraTypeSystem.BINARY_INTEGER) || Intrinsics.areEqual(type, (Object)OraTypeSystem.SIMPLE_INTEGER);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

