/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.types.OraAssociativeArrayType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.types.DasType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlBiConstructedTypeElementBase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraCollectionTypeElementImpl;", "Lcom/intellij/sql/psi/impl/SqlBiConstructedTypeElementBase;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "kind", "Lcom/intellij/database/dialects/oracle/model/properties/OraCollectionTypeKind;", "getKind", "()Lcom/intellij/database/dialects/oracle/model/properties/OraCollectionTypeKind;", "createDasType", "Lcom/intellij/database/types/DasType;", "leftType", "rightType", "intellij.database.dialects.oracle"})
public final class OraCollectionTypeElementImpl
extends SqlBiConstructedTypeElementBase {
    public OraCollectionTypeElementImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public final OraCollectionTypeKind getKind() {
        IElementType starterType = PsiTreeUtilKt.getElementType((PsiElement)this.getFirstChild());
        if (Intrinsics.areEqual((Object)starterType, (Object)OraTypes.ORA_VARYING) || Intrinsics.areEqual((Object)starterType, (Object)OraTypes.ORA_VARRAY)) {
            return OraCollectionTypeKind.VARIABLE_SIZE_ARRAY;
        }
        if (this.findChildByType(OraTypes.ORA_INDEX) != null) {
            return OraCollectionTypeKind.ASSOCIATIVE_ARRAY;
        }
        return OraCollectionTypeKind.NESTED_TABLE;
    }

    @NotNull
    protected DasType createDasType(@NotNull DasType leftType, @NotNull DasType rightType) {
        Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
        Intrinsics.checkNotNullParameter((Object)rightType, (String)"rightType");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getKind().ordinal()]) {
            case 1 -> (DasType)new OraAssociativeArrayType(leftType, rightType);
            case 2 -> (DasType)new OraNestedTableType(leftType);
            case 3 -> {
                PsiElement maxSizePsi;
                PsiElement v1 = maxSizePsi = this.findPsiChildByType((IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL);
                int maxSize = StringUtil.parseInt((String)(v1 != null ? v1.getText() : null), (int)0);
                yield (DasType)new OraVaryingArrayType(maxSize, leftType);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OraCollectionTypeKind.values().length];
            try {
                nArray[OraCollectionTypeKind.ASSOCIATIVE_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.NESTED_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.VARIABLE_SIZE_ARRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

