/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.statistics.JSDebuggerStatsCollectorKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;
import org.jetbrains.wip.BrowserWipVm;
import org.jetbrains.wip.LoadedScriptsStatistics;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.WipVm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/statistics/JSDebuggerStatsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "vmTypeField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/javascript/debugger/statistics/JSDebuggerStatsCollector$VmType;", "numberOfLoadedScriptsField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "numberOfLoadedScriptsWithSourceMapField", "sessionFinishedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "logSessionFinished", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "VmType", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJSDebuggerStatsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDebuggerStatsCollector.kt\ncom/intellij/javascript/debugger/statistics/JSDebuggerStatsCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,48:1\n261#2,3:49\n*S KotlinDebug\n*F\n+ 1 JSDebuggerStatsCollector.kt\ncom/intellij/javascript/debugger/statistics/JSDebuggerStatsCollector\n*L\n22#1:49,3\n*E\n"})
public final class JSDebuggerStatsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JSDebuggerStatsCollector INSTANCE;
    @NotNull
    private static final EnumEventField<VmType> vmTypeField;
    @NotNull
    private static final IntEventField numberOfLoadedScriptsField;
    @NotNull
    private static final IntEventField numberOfLoadedScriptsWithSourceMapField;
    @NotNull
    private static final EventId3<VmType, Integer, Integer> sessionFinishedEvent;

    private JSDebuggerStatsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return JSDebuggerStatsCollectorKt.getGROUP();
    }

    public final void logSessionFinished(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Vm vm = debugProcess.getMainVm();
        WipVm wipVm = vm instanceof WipVm ? (WipVm)vm : null;
        if (wipVm == null) {
            return;
        }
        WipVm mainVm = wipVm;
        vm = mainVm;
        VmType vmType = vm instanceof BrowserWipVm ? VmType.Browser : (vm instanceof NodeWipVm ? VmType.Node : VmType.Unknown);
        LoadedScriptsStatistics scriptStats = mainVm.getScriptManager().reportScriptStats();
        sessionFinishedEvent.log(debugProcess.getSession().getProject(), (Object)vmType, (Object)scriptStats.getTotalScriptsCount(), (Object)scriptStats.getScriptsWithSourceMapCount());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new JSDebuggerStatsCollector();
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "vmType";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        vmTypeField = new EnumEventField(name$iv, VmType.class, null, transform$iv);
        numberOfLoadedScriptsField = EventFields.Int((String)"numberOfLoadedScripts");
        numberOfLoadedScriptsWithSourceMapField = EventFields.Int((String)"numberOfLoadedScriptsWithSourceMap");
        sessionFinishedEvent = JSDebuggerStatsCollectorKt.getGROUP().registerEvent("session.finished", (EventField)vmTypeField, (EventField)numberOfLoadedScriptsField, (EventField)numberOfLoadedScriptsWithSourceMapField);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/statistics/JSDebuggerStatsCollector$VmType;", "", "<init>", "(Ljava/lang/String;I)V", "Browser", "Node", "Unknown", "intellij.javascript.debugger.backend"})
    private static final class VmType
    extends Enum<VmType> {
        public static final /* enum */ VmType Browser = new VmType();
        public static final /* enum */ VmType Node = new VmType();
        public static final /* enum */ VmType Unknown = new VmType();
        private static final /* synthetic */ VmType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VmType[] values() {
            return (VmType[])$VALUES.clone();
        }

        public static VmType valueOf(String value) {
            return Enum.valueOf(VmType.class, value);
        }

        @NotNull
        public static EnumEntries<VmType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vmTypeArray = new VmType[]{VmType.Browser, VmType.Node, VmType.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

