/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ForcefulReparseModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/psi/types/PyLibraryModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myProjectRootManager", "myDumbServiceModificationTracker", "myForcefulReparseModificationTracker", "myOnContentReloadModificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "creationStack", "", "projectLibraryScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getProjectLibraryScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "isLibraryFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModificationCount", "", "dispose", "", "Companion", "intellij.python.psi"})
public final class PyLibraryModificationTracker
implements ModificationTracker,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModificationTracker myProjectRootManager;
    @NotNull
    private final ModificationTracker myDumbServiceModificationTracker;
    @NotNull
    private final ModificationTracker myForcefulReparseModificationTracker;
    @NotNull
    private final SimpleModificationTracker myOnContentReloadModificationTracker;
    @NotNull
    private final Throwable creationStack;
    @NotNull
    private final GlobalSearchScope projectLibraryScope;
    @NotNull
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(Logger.getInstance(PyLibraryModificationTracker.class), TimeUnit.SECONDS.toMillis(30L));

    public PyLibraryModificationTracker(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"getInstance(...)");
        this.myProjectRootManager = (ModificationTracker)projectRootManager;
        this.myDumbServiceModificationTracker = DumbService.Companion.getInstance(project).getModificationTracker();
        ModificationTracker modificationTracker = ForcefulReparseModificationTracker.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getInstance(...)");
        this.myForcefulReparseModificationTracker = modificationTracker;
        this.myOnContentReloadModificationTracker = new SimpleModificationTracker();
        this.creationStack = new Throwable();
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(...)");
        this.projectLibraryScope = globalSearchScope;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childrenChanged(PsiTreeChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PsiFile psiFile = event.getFile();
                if (psiFile == null) {
                    return;
                }
                PsiFile file = psiFile;
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                if (this.isLibraryFile(virtualFile2)) {
                    myOnContentReloadModificationTracker.incModificationCount();
                }
            }
        }, (Disposable)this);
        Topic topic = FileDocumentManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new FileDocumentManagerListener(){

            public void fileWithNoDocumentChanged(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!project.isInitialized()) {
                    THROTTLED_LOG.warn("SearchScope.contains(file) would log an error because WorkspaceFileIndex is not yet initialized. Probably LibraryModificationTracker was created too early. See LibraryModificationTracker creation stacktrace: ", creationStack);
                    return;
                }
                if (this.isLibraryFile(file)) {
                    myOnContentReloadModificationTracker.incModificationCount();
                }
            }
        });
    }

    @NotNull
    public final GlobalSearchScope getProjectLibraryScope() {
        return this.projectLibraryScope;
    }

    private final boolean isLibraryFile(VirtualFile file) {
        return Intrinsics.areEqual((Object)"pyi", (Object)file.getExtension()) || this.projectLibraryScope.contains(file);
    }

    public long getModificationCount() {
        return this.myProjectRootManager.getModificationCount() + this.myDumbServiceModificationTracker.getModificationCount() + this.myForcefulReparseModificationTracker.getModificationCount() + this.myOnContentReloadModificationTracker.getModificationCount();
    }

    public void dispose() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/psi/types/PyLibraryModificationTracker$Companion;", "", "<init>", "()V", "THROTTLED_LOG", "Lcom/intellij/openapi/diagnostic/ThrottledLogger;", "getInstance", "Lcom/jetbrains/python/psi/types/PyLibraryModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.psi"})
    @SourceDebugExtension(value={"SMAP\nPyLibraryModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLibraryModificationTracker.kt\ncom/jetbrains/python/psi/types/PyLibraryModificationTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n*S KotlinDebug\n*F\n+ 1 PyLibraryModificationTracker.kt\ncom/jetbrains/python/psi/types/PyLibraryModificationTracker$Companion\n*L\n78#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PyLibraryModificationTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PyLibraryModificationTracker> serviceClass$iv = PyLibraryModificationTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PyLibraryModificationTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

