/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.util.ArrayUtilRt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/psi/css/impl/util/table/CssVendorSpecificPropertyUtil;", "", "<init>", "()V", "getVendorPrefix", "", "propertyName", "isVendorSpecificElement", "", "getElementNameWithoutVendorPrefix", "elementName", "intellij.css.common.psi"})
public final class CssVendorSpecificPropertyUtil {
    @NotNull
    public static final CssVendorSpecificPropertyUtil INSTANCE = new CssVendorSpecificPropertyUtil();

    private CssVendorSpecificPropertyUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String getVendorPrefix(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (propertyName.length() >= 4) {
            Intrinsics.checkNotNullExpressionValue((Object)CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES, (String)"VENDOR_SPECIFIC_ELEMENT_PREFIXES");
            for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
                Intrinsics.checkNotNull((Object)s);
                if (!StringsKt.startsWith$default((String)propertyName, (String)s, (boolean)false, (int)2, null)) continue;
                return s;
            }
        }
        return "";
    }

    @JvmStatic
    public static final boolean isVendorSpecificElement(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (propertyName.length() < 4) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES, (String)"VENDOR_SPECIFIC_ELEMENT_PREFIXES");
        for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
            Intrinsics.checkNotNull((Object)s);
            if (!StringsKt.startsWith$default((String)propertyName, (String)s, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return ArrayUtilRt.find((Object[])CssElementDescriptorConstants.IE_PROPERTIES, (Object)propertyName) >= 0;
    }

    @JvmStatic
    @NotNull
    public static final String getElementNameWithoutVendorPrefix(@NotNull String elementName) {
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        if (elementName.length() < 4) {
            return elementName;
        }
        Intrinsics.checkNotNullExpressionValue((Object)CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES, (String)"VENDOR_SPECIFIC_ELEMENT_PREFIXES");
        for (String s : CssElementDescriptorConstants.VENDOR_SPECIFIC_ELEMENT_PREFIXES) {
            Intrinsics.checkNotNull((Object)s);
            if (!StringsKt.startsWith$default((String)elementName, (String)s, (boolean)false, (int)2, null)) continue;
            String string = elementName.substring(s.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return elementName;
    }
}

