/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.auth.impl;

import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.jupyter.py.colab.auth.impl.GoogleCredentials;
import com.intellij.jupyter.py.colab.auth.impl.GoogleOAuthCredentialsAcquirer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/jupyter/py/colab/auth/impl/GoogleCredentials;", "<init>", "()V", "port", "", "getPort", "()I", "codeVerifier", "", "getCodeVerifier$intellij_jupyter_py_colab", "()Ljava/lang/String;", "codeChallenge", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "authUrlWithParameters", "getAuthUrlWithParameters", "Companion", "intellij.jupyter.py.colab"})
public final class GoogleOAuthRequest
implements OAuthRequest<GoogleCredentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
    @NotNull
    private final String codeChallenge;
    @NotNull
    private final OAuthCredentialsAcquirer<GoogleCredentials> credentialsAcquirer;
    @NotNull
    private static final Url AUTH_URL = Urls.newFromEncoded((String)"https://accounts.google.com/o/oauth2/v2/auth");
    @NotNull
    private static final List<String> SCOPES;

    public GoogleOAuthRequest() {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"withoutPadding(...)");
        this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
        this.credentialsAcquirer = new GoogleOAuthCredentialsAcquirer(this);
    }

    private final int getPort() {
        return BuiltInServerManager.Companion.getInstance().getPort();
    }

    @NotNull
    public final String getCodeVerifier$intellij_jupyter_py_colab() {
        return this.codeVerifier;
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return Urls.newFromEncoded((String)("http://127.0.0.1:" + this.getPort() + "/api/google/colab/oauth/authorization_code"));
    }

    @NotNull
    public OAuthCredentialsAcquirer<GoogleCredentials> getCredentialsAcquirer() {
        return this.credentialsAcquirer;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)"745829361237-p4pr918qut71sv8h0ljtq2v8g6ua4bsp.apps.googleusercontent.com"), TuplesKt.to((Object)"redirect_uri", (Object)this.getAuthorizationCodeUrl().toExternalForm()), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"scope", (Object)CollectionsKt.joinToString$default((Iterable)SCOPES, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"code_challenge", (Object)this.codeChallenge), TuplesKt.to((Object)"code_challenge_method", (Object)"S256"), TuplesKt.to((Object)"access_type", (Object)"offline"), TuplesKt.to((Object)"prompt", (Object)"select_account")};
        Url url = AUTH_URL.addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    static {
        Object[] objectArray = new String[]{"profile", "email", "https://www.googleapis.com/auth/colaboratory"};
        SCOPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthRequest$Companion;", "", "<init>", "()V", "AUTH_URL", "Lcom/intellij/util/Url;", "SCOPES", "", "", "intellij.jupyter.py.colab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

