/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.uploadFileFilter;

import com.intellij.execution.filters.Filter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.JupyterErrorOutputFiltersProvider;
import com.intellij.jupyter.py.colab.assignments.ColabAssignedServer;
import com.intellij.jupyter.py.colab.uploadFileFilter.UploadFileFilterFirst;
import com.intellij.jupyter.py.colab.uploadFileFilter.UploadFileFilterSecond;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/colab/uploadFileFilter/ColabUploadFileFiltersProvider;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputFiltersProvider;", "<init>", "()V", "getFilters", "", "Lcom/intellij/execution/filters/Filter;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "exceptionType", "", "exceptionValue", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractFilePathFromExceptionValue", "intellij.jupyter.py.colab"})
public final class ColabUploadFileFiltersProvider
implements JupyterErrorOutputFiltersProvider {
    @Nullable
    public Object getFilters(@NotNull EditorImpl editor, @NotNull String exceptionType, @NotNull String exceptionValue, @NotNull Continuation<? super List<? extends Filter>> $completion) {
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile2);
        if (backedNotebookVirtualFile == null) {
            return CollectionsKt.emptyList();
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault(backedNotebookVirtualFile2, project2);
        if (!(config instanceof ColabAssignedServer)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)exceptionType, (Object)"FileNotFoundError")) {
            String filePath = this.extractFilePathFromExceptionValue(exceptionValue);
            Object[] objectArray = new Filter[]{new UploadFileFilterFirst(backedNotebookVirtualFile2, filePath), new UploadFileFilterSecond(backedNotebookVirtualFile2, filePath)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return CollectionsKt.emptyList();
    }

    private final String extractFilePathFromExceptionValue(String exceptionValue) {
        Regex[] regexArray = new Regex[]{new Regex("['\"]([^'\"]+)['\"]"), new Regex(":\\s*([^\\s]+)$")};
        List patterns = CollectionsKt.listOf((Object[])regexArray);
        for (Regex pattern : patterns) {
            MatchResult match = Regex.find$default((Regex)pattern, (CharSequence)exceptionValue, (int)0, (int)2, null);
            if (match == null) continue;
            return (String)match.getGroupValues().get(1);
        }
        return null;
    }
}

