/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.postgresbase.introspector.IntroGuidance;
import com.intellij.database.dialects.postgresbase.introspector.IntroModeCtx;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgAclItem;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseArgument;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseGrantsHolder;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseMajorSchemaObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoot;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospectorKt;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAccessMethod;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseAggregate;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseArgument;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseCatalogObject;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseCheck;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseCollation;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefTypeCheck;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseExtension;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseForeignDataWrapper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseForeignServer;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseForeignTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseForeignTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseIndex;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseKey;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeMatTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseMatView;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperator;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperatorAmHolder;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperatorClass;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperatorFamily;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoot;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRule;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTablespace;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseUserMapping;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseUtil;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseView;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAccessMethodType;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAggregateKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAmOp;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgAmProc;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgFireMode;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgPersistence;
import com.intellij.database.dialects.postgresgreenplumbase.model.properties.PgRoleGrant;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\b&\u0018\u0000 `*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0004`abcB)\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J&\u0010\u001c\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0014J \u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0014J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010-\u001a\u00020#H\u0002J'\u0010/\u001a\u00020%*\u00028\u00002\u0006\u00100\u001a\u00020\u001b2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020 H\u0002\u00a2\u0006\u0002\u00103J \u00104\u001a\u00020%2\u0006\u0010-\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J \u00105\u001a\u00020%2\u0006\u0010-\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0014J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0014J\b\u0010;\u001a\u00020%H\u0014J)\u0010<\u001a\u00020%\"\b\b\u0003\u0010=*\u00020>2\u0006\u0010?\u001a\u0002H=2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016\u00a2\u0006\u0002\u0010BJ5\u0010C\u001a\u0004\u0018\u00010D\"\b\b\u0003\u0010E*\u00020F2\u0006\u0010G\u001a\u0002HE2\b\u0010H\u001a\u0004\u0018\u00010D2\b\u0010I\u001a\u0004\u0018\u00010DH\u0014\u00a2\u0006\u0002\u0010JJ\u0018\u0010K\u001a\u00020%2\u0006\u0010I\u001a\u00020L2\u0006\u0010H\u001a\u00020MH\u0002Jb\u0010N\u001a\u00020%\"\b\b\u0003\u0010=*\u00020O\"\u0010\b\u0004\u0010P*\n\u0012\u0006\b\u0001\u0012\u0002H=0Q2\u0006\u0010I\u001a\u00020L2\u0006\u0010H\u001a\u00020M2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u0002HP0S2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u0002H=\u0012\u0004\u0012\u0002H=0TH\u0002J\u0010\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020WH\u0014J\u0018\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001b0Y2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0004J2\u0010\\\u001a\b\u0012\u0004\u0012\u0002H=0Y\"\u0004\b\u0003\u0010=2\b\u0010Z\u001a\u0004\u0018\u00010[2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u0002H=0SH\u0004J\u0018\u0010^\u001a\b\u0012\u0004\u0012\u00020\u001b0_2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0002R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "MR", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoot;", "D", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;", "SL", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "factory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "queries", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "myServerStartupTime", "", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "trans", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "retrieveComments", "", "detectDropped", "", "loadNew", "removeDroppedServerComments", "commentsIds", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "retrieveRoles", "tran", "retrieveRoleGrants", "applyRoleGrants", "id", "grants", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/properties/PgRoleGrant;", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoot;JLjava/util/List;)V", "retrieveAcls", "retrieveTablespaces", "processRole", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "r", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneRole;", "initConnectionRelatedState", "processArgExtra", "T", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;", "argument", "argMode", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;Ljava/lang/Character;)V", "preventDuplicatedRelationForSchema", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "schema", "newRelation", "existing", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "copyObjects", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLocalTable;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseView;", "copyFamily", "Lcom/intellij/database/model/basic/BasicModElement;", "F", "Lcom/intellij/database/model/families/ModFamily;", "familyGetter", "Lkotlin/Function1;", "Lkotlin/Function2;", "isNameSurrogate", "columniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "parseListOfLongs", "", "str", "", "parseList", "converter", "parseSmallSetOfLongs", "", "Companion", "PgGPlumBaseDatabaseRetriever", "PgGPlumBaseNativeRetriever", "PgGPlumBaseSchemaRetriever", "intellij.database.dialects.postgresgreenplumbase"})
@SourceDebugExtension(value={"SMAP\nPgGPlumBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1306:1\n521#2:1307\n502#2,18:1308\n521#2:1326\n502#2,18:1327\n521#2:1345\n502#2,18:1346\n521#2:1369\n502#2,18:1370\n521#2:1397\n502#2,2:1398\n505#2,15:1402\n1#3:1364\n179#4,4:1365\n183#4,3:1388\n179#4,4:1393\n183#4,3:1417\n14060#5,2:1391\n14088#5,2:1400\n*S KotlinDebug\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector\n*L\n79#1:1307\n79#1:1308,18\n113#1:1326\n113#1:1327,18\n137#1:1345\n137#1:1346,18\n101#1:1369\n101#1:1370,18\n160#1:1397\n160#1:1398,2\n160#1:1402,15\n100#1:1365,4\n100#1:1388,3\n159#1:1393,4\n159#1:1417,3\n149#1:1391,2\n162#1:1400,2\n*E\n"})
public abstract class PgGPlumBaseIntrospector<MR extends PgGPlumBaseRoot, D extends PgGPlumBaseDatabase, SL extends PgBaseLikeSchema>
extends PgBaseIntrospector<MR, D, SL> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long myServerStartupTime;
    @NotNull
    private static final Map<ObjectKind, String> NATIVE_DEFINITIONS_QUERIES;

    public PgGPlumBaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory factory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(context, nature, dbms, factory);
        this.myServerStartupTime = -1L;
    }

    @NotNull
    protected abstract PgGPlumBaseIntroQueries getQueries();

    @NotNull
    protected abstract PgGPlumBaseModelHelper getHelper();

    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return (BaseMultiDatabaseIntrospector.DatabaseLister)new BaseMultiDatabaseIntrospector.DatabaseLister<PgGPlumBaseIntroQueries.OneDatabase, PgGPlumBaseDatabase>(this){
            final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;
            {
                this.this$0 = $receiver;
                super((BaseMultiDatabaseIntrospector)$receiver);
            }

            /*
             * WARNING - void declaration
             */
            protected List<PgGPlumBaseIntroQueries.OneDatabase> listDatabases(DBTransaction tran) {
                List list;
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                Object object = this.this$0.performQuery(tran, this.this$0.getQueries().getListDatabases());
                PgGPlumBaseIntrospector<MR, D, SL> pgGPlumBaseIntrospector = this.this$0;
                List dbs = (List)object;
                boolean bl = false;
                if (!PgGPlumBaseIntrospector.access$getShowTemplateDbs(pgGPlumBaseIntrospector)) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = dbs;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        PgGPlumBaseIntroQueries.OneDatabase it = (PgGPlumBaseIntroQueries.OneDatabase)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!it.is_template)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = dbs;
                }
                return list;
            }

            protected PgGPlumBaseDatabase applyDatabase(ModNamingFamily<?> databases, PgGPlumBaseIntroQueries.OneDatabase db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                BasicModMateDatabase basicModMateDatabase = this.renew(databases, db.id, db.name);
                PgGPlumBaseDatabase $this$applyDatabase_u24lambda_u241 = (PgGPlumBaseDatabase)basicModMateDatabase;
                boolean bl = false;
                $this$applyDatabase_u24lambda_u241.setComment(db.description);
                $this$applyDatabase_u24lambda_u241.setOwnerRef((BasicReference)BasicNameReference.create((String)db.getOwnerName()));
                $this$applyDatabase_u24lambda_u241.setTemplate(db.is_template);
                $this$applyDatabase_u24lambda_u241.setAllowConnections(db.allow_connections);
                $this$applyDatabase_u24lambda_u241.setTablespaceRef((BasicReference)BasicIdReference.create((long)db.tablespace_id));
                return (PgGPlumBaseDatabase)basicModMateDatabase;
            }

            protected boolean shouldUpdateCurrent(Iterable<?> databases) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                return CollectionsKt.firstOrNull(databases) == null;
            }
        };
    }

    @NotNull
    protected List<IntroStep> steps(@NotNull DBTransaction trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)super.steps(trans), (int)60, null, null, arg_0 -> PgGPlumBaseIntrospector.steps$lambda$0(this, trans, arg_0), (int)6, null), (int)70, null, null, arg_0 -> PgGPlumBaseIntrospector.steps$lambda$1(this, trans, arg_0), (int)6, null), (int)80, null, null, arg_0 -> PgGPlumBaseIntrospector.steps$lambda$2(this, trans, arg_0), (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void retrieveComments(@NotNull DBTransaction trans, boolean detectDropped, boolean loadNew) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            LongOpenHashSet commentsIds = detectDropped ? new LongOpenHashSet((long[])BaseNativeIntrospector.performQuery$default((BaseNativeIntrospector)((BaseNativeIntrospector)this), (SqlQuery)this.getQueries().getListExistentDatabaseComments(), null, (int)2, null)) : new LongOpenHashSet();
            this.removeDroppedServerComments(commentsIds);
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    private final void removeDroppedServerComments(LongOpenHashSet commentsIds) {
        this.inModel(arg_0 -> PgGPlumBaseIntrospector.removeDroppedServerComments$lambda$0(commentsIds, arg_0));
    }

    private final void retrieveRoles(DBTransaction tran) {
        this.inModel(arg_0 -> PgGPlumBaseIntrospector.retrieveRoles$lambda$0(this, tran, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveRoleGrants(DBTransaction tran) {
        Ref.LongRef id = new Ref.LongRef();
        id.element = Long.MIN_VALUE;
        ArrayList grants = new ArrayList();
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            this.inModel(arg_0 -> PgGPlumBaseIntrospector.retrieveRoleGrants$lambda$0$0(this, tran, id, grants, arg_0));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    private final void applyRoleGrants(MR $this$applyRoleGrants, long id, List<PgRoleGrant> grants) {
        if (id != Long.MIN_VALUE) {
            PgGPlumBaseRole pgGPlumBaseRole = (PgGPlumBaseRole)$this$applyRoleGrants.getRoles().getByObjectId(id);
            if (pgGPlumBaseRole != null) {
                pgGPlumBaseRole.setRoleGrants(grants);
            }
        }
        grants.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveAcls(DBTransaction tran, boolean detectDropped, boolean loadNew) {
        this.reportRetrieving("ACL", "introspection.retrieve.ACL");
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            this.inModel(arg_0 -> PgGPlumBaseIntrospector.retrieveAcls$lambda$0$0(detectDropped, loadNew, this, tran, arg_0));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    protected void retrieveTablespaces(@NotNull DBTransaction tran, boolean detectDropped, boolean loadNew) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.inModel(arg_0 -> PgGPlumBaseIntrospector.retrieveTablespaces$lambda$0(this, detectDropped, tran, loadNew, arg_0));
    }

    protected void processRole(@NotNull PgGPlumBaseRole role, @NotNull PgGPlumBaseIntroQueries.OneRole r) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        role.setSuperRole(r.is_super);
        role.setInherit(r.is_inherit);
        role.setCreateRole(r.can_createrole);
        role.setCreateDb(r.can_createdb);
        role.setCanLogin(r.can_login);
        Long l = r.conn_limit;
        role.setConnectionLimit(l != null ? l : -1L);
        role.setValidUntil(r.valid_until);
        Object object = r.config;
        if (r.config == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        role.setConfig((List)object);
        role.setComment(r.description);
    }

    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        if (this.myServerStartupTime == -1L && !this.getOptions().getSkipModelContentValidation()) {
            this.myServerStartupTime = ((Number)BaseNativeIntrospector.performQuery$default((BaseNativeIntrospector)((BaseNativeIntrospector)this), this.getQueries().getServerStartupTime(), null, (int)2, null)).longValue();
            BasicModModel basicModModel = this.getMyModel();
            if (basicModModel == null) {
                return;
            }
            BasicModModel m = basicModModel;
            BasicRoot basicRoot = m.getRoot();
            PgGPlumBaseRoot pgGPlumBaseRoot = basicRoot instanceof PgGPlumBaseRoot ? (PgGPlumBaseRoot)basicRoot : null;
            if (pgGPlumBaseRoot == null) {
                return;
            }
            PgGPlumBaseRoot root = pgGPlumBaseRoot;
            long modelStartupTime = root.getStartupTime();
            if (modelStartupTime != this.myServerStartupTime) {
                if (this.getModel().getRoot().getChildren().isNotEmpty()) {
                    this.log.info("Resetting the model tx ids");
                    ProgressIndicator progressIndicator = this.getProgressIndicator();
                    if (progressIndicator != null) {
                        Object[] objectArray = new Object[]{m.getDbms().getDisplayName()};
                        progressIndicator.setText(DatabaseBundle.message((String)"progress.text.resetting.model.transaction.ids", (Object[])objectArray));
                    }
                    m.modify((BasicElement)this.getModel().getRoot(), PgGPlumBaseRoot.class, new ModelModifier(this){
                        final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void perform(PgGPlumBaseRoot r) {
                            r.setIntrospectionStateNumber(0L);
                            for (PgGPlumBaseDatabase database : r.getDatabases()) {
                                database.setIntrospectionStateNumber(0L);
                                for (PgGPlumBaseSchema schema : database.getSchemas()) {
                                    schema.setLastIntrospectionL1Xid(0L);
                                    schema.setLastIntrospectionL2Xid(0L);
                                    schema.setLastIntrospectionL3Xid(0L);
                                }
                            }
                            r.setStartupTime(PgGPlumBaseIntrospector.access$getMyServerStartupTime$p(this.this$0));
                        }
                    });
                } else {
                    m.modify((BasicElement)this.getModel().getRoot(), PgGPlumBaseRoot.class, new ModelModifier(this){
                        final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void perform(PgGPlumBaseRoot r) {
                            r.setStartupTime(PgGPlumBaseIntrospector.access$getMyServerStartupTime$p(this.this$0));
                        }
                    });
                }
            }
        }
    }

    public <T extends PgBaseArgument> void processArgExtra(@NotNull T argument, @Nullable Character argMode) {
        block0: {
            Intrinsics.checkNotNullParameter(argument, (String)"argument");
            PgGPlumBaseArgument pgGPlumBaseArgument = argument instanceof PgGPlumBaseArgument ? (PgGPlumBaseArgument)argument : null;
            if (pgGPlumBaseArgument == null) break block0;
            Character c = argMode;
            char c2 = 'v';
            pgGPlumBaseArgument.setVariadic(c != null && c.charValue() == c2);
        }
    }

    @Nullable
    protected <S extends PgBaseSchema> PgBaseLikeStoredTable preventDuplicatedRelationForSchema(@NotNull S schema, @Nullable PgBaseLikeStoredTable newRelation, @Nullable PgBaseLikeStoredTable existing) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        if (existing != null && newRelation != null && Intrinsics.areEqual((Object)existing.getSchema(), schema) && !Intrinsics.areEqual((Object)existing, (Object)newRelation) && existing instanceof PgGPlumBaseLocalTable && newRelation instanceof PgGPlumBaseView) {
            this.copyObjects((PgGPlumBaseLocalTable)existing, (PgGPlumBaseView)newRelation);
        }
        return super.preventDuplicatedRelationForSchema(schema, newRelation, existing);
    }

    private final void copyObjects(PgGPlumBaseLocalTable existing, PgGPlumBaseView newRelation) {
        this.copyFamily(existing, newRelation, PgGPlumBaseIntrospector::copyObjects$lambda$0, PgGPlumBaseIntrospector::copyObjects$lambda$1);
        this.copyFamily(existing, newRelation, PgGPlumBaseIntrospector::copyObjects$lambda$2, PgGPlumBaseIntrospector::copyObjects$lambda$3);
    }

    private final <T extends BasicModElement, F extends ModFamily<? extends T>> void copyFamily(PgGPlumBaseLocalTable existing, PgGPlumBaseView newRelation, Function1<? super PgGPlumBaseLocalTable, ? extends F> familyGetter, Function2<? super PgGPlumBaseView, ? super T, ? extends T> factory) {
        for (BasicModElement item : (ModFamily)familyGetter.invoke((Object)existing)) {
            Intrinsics.checkNotNull((Object)item);
            BasicModElement viewItem = (BasicModElement)factory.invoke((Object)newRelation, (Object)item);
            BasicMetaUtils.copyMatchedProperties((BasicElement)((BasicElement)item), (BasicModElement)viewItem, (boolean)false, (boolean)false, (boolean)false);
        }
    }

    protected boolean isNameSurrogate(@NotNull BasicModColumniation columniation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)columniation, (String)"columniation");
        if (columniation instanceof PgGPlumBaseIndex) {
            String string = ((PgGPlumBaseIndex)columniation).getName();
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = ((PgGPlumBaseIndex)columniation).getTable();
            String string2 = pgGPlumBaseLikeStoredTable != null ? pgGPlumBaseLikeStoredTable.getName() : null;
            boolean bl2 = ((PgGPlumBaseIndex)columniation).isPrimary();
            List list = ((PgGPlumBaseIndex)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)this.surrogateKeyName(string2, bl2, list));
        } else {
            bl = super.isNameSurrogate(columniation);
        }
        return bl;
    }

    @NotNull
    protected final List<Long> parseListOfLongs(@Nullable String str) {
        return this.parseList(str, PgGPlumBaseIntrospector::parseListOfLongs$lambda$0);
    }

    @NotNull
    protected final <T> List<T> parseList(@Nullable String str, @NotNull Function1<? super String, ? extends T> converter) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        String[] strings = PgBaseIntrospectorKt.parseArrayOfStrings((String)str);
        int n = strings.length;
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Object> list2 = new ArrayList<Object>(n);
        for (String string : strings) {
            try {
                String s = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (((CharSequence)s).length() == 0) continue;
                Object value = converter.invoke((Object)s);
                list2.add(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (list2.size()) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                List<Object> list3 = Collections.singletonList(CollectionsKt.first((List)list2));
                list = list3;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(...)");
                break;
            }
            default: {
                list = list2;
            }
        }
        return list;
    }

    private final Set<Long> parseSmallSetOfLongs(String str) {
        Set set;
        List<Long> list = this.parseListOfLongs(str);
        switch (list.size()) {
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            case 1: {
                Set set2 = Collections.singleton(CollectionsKt.first(list));
                set = set2;
                Intrinsics.checkNotNullExpressionValue(set2, (String)"singleton(...)");
                break;
            }
            default: {
                set = new TreeSet(list);
            }
        }
        return set;
    }

    private static final Unit steps$lambda$0(PgGPlumBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        this$0.retrieveRoles($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$1(PgGPlumBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        this$0.retrieveRoleGrants($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$2(PgGPlumBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        IntroGuidance $this$steps_u24lambda_u242_u240 = $this$add.getGuidanceForOthers();
        boolean bl = false;
        this$0.retrieveTablespaces($trans, $this$steps_u24lambda_u242_u240.getDetectDropped(), $this$steps_u24lambda_u242_u240.getLoadNew());
        return Unit.INSTANCE;
    }

    private static final Unit removeDroppedServerComments$lambda$0(LongOpenHashSet $commentsIds, PgGPlumBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        for (PgGPlumBaseTablespace tablespace : r.getTablespaces()) {
            if ($commentsIds.contains(tablespace.getObjectId())) continue;
            tablespace.setComment(null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$0$0$0$0(PgGPlumBaseRoot $r, PgGPlumBaseIntrospector this$0, PgGPlumBaseIntroQueries.OneRole role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        BasicModNamedElement basicModNamedElement = $r.getRoles().renew(role.role_id, role.role_name);
        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
        BasicModNamedElement basicModNamedElement2 = basicModNamedElement;
        PgGPlumBaseRole $this$retrieveRoles_u24lambda_u240_u240_u240_u240_u240 = (PgGPlumBaseRole)basicModNamedElement2;
        boolean bl = false;
        this$0.processRole($this$retrieveRoles_u24lambda_u240_u240_u240_u240_u240, role);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveRoles$lambda$0(PgGPlumBaseIntrospector this$0, DBTransaction $tran, PgGPlumBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)r.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl2 = false;
            IntrospectionQueryContext.performQueryHandleEachRow$default((IntrospectionQueryContext)((IntrospectionQueryContext)this$0), (DBTransaction)$tran, this$0.getQueries().getRetrieveRoles(), (int)0, arg_0 -> PgGPlumBaseIntrospector.retrieveRoles$lambda$0$0$0$0(r, this$0, arg_0), (int)2, null);
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoleGrants$lambda$0$0$0(Ref.LongRef $id, PgGPlumBaseIntrospector this$0, PgGPlumBaseRoot $r, ArrayList $grants, PgGPlumBaseIntroQueries.OneRoleGrant g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g.id != $id.element) {
            this$0.applyRoleGrants($r, $id.element, $grants);
            $id.element = g.id;
        }
        ((Collection)$grants).add(new PgRoleGrant(g.role_id, g.admin_option));
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoleGrants$lambda$0$0(PgGPlumBaseIntrospector this$0, DBTransaction $tran, Ref.LongRef $id, ArrayList $grants, PgGPlumBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this$0.getQueries().processRoleGrants($tran, (Function1<? super PgGPlumBaseIntroQueries.OneRoleGrant, Unit>)((Function1)arg_0 -> PgGPlumBaseIntrospector.retrieveRoleGrants$lambda$0$0$0($id, this$0, r, $grants, arg_0)));
        this$0.applyRoleGrants(r, $id.element, $grants);
        return Unit.INSTANCE;
    }

    private static final boolean retrieveAcls$lambda$0$0$0(Grants.Controller $ctl, PgGPlumBaseRoot $r, PgObjectGrant it) {
        Grants.Grant grant = (Grants.Grant)it;
        BasicElement basicElement = (BasicElement)$r;
        BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
        return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
    }

    private static final boolean retrieveAcls$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit retrieveAcls$lambda$0$0$3(PgGPlumBaseIntrospector this$0, Lexer $lexer, NamingService $ns, List $newGrants, PgBaseIntroQueries.OneAcl acl) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
            if (acl.acl == null) break block1;
            String[] $this$forEach$iv = acl.acl;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                if (pgAclItem == null) continue;
                pgAclItem.toGrants(acl.object_id, (Collection)$newGrants);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAcls$lambda$0$0(boolean $detectDropped, boolean $loadNew, PgGPlumBaseIntrospector this$0, DBTransaction $tran, PgGPlumBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Grants.Controller ctl = ((PgBaseGrantsHolder)r).getGrants().getController();
        List newGrants = ((PgBaseGrantsHolder)r).getGrants().toMutableList();
        if ($detectDropped) {
            newGrants.removeIf(arg_0 -> PgGPlumBaseIntrospector.retrieveAcls$lambda$0$0$1(arg_0 -> PgGPlumBaseIntrospector.retrieveAcls$lambda$0$0$0(ctl, r, arg_0), arg_0));
        }
        if ($loadNew) {
            Long l = ((PgBaseRoot)r).getIntrospectionStateNumber();
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long tx = $detectDropped ? l : null;
            Lexer lexer = this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService$default((Dbms)this$0.dbms, (BasicModel)((BasicModel)this$0.getModel()), null, (int)4, null);
            this$0.getQueries().processObjectAcls($tran, r, tx, this$0.getNoDbXmin(), arg_0 -> PgGPlumBaseIntrospector.retrieveAcls$lambda$0$0$3(this$0, lexer, ns, newGrants, arg_0));
        }
        ((PgBaseGrantsHolder)r).setGrants(((PgBaseGrantsHolder)r).getGrants().with((Iterable)newGrants));
        return Unit.INSTANCE;
    }

    private static final Unit retrieveTablespaces$lambda$0$0$0$1(PgGPlumBaseRoot $r, PgGPlumBaseIntroQueries.OneTablespace tablespace) {
        Intrinsics.checkNotNullParameter((Object)tablespace, (String)"tablespace");
        BasicModNamedElement basicModNamedElement = $r.getTablespaces().renew(tablespace.id, tablespace.name);
        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
        BasicModNamedElement basicModNamedElement2 = basicModNamedElement;
        PgGPlumBaseTablespace $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240 = (PgGPlumBaseTablespace)basicModNamedElement2;
        boolean bl = false;
        $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240.setStateNumber(tablespace.state_number);
        $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240.setComment(tablespace.comment);
        $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240.setOwnerRef((BasicReference)BasicNameReference.create((String)tablespace.owner));
        $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240.setLocation(tablespace.location);
        Object object = tablespace.options;
        if (tablespace.options == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        $this$retrieveTablespaces_u24lambda_u240_u240_u240_u241_u240.setOptions((List<String>)object);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveTablespaces$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, DBTransaction $tran, boolean $loadNew, PgGPlumBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)r.getTablespaces();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl2 = false;
            if ($detectDropped) {
                long[] $this$forEach$iv = (long[])this$0.performQuery($tran, this$0.getQueries().getRetrieveExistentTablespaces());
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    long element$iv;
                    long it2 = element$iv = $this$forEach$iv[j];
                    boolean bl3 = false;
                    PgGPlumBaseTablespace pgGPlumBaseTablespace = (PgGPlumBaseTablespace)r.getTablespaces().getByObjectId(it2);
                    if (pgGPlumBaseTablespace != null) {
                        ((BasicModMixinElement)pgGPlumBaseTablespace).resetSyncPending();
                    }
                }
            }
            if ($loadNew) {
                IntrospectionQueryContext.performQueryHandleEachRow$default((IntrospectionQueryContext)((IntrospectionQueryContext)this$0), (DBTransaction)$tran, this$0.getQueries().getRetrieveTablespaces(), (int)0, arg_0 -> PgGPlumBaseIntrospector.retrieveTablespaces$lambda$0$0$0$1(r, arg_0), (int)2, null);
            }
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl4 = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final ModPositioningNamingFamily copyObjects$lambda$0(PgGPlumBaseLocalTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ModPositioningNamingFamily<? extends PgGPlumBaseLocalTableColumn> modPositioningNamingFamily = it.getColumns();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
        return modPositioningNamingFamily;
    }

    private static final PgBaseLikeColumn copyObjects$lambda$1(PgGPlumBaseView view, PgBaseLikeColumn column) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        BasicModArrangedElement basicModArrangedElement = view.getColumns().renewAt(column.getPosition(), column.getName());
        Intrinsics.checkNotNullExpressionValue((Object)basicModArrangedElement, (String)"renewAt(...)");
        return (PgBaseLikeColumn)basicModArrangedElement;
    }

    private static final ModIdentifyingFamily copyObjects$lambda$2(PgGPlumBaseLocalTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ModNamingIdentifyingFamily<? extends PgGPlumBaseRule> modNamingIdentifyingFamily = it.getRules();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getRules(...)");
        return (ModIdentifyingFamily)modNamingIdentifyingFamily;
    }

    private static final PgGPlumBaseRule copyObjects$lambda$3(PgGPlumBaseView view, PgGPlumBaseRule rule) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        BasicModNamedElement basicModNamedElement = view.getRules().renew(rule.getObjectId(), rule.getName());
        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
        PgGPlumBaseRule newRule = (PgGPlumBaseRule)basicModNamedElement;
        newRule.setSourceText(rule.getSourceText());
        return newRule;
    }

    private static final long parseListOfLongs$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Long.parseLong(it);
    }

    public static final /* synthetic */ boolean access$getShowTemplateDbs(PgGPlumBaseIntrospector $this) {
        return $this.getShowTemplateDbs();
    }

    public static final /* synthetic */ long access$getMyServerStartupTime$p(PgGPlumBaseIntrospector $this) {
        return $this.myServerStartupTime;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ObjectKind.INDEX, (Object)"select pg_get_indexdef(?)"), TuplesKt.to((Object)ObjectKind.RULE, (Object)"select pg_get_ruledef(?)"), TuplesKt.to((Object)ObjectKind.TRIGGER, (Object)"select pg_get_triggerdef(?)")};
        NATIVE_DEFINITIONS_QUERIES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$Companion;", "", "<init>", "()V", "NATIVE_DEFINITIONS_QUERIES", "", "Lcom/intellij/database/model/ObjectKind;", "", "intellij.database.dialects.postgresgreenplumbase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\b\u0010\u001e\u001a\u00020\u0010H\u0014J \u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J)\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00028\u00032\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0014\u00a2\u0006\u0002\u0010,R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "D", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;)V", "value", "", "mySuper", "getMySuper", "()Z", "beforeServerAndDatabaseObjectsRetrieval", "", "removeDroppedDatabaseComments", "ids", "Lit/unimi/dsi/fastutil/longs/LongSet;", "retrieveForeignDataWrappers", "detectDropped", "loadNew", "retrieveForeignServers", "introspectUserMappings", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "introspectAccessMethods", "retrieveExtensions", "retrieveExtensionMembers", "setExtensionMembers", "ext", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseExtension;", "memberRefs", "Ljava/util/ArrayList;", "Lcom/intellij/database/model/properties/references/BasicIdReference;", "findObjectById", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "db", "kind", "", "id", "", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicModNamedElement;", "intellij.database.dialects.postgresgreenplumbase"})
    @SourceDebugExtension(value={"SMAP\nPgGPlumBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1306:1\n1021#2,2:1307\n1915#2,2:1309\n1915#2,2:1311\n1915#2,2:1313\n1915#2,2:1315\n1915#2,2:1351\n1915#2,2:1353\n1586#2:1380\n1661#2,3:1381\n1915#2:1398\n1915#2,2:1399\n1916#2:1401\n179#3,4:1317\n183#3,3:1341\n179#3,4:1344\n183#3,3:1370\n337#3,3:1384\n340#3:1389\n198#3,5:1390\n204#3,5:1417\n341#3:1422\n179#3,4:1424\n183#3,3:1448\n179#3,4:1451\n183#3,3:1475\n521#4:1321\n502#4,2:1322\n505#4,15:1326\n521#4:1348\n502#4,2:1349\n505#4,15:1355\n521#4:1395\n502#4,2:1396\n505#4,15:1402\n521#4:1428\n502#4,2:1429\n505#4,15:1433\n521#4:1455\n502#4,2:1456\n505#4,15:1460\n14088#5,2:1324\n14088#5,2:1431\n14088#5,2:1458\n428#6,7:1373\n428#6,7:1478\n37#7,2:1387\n1#8:1423\n*S KotlinDebug\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever\n*L\n410#1:1307,2\n242#1:1309,2\n243#1:1311,2\n244#1:1313,2\n245#1:1315,2\n283#1:1351,2\n289#1:1353,2\n308#1:1380\n308#1:1381,3\n312#1:1398\n313#1:1399,2\n312#1:1401\n253#1:1317,4\n253#1:1341,3\n279#1:1344,4\n279#1:1370,3\n308#1:1384,3\n308#1:1389\n308#1:1390,5\n308#1:1417,5\n308#1:1422\n346#1:1424,4\n346#1:1448,3\n369#1:1451,4\n369#1:1475,3\n254#1:1321\n254#1:1322,2\n254#1:1326,15\n280#1:1348\n280#1:1349,2\n280#1:1355,15\n309#1:1395\n309#1:1396,2\n309#1:1402,15\n347#1:1428\n347#1:1429,2\n347#1:1433,15\n370#1:1455\n370#1:1456,2\n370#1:1460,15\n256#1:1324,2\n349#1:1431,2\n372#1:1458,2\n321#1:1373,7\n395#1:1478,7\n308#1:1387,2\n*E\n"})
    protected static class PgGPlumBaseDatabaseRetriever<D extends PgGPlumBaseDatabase>
    extends PgBaseIntrospector.DatabaseRetriever<D> {
        private boolean mySuper;
        final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;

        public PgGPlumBaseDatabaseRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((PgBaseIntrospector)this$0, tran, (PgBaseDatabase)database);
        }

        protected final boolean getMySuper() {
            return this.mySuper;
        }

        protected void beforeServerAndDatabaseObjectsRetrieval() {
            super.beforeServerAndDatabaseObjectsRetrieval();
            Boolean bl = (Boolean)this.performQuery(this.this$0.getQueries().isSuperUser());
            this.mySuper = bl != null ? bl : false;
            this.setQueryParameter("super", this.mySuper);
        }

        protected void removeDroppedDatabaseComments(@NotNull LongSet ids) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            super.removeDroppedDatabaseComments(ids);
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.removeDroppedDatabaseComments$lambda$0(ids, arg_0));
        }

        protected void retrieveForeignDataWrappers(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("foreign data wrappers", "introspection.retrieve.foreign.dataWrappers");
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveForeignDataWrappers$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void retrieveForeignServers(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("foreign servers", "introspection.retrieve.foreign.servers");
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveForeignServers$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void introspectUserMappings(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.USER_MAPPING;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"USER_MAPPING");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.introspectUserMappings$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)super.steps(), (int)5, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$0(this, arg_0), (int)6, null), (int)6, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$1(this, arg_0), (int)6, null), (int)7, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$2(this, arg_0), (int)6, null), (int)8, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$3(this, arg_0), (int)6, null), (int)9, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$4(this, arg_0), (int)6, null), (int)99, null, null, arg_0 -> PgGPlumBaseDatabaseRetriever.steps$lambda$5(this, arg_0), (int)6, null);
        }

        protected void introspectAccessMethods(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.ACCESS_METHOD;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ACCESS_METHOD");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.introspectAccessMethods$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void retrieveExtensions(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.EXTENSION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"EXTENSION");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveExtensions$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void retrieveExtensionMembers() {
            this.inDatabase(arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveExtensionMembers$lambda$0(this, this.this$0, arg_0));
        }

        private final void setExtensionMembers(PgGPlumBaseExtension ext, ArrayList<BasicIdReference> memberRefs) {
            block1: {
                List $this$sortBy$iv = memberRefs;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            BasicIdReference it = (BasicIdReference)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(it.getObjectId());
                            it = (BasicIdReference)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getObjectId()));
                        }
                    });
                }
                PgGPlumBaseExtension pgGPlumBaseExtension = ext;
                if (pgGPlumBaseExtension == null) break block1;
                Intrinsics.checkNotNull(memberRefs, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.database.model.properties.BasicReference>");
                pgGPlumBaseExtension.setMemberRefs(memberRefs);
            }
        }

        @Nullable
        protected BasicModNamedElement findObjectById(@NotNull D db, @Nullable Character kind, long id) {
            BasicModNamedElement basicModNamedElement;
            Character c;
            Intrinsics.checkNotNullParameter(db, (String)"db");
            Character c2 = c = kind;
            char c3 = 'E';
            if (c2 != null && c2.charValue() == c3) {
                basicModNamedElement = (BasicModNamedElement)db.getExtensions().getByObjectId(id);
            } else {
                Character c4 = c;
                c3 = 'A';
                if (c4 != null && c4.charValue() == c3) {
                    basicModNamedElement = (BasicModNamedElement)db.getAccessMethods().getByObjectId(id);
                } else {
                    Character c5 = c;
                    c3 = 'W';
                    if (c5 != null && c5.charValue() == c3) {
                        basicModNamedElement = (BasicModNamedElement)db.getForeignDataWrappers().getByObjectId(id);
                    } else {
                        Character c6 = c;
                        c3 = 'S';
                        basicModNamedElement = c6 != null && c6.charValue() == c3 ? (BasicModNamedElement)db.getForeignServers().getByObjectId(id) : super.findObjectById((PgBaseDatabase)db, kind, id);
                    }
                }
            }
            return basicModNamedElement;
        }

        private static final Unit removeDroppedDatabaseComments$lambda$0(LongSet $ids, PgGPlumBaseDatabase db) {
            PgGPlumBaseCatalogObject it;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingIdentifyingFamily<? extends PgGPlumBaseExtension> modNamingIdentifyingFamily = db.getExtensions();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getExtensions(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PgGPlumBaseExtension)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            ModNamingIdentifyingFamily<? extends PgGPlumBaseAccessMethod> modNamingIdentifyingFamily2 = db.getAccessMethods();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getAccessMethods(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PgGPlumBaseAccessMethod)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            ModNamingIdentifyingFamily<? extends PgGPlumBaseForeignDataWrapper> modNamingIdentifyingFamily3 = db.getForeignDataWrappers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getForeignDataWrappers(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PgGPlumBaseForeignDataWrapper)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            ModNamingIdentifyingFamily<? extends PgGPlumBaseForeignServer> modNamingIdentifyingFamily4 = db.getForeignServers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getForeignServers(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PgGPlumBaseForeignServer)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignDataWrappers$lambda$0$0$0$1(PgGPlumBaseDatabase $db, PgGPlumBaseIntroQueries.OneForeignDataWrapper fdw) {
            Intrinsics.checkNotNullParameter((Object)fdw, (String)"fdw");
            BasicModNamedElement basicModNamedElement = $db.getForeignDataWrappers().renew(fdw.id, fdw.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseForeignDataWrapper wrapper = (PgGPlumBaseForeignDataWrapper)basicModNamedElement;
            wrapper.setStateNumber(fdw.state_number);
            wrapper.setHandlerRef(BasicParentReference.create((String)fdw.handler_schema, (BasicReference)((BasicReference)BasicNameReference.create((String)fdw.handler))));
            wrapper.setValidatorRef(BasicParentReference.create((String)fdw.validator_schema, (BasicReference)((BasicReference)BasicNameReference.create((String)fdw.validator))));
            wrapper.setOptions(ArraysKt.toList((Object[])fdw.options));
            wrapper.setOwnerRef((BasicReference)BasicNameReference.create((String)fdw.getOwnerName()));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveForeignDataWrappers$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, PgGPlumBaseDatabaseRetriever this$1, boolean $loadNew, PgGPlumBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getForeignDataWrappers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = (long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentForeignDataWrappers());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it2 = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgGPlumBaseForeignDataWrapper pgGPlumBaseForeignDataWrapper = (PgGPlumBaseForeignDataWrapper)db.getForeignDataWrappers().getByObjectId(it2);
                        if (pgGPlumBaseForeignDataWrapper != null) {
                            ((BasicModMixinElement)pgGPlumBaseForeignDataWrapper).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getRetrieveForeignDataWrappers(), (int)0, arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveForeignDataWrappers$lambda$0$0$0$1(db, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveForeignServers$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, PgGPlumBaseDatabaseRetriever this$1, boolean $loadNew, PgGPlumBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getForeignServers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                boolean bl2 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentForeignServers()));
                    ModNamingIdentifyingFamily<? extends PgGPlumBaseForeignServer> modNamingIdentifyingFamily = db.getForeignServers();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getForeignServers(...)");
                    $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseForeignServer it2 = (PgGPlumBaseForeignServer)element$iv;
                        boolean bl3 = false;
                        if (!ids.contains(it2.getObjectId())) continue;
                        it2.resetSyncPending();
                    }
                }
                if ($loadNew) {
                    List servers = (List)this$1.performQuery(this$0.getQueries().getRetrieveForeignServers());
                    $this$forEach$iv = servers;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseIntroQueries.OneForeignServer s = (PgGPlumBaseIntroQueries.OneForeignServer)element$iv;
                        boolean bl4 = false;
                        BasicModNamedElement basicModNamedElement = db.getForeignServers().renew(s.id, s.name);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                        PgGPlumBaseForeignServer server = (PgGPlumBaseForeignServer)basicModNamedElement;
                        server.setForeignDataWrapperRef((BasicReference)BasicIdReference.create((long)s.fdw_id));
                        server.setStateNumber(s.state_number);
                        server.setOptions(ArraysKt.toList((Object[])s.options));
                        server.setType(s.type);
                        server.setVersion(s.version);
                        server.setOwnerRef((BasicReference)BasicNameReference.create((String)s.getOwnerName()));
                    }
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit introspectUserMappings$lambda$0$1$0$1(IdCache $srvCache, PgGPlumBaseDatabase $db, PgGPlumBaseIntroQueries.OneUserMapping m) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                var3_3 = $srvCache;
                id$iv = m.server_id;
                $i$f$get = false;
                var7_8 = this_$iv;
                id$iv$iv = id$iv;
                $i$f$getOrCache = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull((Object)v0);
                if (((BasicIdentifiedElement)v0).getObjectId() == id$iv$iv) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var11_11 = id$iv$iv;
                    var13_12 = this_$iv$iv;
                    var14_13 = this_$iv$iv;
                    $i$a$-getOrCache-IdCache$get$1$iv = false;
                    var16_15 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                        final /* synthetic */ long $id;
                        {
                            this.$id = $id;
                        }

                        public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                        }
                    };
                    $this$introspectUserMappings_u24lambda_u240_u241_u240_u241_u240 = $this$get_u24lambda_u240$iv;
                    $i$a$-get-PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever$introspectUserMappings$1$2$1$2$1 = false;
                    v2 = $db.getForeignServers();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getForeignServers(...)");
                    var14_13.setV((BasicModIdentifiedElement)((PgGPlumBaseForeignServer)it.invoke(v2)));
                    v1 = this_$iv$iv.getV();
                }
                v3 = (PgGPlumBaseForeignServer)v1;
                if (v3 == null) break block3;
                foreignServer = v3;
                $i$a$-let-PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever$introspectUserMappings$1$2$1$2$2 = false;
                v4 = m.user;
                if (v4 == null) {
                    v4 = "public";
                }
                userName = v4;
                v5 = foreignServer.getUserMappings().renew(m.id, userName);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"renew(...)");
                mapping = (PgGPlumBaseUserMapping)v5;
                mapping.setOptions(ArraysKt.toList((Object[])m.options));
                mapping.setUser(userName);
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit introspectUserMappings$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, PgGPlumBaseDatabaseRetriever this$1, boolean $loadNew, PgGPlumBaseDatabase db) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingIdentifyingFamily<? extends PgGPlumBaseForeignServer> modNamingIdentifyingFamily = db.getForeignServers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getForeignServers(...)");
            Iterable $this$map$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PgGPlumBaseForeignServer pgGPlumBaseForeignServer = (PgGPlumBaseForeignServer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUserMappings());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentUserMappingsSuperUser()));
                    ModNamingIdentifyingFamily<? extends PgGPlumBaseForeignServer> modNamingIdentifyingFamily2 = db.getForeignServers();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getForeignServers(...)");
                    Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseForeignServer fs = (PgGPlumBaseForeignServer)element$iv;
                        boolean bl3 = false;
                        ModNamingIdentifyingFamily<? extends PgGPlumBaseUserMapping> modNamingIdentifyingFamily3 = fs.getUserMappings();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getUserMappings(...)");
                        Iterable $this$forEach$iv2 = (Iterable)modNamingIdentifyingFamily3;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgGPlumBaseUserMapping um = (PgGPlumBaseUserMapping)element$iv2;
                            boolean bl4 = false;
                            if (!ids.contains(um.getObjectId())) continue;
                            um.resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    IdCache srvCache = new IdCache();
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$1.mySuper ? this$0.getQueries().getRetrieveUserMappingsSuperUser() : this$0.getQueries().getRetrieveUserMappings(), (int)0, arg_0 -> PgGPlumBaseDatabaseRetriever.introspectUserMappings$lambda$0$1$0$1(srvCache, db, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$0(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u240_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveForeignDataWrappers($this$steps_u24lambda_u240_u240.getDetectDropped(), $this$steps_u24lambda_u240_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$1(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u241_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveForeignServers($this$steps_u24lambda_u241_u240.getDetectDropped(), $this$steps_u24lambda_u241_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$2(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u242_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.introspectUserMappings(this$0.mySuper && $this$steps_u24lambda_u242_u240.getDetectDropped(), $this$steps_u24lambda_u242_u240.getLoadNew() || !this$0.mySuper);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u243_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.introspectAccessMethods($this$steps_u24lambda_u243_u240.getDetectDropped(), $this$steps_u24lambda_u243_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$4(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u244_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveExtensions($this$steps_u24lambda_u244_u240.getDetectDropped(), $this$steps_u24lambda_u244_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$5(PgGPlumBaseDatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            this$0.retrieveExtensionMembers();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit introspectAccessMethods$lambda$0$0$0$1(PgGPlumBaseDatabase $db, PgGPlumBaseIntrospector this$0, PgGPlumBaseIntroQueries.OneAccessMethod m) {
            Object object;
            PgGPlumBaseAccessMethod pgGPlumBaseAccessMethod;
            block3: {
                block2: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    BasicModNamedElement basicModNamedElement = $db.getAccessMethods().renew(m.access_method_id, m.access_method_name);
                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                    PgGPlumBaseAccessMethod method = (PgGPlumBaseAccessMethod)basicModNamedElement;
                    method.setStateNumber(m.state_number);
                    method.setHandlerRef(this$0.createIdOrQNameRef(m.handler_id, m.handler_name, ((PgGPlumBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
                    pgGPlumBaseAccessMethod = method;
                    object = m.access_method_type;
                    if (object == null) break block2;
                    char c = object.charValue();
                    PgGPlumBaseAccessMethod pgGPlumBaseAccessMethod2 = pgGPlumBaseAccessMethod;
                    boolean bl = false;
                    PgAccessMethodType pgAccessMethodType = PgAccessMethodType.of((char)it);
                    pgGPlumBaseAccessMethod = pgGPlumBaseAccessMethod2;
                    object = pgAccessMethodType;
                    if (pgAccessMethodType != null) break block3;
                }
                object = PgAccessMethodType.UNKNOWN;
            }
            pgGPlumBaseAccessMethod.setType((PgAccessMethodType)((Object)object));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit introspectAccessMethods$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, PgGPlumBaseDatabaseRetriever this$1, boolean $loadNew, PgGPlumBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getAccessMethods();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = (long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentAccessMethods());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it2 = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgGPlumBaseAccessMethod pgGPlumBaseAccessMethod = (PgGPlumBaseAccessMethod)db.getAccessMethods().getByObjectId(it2);
                        if (pgGPlumBaseAccessMethod != null) {
                            ((BasicModMixinElement)pgGPlumBaseAccessMethod).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getRetrieveAccessMethods(), (int)0, arg_0 -> PgGPlumBaseDatabaseRetriever.introspectAccessMethods$lambda$0$0$0$1(db, this$0, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveExtensions$lambda$0$0$0$1(PgGPlumBaseDatabase $db, PgGPlumBaseIntrospector this$0, PgGPlumBaseIntroQueries.OneExtension extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            BasicModNamedElement basicModNamedElement = $db.getExtensions().renew(extension.id, extension.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseExtension newExt = (PgGPlumBaseExtension)basicModNamedElement;
            newExt.setStateNumber(extension.state_number);
            newExt.setVersion(extension.version);
            long l = extension.schema_id;
            String string = extension.schema_name;
            if (string == null) {
                string = "";
            }
            newExt.setExtSchemaRef(this$0.createIdOrQNameRef(l, string, null));
            newExt.setAvailableUpdates(ArraysKt.toList((Object[])extension.available_updates));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveExtensions$lambda$0(PgGPlumBaseIntrospector this$0, boolean $detectDropped, PgGPlumBaseDatabaseRetriever this$1, boolean $loadNew, PgGPlumBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getExtensions();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = (long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentExtensions());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it2 = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgGPlumBaseExtension pgGPlumBaseExtension = (PgGPlumBaseExtension)db.getExtensions().getByObjectId(it2);
                        if (pgGPlumBaseExtension != null) {
                            ((BasicModMixinElement)pgGPlumBaseExtension).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getRetrieveExtensions(), (int)0, arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveExtensions$lambda$0$0$0$1(db, this$0, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveExtensionMembers$lambda$0$0(IdCache $extCache, PgGPlumBaseDatabase $db, PgGPlumBaseDatabaseRetriever this$0, Ref.ObjectRef $memberRefs, PgGPlumBaseIntroQueries.OneExtensionMember member) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)member, (String)"member");
                var5_5 = $extCache;
                id$iv = member.extension_id;
                $i$f$get = false;
                var9_8 = this_$iv;
                id$iv$iv = id$iv;
                $i$f$getOrCache = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull((Object)v0);
                if (((BasicIdentifiedElement)v0).getObjectId() == id$iv$iv) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var13_11 = id$iv$iv;
                    var15_12 = this_$iv$iv;
                    var16_13 = this_$iv$iv;
                    $i$a$-getOrCache-IdCache$get$1$iv = false;
                    var18_15 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                        final /* synthetic */ long $id;
                        {
                            this.$id = $id;
                        }

                        public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                        }
                    };
                    $this$retrieveExtensionMembers_u24lambda_u240_u240_u240 = $this$get_u24lambda_u240$iv;
                    $i$a$-get-PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever$retrieveExtensionMembers$1$1$1 = false;
                    v2 = (PgGPlumBaseExtension)$this$retrieveExtensionMembers_u24lambda_u240_u240_u240.getV();
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever$retrieveExtensionMembers$1$1$1$1 = false;
                        PgGPlumBaseDatabaseRetriever.access$setExtensionMembers(this$0, it, (ArrayList)$memberRefs.element);
                        $memberRefs.element = new ArrayList<E>();
                    }
                    v3 = $db.getExtensions();
                    Intrinsics.checkNotNullExpressionValue(v3, (String)"getExtensions(...)");
                    var16_13.setV((BasicModIdentifiedElement)((PgGPlumBaseExtension)it.invoke(v3)));
                    v1 = this_$iv$iv.getV();
                }
                v4 = BasicIdReference.create((long)member.member_id);
                if (v4 == null) break block3;
                it = v4;
                $i$a$-let-PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever$retrieveExtensionMembers$1$1$2 = false;
                ((ArrayList)$memberRefs.element).add(it);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveExtensionMembers$lambda$0(PgGPlumBaseDatabaseRetriever this$0, PgGPlumBaseIntrospector this$1, PgGPlumBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            IdCache extCache = new IdCache();
            Ref.ObjectRef memberRefs = new Ref.ObjectRef();
            memberRefs.element = new ArrayList();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveExtensionMembers(), (int)0, arg_0 -> PgGPlumBaseDatabaseRetriever.retrieveExtensionMembers$lambda$0$0(extCache, db, this$0, memberRefs, arg_0), (int)2, null);
            this$0.setExtensionMembers((PgGPlumBaseExtension)extCache.getV(), (ArrayList)memberRefs.element);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$setExtensionMembers(PgGPlumBaseDatabaseRetriever $this, PgGPlumBaseExtension ext, ArrayList memberRefs) {
            $this.setExtensionMembers(ext, memberRefs);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseNativeRetriever;", "D", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDatabase;)V", "retrieveNativeDefinitionsFor", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "getNativeDefinitionQuery", "intellij.database.dialects.postgresgreenplumbase"})
    protected static class PgGPlumBaseNativeRetriever<D extends PgGPlumBaseDatabase>
    extends PgBaseIntrospector.NativeRetriever<D> {
        final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;

        public PgGPlumBaseNativeRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((PgBaseIntrospector)this$0, tran, (PgBaseLikeDatabase)database);
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            ResultLayout layout = Layouts.singleOf(String.class);
            String string = this.getNativeDefinitionQuery(kind);
            if (string == null) {
                return;
            }
            String query = string;
            for (BasicModIdentifiedElement element : CollectionsKt.filterIsInstance(elements, BasicModIdentifiedElement.class)) {
                this.this$0.handleErrors("Retrieve native definition for " + element.getName(), () -> PgGPlumBaseNativeRetriever.retrieveNativeDefinitionsFor$lambda$0(this, query, layout, element, result));
            }
        }

        @Nullable
        protected String getNativeDefinitionQuery(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return (String)NATIVE_DEFINITIONS_QUERIES.get(kind);
        }

        private static final Unit retrieveNativeDefinitionsFor$lambda$0(PgGPlumBaseNativeRetriever this$0, String $query, ResultLayout $layout, BasicModIdentifiedElement $element, Map $result) {
            block0: {
                Object[] objectArray = new Object[]{$element.getObjectId()};
                String string = (String)this$0.getTransaction().query($query, $layout).withParams(objectArray).runOnce();
                if (string == null) break block0;
                String definition = string;
                boolean bl = false;
                Map map = $result;
                String[] stringArray = new String[]{definition};
                map.put($element, stringArray);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J$\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J%\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170$0\u00142\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010%J#\u0010&\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0'0\u00142\u0006\u0010)\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010*J%\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020(2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010-\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u00112\u0006\u00101\u001a\u0002022\u0006\u0010,\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J-\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u0002082\u0006\u0010,\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\u00112\u0006\u0010,\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\f\u0010;\u001a\u00020<*\u00020<H\u0002J\u001f\u0010=\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0\u00142\u0006\u0010,\u001a\u000203H\u0014\u00a2\u0006\u0002\u0010>J\u001d\u0010?\u001a\u00020@2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010A\u001a\u00020BH\u0014\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020\u00112\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\b\u0010I\u001a\u00020\u000bH\u0014J \u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J\b\u0010N\u001a\u00020\u0011H\u0014J \u0010O\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J \u0010P\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J \u0010Q\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J\u001a\u0010U\u001a\u00020\u0011*\u00020T2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J\u001a\u0010Y\u001a\u00020\u0011*\u00020T2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020Z0WH\u0002J \u0010[\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J \u0010\\\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J \u0010]\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0002J\u0018\u0010^\u001a\u00020\u00112\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0014J\b\u0010c\u001a\u00020\u0011H\u0002J\u001e\u0010d\u001a\u00020\u00112\u0006\u0010_\u001a\u00020`2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020f0SH\u0014J\u001a\u0010g\u001a\f\u0012\u0006\b\u0001\u0012\u00020`\u0018\u00010'2\u0006\u0010,\u001a\u00020(H\u0002J\u001a\u0010h\u001a\u0004\u0018\u00010`2\u0006\u0010,\u001a\u00020(2\u0006\u0010a\u001a\u00020bH\u0004J\b\u0010i\u001a\u00020\u0011H\u0014J!\u0010j\u001a\b\u0012\u0004\u0012\u00020<0S2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020<0\u0014H\u0014\u00a2\u0006\u0002\u0010lJ0\u0010m\u001a\u00020\u00112\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020q2\u000e\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020q0r2\u0006\u0010,\u001a\u00020(H\u0014J \u0010s\u001a\u00020\u00112\u0006\u0010,\u001a\u00020(2\u0006\u0010t\u001a\u00020<2\u0006\u0010u\u001a\u00020<H\u0014J \u0010v\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J\b\u0010w\u001a\u00020\u0011H\u0014J\u0014\u0010x\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013H\u0014J\u0018\u0010y\u001a\u00020\u00112\u0006\u0010,\u001a\u0002032\u0006\u0010z\u001a\u00020.H\u0014J \u0010{\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0002J\u0014\u0010|\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020~0\u000e0}H\u0014J\b\u0010\u007f\u001a\u00020\u0011H\u0002J&\u0010\u0080\u0001\u001a\u00020\u00112\u0007\u0010,\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J!\u0010\u0086\u0001\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u000bH\u0014J\u001c\u0010\u0087\u0001\u001a\u00020\u00112\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010z\u001a\u00030\u008a\u0001H\u0014J\u001a\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020<0S2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010<H\u0002J\t\u0010\u008d\u0001\u001a\u00020\u0011H\u0014J.\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0014\u00a2\u0006\u0003\u0010\u0094\u0001J6\u0010\u0095\u0001\u001a\u0004\u0018\u00010(2\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010\u0096\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u0097\u0001\u001a\u00020<H\u0014\u00a2\u0006\u0003\u0010\u0098\u0001R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0099\u0001"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "S", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)V", "wasEnums", "", "wasDomains", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "removeComments", "", "existentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "", "e", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)V", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "tableFamilies", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "sc", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "processTable", "table", "oneTable", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)V", "processCheck", "cleanupPredicate", "", "constraintFamilies", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "createRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;)Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "shouldIntrospectTableRelatedDataIncremental", "retrieveRules", "removeUnaffected", "detectDropped", "loadNew", "retrieveForeignTablesInfo", "retrieveCollations", "retrieveOperatorClasses", "retrieveAccessMethodOperators", "getRelevantAmOwners", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseOperatorAmHolder;", "appendOps", "ops", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/properties/PgAmOp;", "appendProcs", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/properties/PgAmProc;", "retrieveAccessMethodProcedures", "retrieveOperatorFamilies", "retrieveIndices", "processIndex", "index", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseIndex;", "ind", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneIndex;", "retrieveIndexColumns", "applyIndexColumns", "columns", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneIndexColumn;", "indexFamilyOf", "createIndex", "retrieveEnumLabels", "fixLabelsOrder", "labels", "([Ljava/lang/String;)Ljava/util/List;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "handleColumnRenaming", "oldName", "tableName", "retrieveDataTypes", "retrieveDataTypeChecks", "listExistentComments", "processModTable", "t", "retrieveSequences", "getSequencesQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneSequence;", "retrieveRelations", "applyTableRelations", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLocalTable;", "relations", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "processedTables", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "retrieveTriggers", "processTrigger", "trigger", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneTrigger;", "parseTriggerCallArgs", "str", "retrieveRulesSources", "getTableOrView", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLikeStoredTable;", "relKind", "", "tableId", "", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;CJ)Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLikeStoredTable;", "renewTableOrViewImpl", "objectId", "objectName", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;CJLjava/lang/String;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "intellij.database.dialects.postgresgreenplumbase"})
    @SourceDebugExtension(value={"SMAP\nPgGPlumBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 7 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 9 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 10 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 11 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 12 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1306:1\n1#2:1307\n1#2:1490\n1#2:1585\n1#2:1643\n1#2:1729\n1#2:1765\n1#2:1906\n1#2:1949\n1586#3:1308\n1661#3,3:1309\n777#3:1373\n873#3,2:1374\n1807#3,3:1395\n1586#3:1398\n1661#3,3:1399\n1834#3,4:1402\n1586#3:1406\n1661#3,3:1407\n1586#3:1410\n1661#3,3:1411\n800#3:1414\n1924#3,2:1415\n801#3,2:1417\n1926#3:1419\n803#3:1420\n1834#3,4:1440\n1915#3,2:1444\n1915#3:1522\n1915#3:1523\n1915#3,2:1524\n1916#3:1526\n1916#3:1527\n1915#3,2:1528\n1915#3:1675\n777#3:1676\n873#3,2:1677\n1916#3:1679\n1915#3,2:1680\n1915#3:1689\n777#3:1690\n873#3,2:1691\n1916#3:1693\n1915#3,2:1694\n1915#3:1797\n1915#3:1798\n1915#3,2:1799\n1916#3:1801\n1916#3:1802\n1586#3:1830\n1661#3,3:1831\n1915#3:1848\n1915#3,2:1849\n1916#3:1851\n1915#3:1981\n1915#3:1982\n1915#3,2:1983\n1916#3:1985\n1916#3:1986\n106#4:1312\n78#4,22:1313\n521#5:1335\n502#5,18:1336\n521#5:1354\n502#5,18:1355\n521#5:1376\n502#5,18:1377\n521#5:1421\n502#5,18:1422\n521#5:1448\n502#5,2:1449\n400#5:1451\n401#5,2:1457\n505#5,15:1464\n521#5:1519\n502#5,2:1520\n505#5,15:1530\n521#5:1556\n502#5,2:1557\n505#5,15:1561\n502#5,18:1587\n521#5:1614\n502#5,2:1615\n505#5,15:1619\n502#5,18:1645\n521#5:1700\n502#5,2:1701\n505#5,15:1705\n502#5,18:1731\n521#5:1794\n502#5,2:1795\n505#5,15:1803\n521#5:1845\n502#5,2:1846\n505#5,15:1852\n521#5:1877\n502#5,2:1878\n505#5,15:1882\n502#5,18:1908\n521#5:1978\n502#5,2:1979\n505#5,15:1987\n55#6:1446\n36#6:1447\n1134#7:1452\n1229#7,2:1453\n1135#7,2:1455\n1139#7:1459\n1234#7,2:1460\n1140#7,2:1462\n12033#8,10:1479\n14060#8:1489\n14061#8:1491\n12043#8:1492\n14088#8,2:1559\n14088#8,2:1617\n14088#8,2:1703\n12033#8,10:1754\n14060#8:1764\n14061#8:1766\n12043#8:1767\n14088#8,2:1880\n12033#8,10:1938\n14060#8:1948\n14061#8:1950\n12043#8:1951\n262#9,26:1493\n289#9,7:1545\n223#9,2:1552\n181#9,2:1554\n183#9,3:1576\n225#9,6:1579\n234#9:1586\n236#9,5:1605\n223#9,2:1610\n181#9,2:1612\n183#9,3:1634\n225#9,6:1637\n234#9:1644\n236#9,5:1663\n223#9,2:1696\n181#9,2:1698\n183#9,3:1720\n225#9,6:1723\n234#9:1730\n236#9,5:1749\n262#9,26:1768\n289#9,7:1818\n337#9,3:1834\n340#9:1839\n198#9,5:1840\n204#9,5:1867\n341#9:1872\n223#9,2:1873\n181#9,2:1875\n183#9,3:1897\n225#9,6:1900\n234#9:1907\n236#9,5:1926\n262#9,26:1952\n289#9,7:2002\n428#10,7:1668\n428#10,7:1682\n432#10,2:1825\n434#10:1829\n428#10,7:1931\n237#11:1827\n230#11:1828\n37#12,2:1837\n*S KotlinDebug\n*F\n+ 1 PgGPlumBaseIntrospector.kt\ncom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever\n*L\n627#1:1490\n677#1:1585\n703#1:1643\n824#1:1729\n849#1:1765\n1030#1:1906\n1096#1:1949\n552#1:1308\n552#1:1309,3\n769#1:1373\n769#1:1374,2\n916#1:1395,3\n919#1:1398\n919#1:1399,3\n920#1:1402,4\n923#1:1406\n923#1:1407,3\n924#1:1410\n924#1:1411,3\n925#1:1414\n925#1:1415,2\n925#1:1417,2\n925#1:1419\n925#1:1420\n987#1:1440,4\n1011#1:1444,2\n635#1:1522\n636#1:1523\n637#1:1524,2\n636#1:1526\n635#1:1527\n644#1:1528,2\n738#1:1675\n739#1:1676\n739#1:1677,2\n738#1:1679\n743#1:1680,2\n788#1:1689\n789#1:1690\n789#1:1691,2\n788#1:1693\n793#1:1694,2\n857#1:1797\n858#1:1798\n859#1:1799,2\n858#1:1801\n857#1:1802\n990#1:1830\n990#1:1831,3\n993#1:1848\n994#1:1849,2\n993#1:1851\n1104#1:1981\n1105#1:1982\n1106#1:1983,2\n1105#1:1985\n1104#1:1986\n593#1:1312\n593#1:1313,22\n661#1:1335\n661#1:1336,18\n733#1:1354\n733#1:1355,18\n782#1:1376\n782#1:1377,18\n944#1:1421\n944#1:1422,18\n1152#1:1448\n1152#1:1449,2\n1153#1:1451\n1153#1:1457,2\n1152#1:1464,15\n632#1:1519\n632#1:1520,2\n632#1:1530,15\n678#1:1556\n678#1:1557,2\n678#1:1561,15\n678#1:1587,18\n704#1:1614\n704#1:1615,2\n704#1:1619,15\n704#1:1645,18\n825#1:1700\n825#1:1701,2\n825#1:1705,15\n825#1:1731,18\n854#1:1794\n854#1:1795,2\n854#1:1803,15\n991#1:1845\n991#1:1846,2\n991#1:1852,15\n1031#1:1877\n1031#1:1878,2\n1031#1:1882,15\n1031#1:1908,18\n1101#1:1978\n1101#1:1979,2\n1101#1:1987,15\n1129#1:1446\n1129#1:1447\n1153#1:1452\n1153#1:1453,2\n1153#1:1455,2\n1153#1:1459\n1153#1:1460,2\n1153#1:1462,2\n627#1:1479,10\n627#1:1489\n627#1:1491\n627#1:1492\n680#1:1559,2\n706#1:1617,2\n827#1:1703,2\n849#1:1754,10\n849#1:1764\n849#1:1766\n849#1:1767\n1033#1:1880,2\n1096#1:1938,10\n1096#1:1948\n1096#1:1950\n1096#1:1951\n628#1:1493,26\n628#1:1545,7\n677#1:1552,2\n677#1:1554,2\n677#1:1576,3\n677#1:1579,6\n677#1:1586\n677#1:1605,5\n703#1:1610,2\n703#1:1612,2\n703#1:1634,3\n703#1:1637,6\n703#1:1644\n703#1:1663,5\n824#1:1696,2\n824#1:1698,2\n824#1:1720,3\n824#1:1723,6\n824#1:1730\n824#1:1749,5\n850#1:1768,26\n850#1:1818,7\n990#1:1834,3\n990#1:1839\n990#1:1840,5\n990#1:1867,5\n990#1:1872\n1030#1:1873,2\n1030#1:1875,2\n1030#1:1897,3\n1030#1:1900,6\n1030#1:1907\n1030#1:1926,5\n1097#1:1952,26\n1097#1:2002,7\n750#1:1668,7\n800#1:1682,7\n897#1:1825,2\n897#1:1829\n1060#1:1931,7\n900#1:1827\n900#1:1828\n990#1:1837,2\n*E\n"})
    protected static abstract class PgGPlumBaseSchemaRetriever<S extends PgGPlumBaseSchema>
    extends PgBaseIntrospector.SchemaRetriever<S> {
        private boolean wasEnums;
        private boolean wasDomains;
        final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$0;

        public PgGPlumBaseSchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((PgBaseIntrospector)this$0, transaction, (PgBaseSchema)schema);
        }

        @NotNull
        protected List<IntroStep> steps() {
            Object[] objectArray = new ObjectKind[]{ObjectKind.OPERATOR_CLASS, ObjectKind.OPERATOR_FAMILY};
            List list = PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)super.steps(), (int)1, (Set)SetsKt.setOf((Object)ObjectKind.SEQUENCE), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$0(this, arg_0), (int)4, null), (int)61, (Set)SetsKt.setOf((Object)ObjectKind.OBJECT_TYPE), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$1(this, arg_0), (int)4, null), (int)71, (Set)this.getTablesAndViews(), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$2(this, arg_0), (int)4, null), (int)82, (Set)this.getTablesAndViews(), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$3(this, arg_0), (int)4, null), (int)101, (Set)this.getTablesAndViews(), (Level)Level.L3, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$4(this, arg_0)), (int)81, (Set)this.getTablesAndViews(), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$5(this, arg_0), (int)4, null), (int)51, (Set)SetsKt.setOf((Object)ObjectKind.COLLATION), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$6(this, arg_0), (int)4, null), (int)21, (Set)SetsKt.setOf((Object)ObjectKind.FOREIGN_TABLE), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$7(this, arg_0), (int)4, null), (int)52, (Set)SetsKt.setOf((Object)ObjectKind.OPERATOR_CLASS), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$8(this, arg_0), (int)4, null), (int)53, (Set)SetsKt.setOf((Object)ObjectKind.OPERATOR_FAMILY), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$9(this, arg_0), (int)4, null), (int)54, (Set)SetsKt.setOf((Object[])objectArray), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$10(this, arg_0), (int)4, null);
            objectArray = new ObjectKind[]{ObjectKind.OPERATOR_CLASS, ObjectKind.OPERATOR_FAMILY};
            return PgBaseIntrospectorKt.add$default((List)PgBaseIntrospectorKt.add$default((List)list, (int)55, (Set)SetsKt.setOf((Object[])objectArray), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$11(this, arg_0), (int)4, null), (int)120, (Set)SetsKt.plus((Set)this.getTablesAndViews(), (Object)ObjectKind.SEQUENCE), null, arg_0 -> PgGPlumBaseSchemaRetriever.steps$lambda$12(this, arg_0), (int)4, null);
        }

        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.removeComments(existentComments, e);
            if (e instanceof PgGPlumBaseDefType) {
                for (Object c : ((PgGPlumBaseDefType)e).getChecks()) {
                    Intrinsics.checkNotNull((Object)c);
                    this.removeComments(existentComments, (BasicModIdentifiedElement)c);
                }
            }
            if (e instanceof PgGPlumBaseTable) {
                for (PgGPlumBaseTrigger t : ((PgGPlumBaseTable)e).getTriggers()) {
                    Intrinsics.checkNotNull((Object)t);
                    this.removeComments(existentComments, (BasicModIdentifiedElement)t);
                }
                for (PgGPlumBaseRule r : ((PgGPlumBaseTable)e).getRules()) {
                    Intrinsics.checkNotNull((Object)r);
                    this.removeComments(existentComments, (BasicModIdentifiedElement)r);
                }
                for (BasicModIndex idx : ((PgGPlumBaseTable)e).getIndices()) {
                    Intrinsics.checkNotNull((Object)idx, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseIndex");
                    this.removeComments(existentComments, (BasicModIdentifiedElement)((PgGPlumBaseIndex)idx));
                }
                for (Object c : ((PgGPlumBaseTable)e).getChecks()) {
                    Intrinsics.checkNotNull((Object)c);
                    this.removeComments(existentComments, (BasicModIdentifiedElement)c);
                }
            }
        }

        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgGPlumBaseAggregate cfr_ignored_0 = (PgGPlumBaseAggregate)aggregate;
            ((PgGPlumBaseAggregate)aggregate).setSortOperatorRef(this.this$0.createIdOrQNameRef(agg.sort_operator_id, agg.sort_operator_name, ((PgGPlumBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            ((PgGPlumBaseAggregate)aggregate).setAggregateKind(PgAggregateKind.of(agg.aggregate_kind));
            ((PgGPlumBaseAggregate)aggregate).setDirectArgs(agg.direct_args);
        }

        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull S schema) {
            BasicIdReference basicIdReference;
            long it;
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super.processDataType(dataType, oneType, (PgBaseSchema)schema);
            if (!(dataType instanceof PgGPlumBaseDefType)) {
                return;
            }
            Long l = oneType.base_type_id;
            long l2 = ((Number)l).longValue();
            PgGPlumBaseDefType pgGPlumBaseDefType = (PgGPlumBaseDefType)dataType;
            boolean bl = false;
            boolean bl2 = it != 0L;
            PgGPlumBaseDefType pgGPlumBaseDefType2 = pgGPlumBaseDefType;
            Long l3 = bl2 ? l : null;
            if (l3 != null) {
                it = ((Number)l3).longValue();
                pgGPlumBaseDefType = pgGPlumBaseDefType2;
                boolean bl3 = false;
                basicIdReference = BasicIdReference.create((long)it);
                pgGPlumBaseDefType2 = pgGPlumBaseDefType;
            } else {
                basicIdReference = null;
            }
            pgGPlumBaseDefType2.setBaseTypeRef((BasicReference)basicIdReference);
            ((PgGPlumBaseDefType)dataType).setOwnerRef((BasicReference)BasicNameReference.create((String)oneType.getOwnerName()));
            PgDataTypeSubKind pgDataTypeSubKind = ((PgGPlumBaseDefType)dataType).getSubKind();
            Intrinsics.checkNotNullExpressionValue((Object)pgDataTypeSubKind, (String)"getSubKind(...)");
            PgDataTypeSubKind subKind = pgDataTypeSubKind;
            this.wasEnums = this.wasEnums || subKind == PgDataTypeSubKind.ENUM;
            this.wasDomains = this.wasDomains || subKind == PgDataTypeSubKind.DOMAIN;
        }

        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Object[] objectArray = super.getSchemaChildrenToDrop((PgBaseSchema)schema);
            Object[] objectArray2 = new ModNamingIdentifyingFamily[5];
            Intrinsics.checkNotNullExpressionValue(schema.getSequences(), (String)"getSequences(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getCollations(), (String)"getCollations(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getOperatorFamilies(), (String)"getOperatorFamilies(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getOperatorClasses(), (String)"getOperatorClasses(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getForeignTables(), (String)"getForeignTables(...)");
            return (ModIdentifyingFamily[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
        }

        @NotNull
        protected ModNamingIdentifyingFamily<? extends PgBaseLikeStoredTable>[] tableFamilies(@NotNull S sc) {
            Intrinsics.checkNotNullParameter(sc, (String)"sc");
            return (ModNamingIdentifyingFamily[])ArraysKt.plus((Object[])super.tableFamilies((PgBaseSchema)sc), sc.getForeignTables());
        }

        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull S schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgBaseSchema)schema, oneTable);
            if (table instanceof PgGPlumBaseLikeMatTable && !(table instanceof PgGPlumBaseForeignTable)) {
                ((PgGPlumBaseLikeMatTable)table).setOptions(ArraysKt.toList((Object[])oneTable.options));
            }
            if (table instanceof PgGPlumBaseLocalTable) {
                Character c = StringsKt.getOrNull((CharSequence)oneTable.persistence, (int)0);
                ((PgGPlumBaseLocalTable)table).setPersistence(PgPersistence.of(c != null ? c.charValue() : (char)'p'));
            }
            this.setWasMatViews(this.getWasMatViews() || oneTable.table_kind == 'f');
        }

        /*
         * WARNING - void declaration
         */
        protected void processKey(@NotNull PgBaseKey key, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            super.processKey(key, table, con);
            if (!(table instanceof PgGPlumBaseLocalTable) || !(key instanceof PgGPlumBaseKey)) {
                return;
            }
            ((PgGPlumBaseKey)key).setDeferrable(con.is_deferrable);
            ((PgGPlumBaseKey)key).setInitiallyDeferred(con.is_init_deferred);
            Iterable iterable = ArraysKt.zip((Object[])con.excl_operators, (Object[])con.excl_operators_str);
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            PgGPlumBaseKey pgGPlumBaseKey = (PgGPlumBaseKey)key;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                long id = ((Number)pair.component1()).longValue();
                String txt = (String)pair.component2();
                collection.add(pgGPlumBaseIntrospector.createIdOrQNameRef(id, txt, pgGPlumBaseIntrospector.getDbConnectionInfo().schemaName));
            }
            pgGPlumBaseKey.setExclusionOperatorRefs((List)destination$iv$iv);
            long indexId = con.index_id;
            if (indexId != 0L) {
                ((PgGPlumBaseKey)key).setUnderlyingIndexRef((BasicReference)BasicIdReference.create((long)indexId));
            } else {
                BasicIdReference basicIdReference;
                List list = ((PgGPlumBaseKey)key).getColNames();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
                List colNames = list;
                PgGPlumBaseKey pgGPlumBaseKey2 = (PgGPlumBaseKey)key;
                PgGPlumBaseIndex pgGPlumBaseIndex = (PgGPlumBaseIndex)((PgGPlumBaseLocalTable)table).getIndices().find(arg_0 -> PgGPlumBaseSchemaRetriever.processKey$lambda$2(arg_0 -> PgGPlumBaseSchemaRetriever.processKey$lambda$1(colNames, arg_0), arg_0));
                if (pgGPlumBaseIndex != null) {
                    void it;
                    PgGPlumBaseIndex $i$f$mapTo2 = pgGPlumBaseIndex;
                    pgGPlumBaseKey = pgGPlumBaseKey2;
                    boolean bl = false;
                    basicIdReference = BasicIdReference.create((long)it.getObjectId());
                    pgGPlumBaseKey2 = pgGPlumBaseKey;
                } else {
                    basicIdReference = null;
                }
                pgGPlumBaseKey2.setUnderlyingIndexRef((BasicReference)basicIdReference);
            }
        }

        protected void processForeignKey(@NotNull PgBaseForeignKey fkey, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)fkey, (String)"fkey");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super.processForeignKey(fkey, table, con, (PgBaseSchema)schema);
            if (!this.hasReference(con)) {
                return;
            }
            fkey.setDeferrable(con.is_deferrable);
            fkey.setInitiallyDeferred(con.is_init_deferred);
            fkey.setOnUpdate(PgGPlumBaseIntrospectorKt.access$cascadeRule(con.on_update));
            fkey.setOnDelete(PgGPlumBaseIntrospectorKt.access$cascadeRule(con.on_delete));
        }

        protected void processCheck(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            if (!(table instanceof PgGPlumBaseTable)) {
                return;
            }
            BasicModNamedElement basicModNamedElement = ((PgGPlumBaseTable)table).getChecks().renew(con.con_id, con.con_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseCheck check = (PgGPlumBaseCheck)basicModNamedElement;
            check.setStateNumber(con.con_state_id);
            String string = con.con_columns;
            String string2 = "Check " + con.con_name + " column positions";
            ModPositioningNamingFamily<? extends PgGPlumBaseTableColumn> modPositioningNamingFamily = ((PgGPlumBaseTable)table).getColumns();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
            check.setColNames(this.peekColNames(string, string2, (PositioningFamily)modPositioningNamingFamily));
            String string3 = con.con_expression;
            check.setPredicate(string3 != null ? this.cleanupPredicate(string3) : null);
            check.setDeferrable(con.is_deferrable);
            check.setInitiallyDeferred(con.is_init_deferred);
            check.setNoInherit(con.no_inherit);
        }

        private final String cleanupPredicate(String $this$cleanupPredicate) {
            String string;
            int len = $this$cleanupPredicate.length();
            if (len > 2 && $this$cleanupPredicate.charAt(0) == '(' && $this$cleanupPredicate.charAt(len - 1) == ')') {
                String string2 = $this$cleanupPredicate.substring(1, len - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else {
                string = $this$cleanupPredicate;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected ModNamingIdentifyingFamily<?>[] constraintFamilies(@NotNull PgBaseTable table) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object[] it = super.constraintFamilies(table);
            boolean bl = false;
            return table instanceof PgGPlumBaseTable ? (ModNamingIdentifyingFamily[])ArraysKt.plus((Object[])it, ((PgGPlumBaseTable)table).getChecks()) : var2_2;
        }

        @NotNull
        protected PgGPlumBaseRoutine createRoutine(@NotNull S schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseRoutine pgBaseRoutine = super.createRoutine((PgBaseSchema)schema, r);
            Intrinsics.checkNotNull((Object)pgBaseRoutine, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine");
            PgGPlumBaseRoutine routine = (PgGPlumBaseRoutine)pgBaseRoutine;
            routine.setStrict(r.is_strict);
            routine.setCost(r.cost);
            routine.setLeakproof(r.is_leakproof);
            routine.setOwnerRef((BasicReference)BasicNameReference.create((String)r.getOwnerName()));
            return routine;
        }

        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o, @NotNull PgBaseOperator operator) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            super.processOperator(o, operator);
            if (!(operator instanceof PgGPlumBaseOperator)) {
                return;
            }
            ((PgGPlumBaseOperator)operator).setMerges(o.merges);
            ((PgGPlumBaseOperator)operator).setOwnerRef((BasicReference)BasicNameReference.create((String)o.getOwnerName()));
        }

        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return super.shouldIntrospectTableRelatedDataIncremental() || ((PgGPlumBaseSchema)this.getSchema()).getViews().hasChildren() || ((PgGPlumBaseSchema)this.getSchema()).getMatViews().hasChildren();
        }

        protected void retrieveRules(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.RULE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"RULE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveRules$lambda$0(this, removeUnaffected, this.this$0, detectDropped, loadNew, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveForeignTablesInfo() {
            void this_$iv;
            ObjectKind objectKind = ObjectKind.FOREIGN_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_TABLE");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveForeignTablesInfo$lambda$0$0(this, pgGPlumBaseIntrospector, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        protected void retrieveCollations(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.COLLATION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveCollations$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        protected void retrieveOperatorClasses(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.OPERATOR_CLASS;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OPERATOR_CLASS");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorClasses$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveAccessMethodOperators(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            void this_$iv;
            this.this$0.reportRetrieving("access method operators", "introspection.retrieve.accessMethod.operators");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var7_7 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveAccessMethodOperators$lambda$0$0(this, detectDropped, pgGPlumBaseIntrospector, loadNew, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<PgGPlumBaseOperatorAmHolder> getRelevantAmOwners() {
            List list;
            Object[] fNames = this.getFragmentNamesOrNull();
            if (fNames == null) {
                ModNamingIdentifyingFamily<? extends PgGPlumBaseOperatorClass> modNamingIdentifyingFamily = ((PgGPlumBaseSchema)this.getSchema()).getOperatorClasses();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getOperatorClasses(...)");
                Iterable iterable = (Iterable)modNamingIdentifyingFamily;
                ModNamingIdentifyingFamily<? extends PgGPlumBaseOperatorFamily> modNamingIdentifyingFamily2 = ((PgGPlumBaseSchema)this.getSchema()).getOperatorFamilies();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getOperatorFamilies(...)");
                list = CollectionsKt.plus((Iterable)iterable, (Iterable)((Iterable)modNamingIdentifyingFamily2));
            } else {
                void $this$filterTo$iv$iv;
                ModNamingIdentifyingFamily<? extends PgGPlumBaseOperatorClass> modNamingIdentifyingFamily = ((PgGPlumBaseSchema)this.getSchema()).getOperatorClasses();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getOperatorClasses(...)");
                Iterable iterable = (Iterable)modNamingIdentifyingFamily;
                ModNamingIdentifyingFamily<? extends PgGPlumBaseOperatorFamily> modNamingIdentifyingFamily3 = ((PgGPlumBaseSchema)this.getSchema()).getOperatorFamilies();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getOperatorFamilies(...)");
                Iterable $this$filter$iv = CollectionsKt.plus((Iterable)iterable, (Iterable)((Iterable)modNamingIdentifyingFamily3));
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PgGPlumBaseOperatorAmHolder it = (PgGPlumBaseOperatorAmHolder)element$iv$iv;
                    boolean bl = false;
                    if (!ArraysKt.contains((Object[])fNames, (Object)((PgBaseMajorSchemaObject)it).getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        private final void appendOps(PgGPlumBaseOperatorAmHolder $this$appendOps, ArrayList<PgAmOp> ops) {
            $this$appendOps.setAmOps(JBIterable.from((Iterable)$this$appendOps.getAmOps()).append((Iterable)ops).unique(arg_0 -> PgGPlumBaseSchemaRetriever.appendOps$lambda$1(PgGPlumBaseSchemaRetriever::appendOps$lambda$0, arg_0)).toList());
        }

        private final void appendProcs(PgGPlumBaseOperatorAmHolder $this$appendProcs, ArrayList<PgAmProc> ops) {
            $this$appendProcs.setAmProcs(JBIterable.from((Iterable)$this$appendProcs.getAmProcs()).append((Iterable)ops).unique(arg_0 -> PgGPlumBaseSchemaRetriever.appendProcs$lambda$1(PgGPlumBaseSchemaRetriever::appendProcs$lambda$0, arg_0)).toList());
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveAccessMethodProcedures(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            void this_$iv;
            this.this$0.reportRetrieving("access method procedures", "introspection.retrieve.accessMethod.routines");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var7_7 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveAccessMethodProcedures$lambda$0$0(this, detectDropped, pgGPlumBaseIntrospector, loadNew, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        protected void retrieveOperatorFamilies(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.OPERATOR_FAMILY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OPERATOR_FAMILY");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorFamilies$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        private final void retrieveIndices(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveIndices$lambda$0(this, removeUnaffected, this.this$0, detectDropped, loadNew, arg_0));
        }

        protected void processIndex(@NotNull PgGPlumBaseIndex index, @NotNull PgGPlumBaseIntroQueries.OneIndex ind) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            index.setStateNumber(ind.state_number);
            index.setUnique(ind.is_unique);
            index.setPrimary(ind.is_primary);
            index.setCondition(StringKt.nullize((String)ind.condition, (boolean)true));
            index.setAccessMethodRef((BasicReference)BasicIdReference.create((long)PgBaseIntrospectorKt.nullizeOid((long)ind.access_method_id)));
            index.setTablespaceRef((BasicReference)BasicIdReference.create((long)PgBaseIntrospectorKt.nullizeOid((long)ind.tablespace_id)));
        }

        private final void retrieveIndexColumns() {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveIndexColumns$lambda$0(this, this.this$0, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        protected void applyIndexColumns(@NotNull PgGPlumBaseIndex index, @NotNull List<PgGPlumBaseIntroQueries.OneIndexColumn> columns) {
            void destination$iv;
            void $this$filterIndexedTo$iv;
            PgGPlumBaseIntroQueries.OneIndexColumn c;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            int n;
            void $this$mapTo$iv$iv2;
            Object element$iv2;
            boolean bl;
            Object object;
            ModPositioningNamingFamily<? extends PgGPlumBaseLikeColumn> tableColumns;
            block12: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                Intrinsics.checkNotNullParameter(columns, (String)"columns");
                PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = index.getTable();
                Intrinsics.checkNotNull((Object)pgGPlumBaseLikeStoredTable);
                ModPositioningNamingFamily<? extends PgGPlumBaseLikeColumn> modPositioningNamingFamily = pgGPlumBaseLikeStoredTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                tableColumns = modPositioningNamingFamily;
                Iterable iterable = columns;
                object = index;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        PgGPlumBaseIntroQueries.OneIndexColumn it = (PgGPlumBaseIntroQueries.OneIndexColumn)element$iv2;
                        boolean bl2 = false;
                        if (!(it.expression != null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            object.setFunctionBased(bl3);
            Iterable $this$map$iv2 = columns;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                PgGPlumBaseIntroQueries.OneIndexColumn oneIndexColumn = (PgGPlumBaseIntroQueries.OneIndexColumn)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                String string = it.expression;
                if (string == null && (string = this.getColumnName((PositioningFamily)tableColumns, it.column_position)) == null) {
                    string = "";
                }
                object.add(string);
            }
            List colExprs = (List)destination$iv$iv;
            Iterable $this$count$iv = columns;
            boolean $i$f$count22 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv3 : $this$count$iv) {
                    PgGPlumBaseIntroQueries.OneIndexColumn it = (PgGPlumBaseIntroQueries.OneIndexColumn)element$iv3;
                    boolean bl5 = false;
                    if (!it.in_key || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int keySize = n;
            index.setColNames(keySize < columns.size() ? colExprs.subList(0, keySize) : colExprs);
            index.setIncludedColNames(keySize < columns.size() ? colExprs.subList(keySize, colExprs.size()) : CollectionsKt.emptyList());
            $this$count$iv = columns;
            Object $i$f$count22 = this.this$0;
            object = index;
            boolean $i$f$map2 = false;
            void $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PgGPlumBaseIntroQueries.OneIndexColumn oneIndexColumn = (PgGPlumBaseIntroQueries.OneIndexColumn)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                Long l = c.opclass;
                long l2 = ((Number)l).longValue();
                PgGPlumBaseIntrospector pgGPlumBaseIntrospector = $i$f$count22;
                boolean bl7 = false;
                Long l3 = Boolean.valueOf(c.opclass_str != null) != false ? l : null;
                collection.add(pgGPlumBaseIntrospector.createIdOrQNameRef(l3 != null ? l3 : 0L, c.opclass_str, c.opclass_schema));
            }
            object.setClassRefs((List)destination$iv$iv2);
            $this$map$iv = columns;
            $i$f$count22 = this.this$0;
            object = index;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                c = (PgGPlumBaseIntroQueries.OneIndexColumn)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                collection.add($i$f$count22.createIdOrQNameRef(it.collation, it.collation_str, it.collation_schema));
            }
            object.setCollationRefs((List)destination$iv$iv2);
            $this$map$iv = colExprs;
            $i$f$count22 = new LinkedHashSet();
            object = index;
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv = $this$filterIndexedTo$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void element$iv4;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object bl8 = item$iv$iv;
                int index$iv = n2;
                boolean bl9 = false;
                String cfr_ignored_0 = (String)element$iv4;
                int i2 = index$iv;
                boolean bl10 = false;
                PgGPlumBaseIntroQueries.OneIndexColumn $this$applyIndexColumns_u24lambda_u245_u240 = columns.get(i2);
                boolean bl11 = false;
                boolean bl12 = $this$applyIndexColumns_u24lambda_u245_u240.can_order && ($this$applyIndexColumns_u24lambda_u245_u240.column_options & 1) == 1;
                if (!bl12) continue;
                destination$iv.add(element$iv4);
            }
            object.setReverseColNames((Set)destination$iv);
            index.setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)index));
        }

        private final ModNamingIdentifyingFamily<? extends PgGPlumBaseIndex> indexFamilyOf(PgBaseLikeStoredTable table) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (pgBaseLikeStoredTable instanceof PgGPlumBaseLocalTable) {
                return ((PgGPlumBaseLocalTable)table).getIndices();
            }
            if (pgBaseLikeStoredTable instanceof PgGPlumBaseMatView) {
                return ((PgGPlumBaseMatView)table).getIndices();
            }
            return null;
        }

        @Nullable
        protected final PgGPlumBaseIndex createIndex(@NotNull PgBaseLikeStoredTable table, @NotNull PgGPlumBaseIntroQueries.OneIndex ind) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            ModNamingIdentifyingFamily<PgGPlumBaseIndex> modNamingIdentifyingFamily = this.indexFamilyOf(table);
            return modNamingIdentifyingFamily != null ? (PgGPlumBaseIndex)modNamingIdentifyingFamily.renew(ind.index_id, ind.index_name) : null;
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveEnumLabels() {
            void this_$iv;
            if (!(this.wasEnums || this.getMode().increment && ((PgGPlumBaseSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            this.this$0.reportRetrieving("enums", "introspection.retrieve.enums");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                Map els = (Map)this.performQuery(pgGPlumBaseIntrospector.getQueries().getRetrieveEnumLabels());
                if (els.isEmpty()) {
                    return;
                }
                this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveEnumLabels$lambda$0$0(els, this, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        @NotNull
        protected List<String> fixLabelsOrder(@NotNull String[] labels) {
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            return CollectionsKt.listOf((Object[])Arrays.copyOf(labels, labels.length));
        }

        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super.processColumn(col, column, columns, table);
            if (!(column instanceof PgGPlumBaseTableColumn)) {
                return;
            }
            ((PgGPlumBaseTableColumn)column).setTypeRef((BasicReference)BasicIdReference.create((long)col.type_id));
            ((PgGPlumBaseTableColumn)column).setInherited(col.column_is_inherited);
            if (column instanceof PgGPlumBaseForeignTableColumn) {
                ((PgGPlumBaseForeignTableColumn)column).setOptions(ArraysKt.toList((Object[])col.options));
            }
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            super.handleColumnRenaming(table, oldName, tableName);
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"CHECK");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        protected void retrieveDataTypes(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            super.retrieveDataTypes(removeUnaffected, detectDropped, loadNew);
            this.retrieveDataTypeChecks();
        }

        /*
         * Unable to fully structure code
         */
        protected void retrieveDataTypeChecks() {
            v0 = this;
            if (this.wasDomains) ** GOTO lbl-1000
            v1 = ((PgGPlumBaseSchema)this.getSchema()).getDefTypes().jbi();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"jbi(...)");
            var1_1 = (Iterable)v1;
            var8_2 = v0;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v2 = 0;
            } else {
                count$iv = 0;
                for (T element$iv : $this$count$iv) {
                    it = (PgGPlumBaseDefType)element$iv;
                    $i$a$-count-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveDataTypeChecks$1 = false;
                    if (!(it.getSubKind() == PgDataTypeSubKind.DOMAIN) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v2 = var3_4;
            }
            var9_9 = v2;
            v0 = var8_2;
            if (var9_9 > 0) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = v0.wasDomains = false;
            }
            if (!this.wasDomains) {
                return;
            }
            this.inSchema((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, retrieveDataTypeChecks$lambda$1(com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema ), (Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;)Lkotlin/Unit;)(this.this$0, (PgGPlumBaseSchemaRetriever)this));
        }

        @NotNull
        protected Long2ObjectMap<Short[]> listExistentComments() {
            Long2ObjectOpenHashMap existentComments = new Long2ObjectOpenHashMap();
            Iterable $this$forEach$iv = (Iterable)this.performQuery(this.this$0.getQueries().getListExistentSchemaComments());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PgGPlumBaseIntroQueries.IdAndSubIds it = (PgGPlumBaseIntroQueries.IdAndSubIds)element$iv;
                boolean bl = false;
                existentComments.put(it.id, (Object)PgBaseIntrospectorKt.optimizeFor0((Short[])it.sub_ids));
            }
            return (Long2ObjectMap)existentComments;
        }

        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof PgGPlumBaseTable)) {
                return;
            }
            if (table instanceof PgGPlumBaseLocalTable) {
                BasicIdReference basicIdReference;
                long it;
                ((PgGPlumBaseLocalTable)table).setWithOids(t.table_with_oids);
                Long l = t.tablespace_id;
                long l2 = ((Number)l).longValue();
                PgGPlumBaseLocalTable pgGPlumBaseLocalTable = (PgGPlumBaseLocalTable)table;
                boolean bl = false;
                boolean bl2 = it != 0L;
                PgGPlumBaseLocalTable pgGPlumBaseLocalTable2 = pgGPlumBaseLocalTable;
                Long l3 = bl2 ? l : null;
                if (l3 != null) {
                    it = ((Number)l3).longValue();
                    pgGPlumBaseLocalTable = pgGPlumBaseLocalTable2;
                    boolean bl3 = false;
                    basicIdReference = BasicIdReference.create((long)it);
                    pgGPlumBaseLocalTable2 = pgGPlumBaseLocalTable;
                } else {
                    basicIdReference = null;
                }
                pgGPlumBaseLocalTable2.setTablespaceRef((BasicReference)basicIdReference);
            }
            ((PgGPlumBaseTable)table).setAncestorIds(this.this$0.parseListOfLongs(t.ancestors));
            ((PgGPlumBaseTable)table).setSuccessorIds(this.this$0.parseSmallSetOfLongs(t.successors));
            for (PgGPlumBaseTable ancestor : PgGPlumBaseModelHelperKt.getAncestors((PgGPlumBaseTable)table)) {
                PgGPlumBaseUtil.addSuccessor(ancestor, ((PgGPlumBaseTable)table).getObjectId());
            }
        }

        private final void retrieveSequences(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveSequences$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        @NotNull
        protected SqlQuery<List<PgGPlumBaseIntroQueries.OneSequence>> getSequencesQuery() {
            return this.this$0.getQueries().getRetrieveSequences();
        }

        private final void retrieveRelations() {
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveRelations$lambda$0(this, this.this$0, arg_0));
        }

        private final void applyTableRelations(PgGPlumBaseLocalTable table, Long2LongOpenHashMap relations, LongOpenHashSet processedTables) {
            processedTables.add(table.getObjectId());
            for (PgGPlumBaseLocalTableColumn column : table.getColumns()) {
                long sequenceId = relations.getOrDefault((long)column.getPosition(), -1L);
                if (sequenceId == -1L) {
                    column.setSequenceRef(null);
                    continue;
                }
                column.setSequenceRef((BasicReference)BasicIdReference.create((long)sequenceId));
            }
        }

        protected void retrieveTriggers(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> PgGPlumBaseSchemaRetriever.retrieveTriggers$lambda$0(this, removeUnaffected, this.this$0, detectDropped, loadNew, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        protected void processTrigger(@NotNull PgGPlumBaseTrigger trigger, @NotNull PgGPlumBaseIntroQueries.OneTrigger t) {
            void $this$hasBit$iv;
            TrigTurn trigTurn;
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            trigger.setCallRoutineRef((BasicReference)BasicIdReference.create((long)t.function_id));
            trigger.setCallArgs(this.parseTriggerCallArgs(t.function_args));
            trigger.setStateNumber(t.trigger_state_number);
            trigger.setEvents(PgGPlumBaseIntrospectorKt.access$makeTrigEvents(t.bits));
            TrigTurn trigTurn2 = trigTurn = TrigTurn.INSTEAD_OF;
            PgGPlumBaseTrigger pgGPlumBaseTrigger = trigger;
            boolean bl = false;
            byte by = t.bits;
            int that$iv = 64;
            boolean $i$f$hasBit = false;
            void $this$toUnsignedInt$iv$iv = $this$hasBit$iv;
            boolean $i$f$toUnsignedInt = false;
            boolean bl2 = (Byte.toUnsignedInt((byte)$this$toUnsignedInt$iv$iv) & that$iv) != 0;
            Object object = bl2 ? trigTurn : null;
            if (object == null) {
                switch (t.bits & 3) {
                    case 0: {
                        object = TrigTurn.AFTER_STMT;
                        break;
                    }
                    case 1: {
                        object = TrigTurn.AFTER_ROW;
                        break;
                    }
                    case 2: {
                        object = TrigTurn.BEFORE_STMT;
                        break;
                    }
                    case 3: {
                        object = TrigTurn.BEFORE_ROW;
                        break;
                    }
                    default: {
                        object = TrigTurn.AFTER_ROW;
                    }
                }
            }
            pgGPlumBaseTrigger.setTurn((TrigTurn)object);
            PgFireMode pgFireMode = PgFireMode.of(t.trigger_fire_mode);
            if (pgFireMode == null) {
                pgFireMode = PgFireMode.ORIGIN;
            }
            trigger.setFireMode(pgFireMode);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final List<String> parseTriggerCallArgs(String str) {
            List list;
            if (str != null) {
                String it = str;
                boolean bl = false;
                String string = StringUtil.unescapeStringCharacters((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringCharacters(...)");
                char[] cArray = new char[]{'\u0000'};
                List list2 = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (list2 != null) {
                    List list3;
                    List list4;
                    List it2 = list4 = list2;
                    boolean bl2 = false;
                    List list5 = list3 = it2.size() > 1 ? list4 : null;
                    if (list3 != null) {
                        List it3 = list3;
                        boolean bl3 = false;
                        list4 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)it3), (int)(it3.size() - 1)), PgGPlumBaseSchemaRetriever::parseTriggerCallArgs$lambda$2$0));
                        if (list4 != null) {
                            list = list4;
                            return list;
                        }
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void retrieveRulesSources() {
            void this_$iv;
            if (!this.getWithSources() || !this.shouldIntrospectTableRelatedDataIncremental()) {
                return;
            }
            this.this$0.reportRetrieving("rule and trigger sources", "introspection.retrieve.trigger.sources");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgGPlumBaseIntrospector pgGPlumBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv;
                void $this$iv$iv$iv;
                void this_$iv$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)pgGPlumBaseIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv2;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                void var13_13 = this_$iv$iv;
                String name$iv$iv$iv = name$iv$iv;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv2.getModel().writeSources(new Runnable(this, pgGPlumBaseIntrospector){
                        final /* synthetic */ PgGPlumBaseSchemaRetriever this$0;
                        final /* synthetic */ PgGPlumBaseIntrospector this$1$inlined;
                        {
                            this.this$0 = pgGPlumBaseSchemaRetriever;
                            this.this$1$inlined = pgGPlumBaseIntrospector;
                        }

                        public final void run() {
                            boolean bl = false;
                            PgGPlumBaseSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                                final /* synthetic */ PgGPlumBaseSchemaRetriever<S> this$0;
                                final /* synthetic */ PgGPlumBaseIntrospector<MR, D, SL> this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final void invoke(S schema) {
                                    Intrinsics.checkNotNullParameter(schema, (String)"schema");
                                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this.this$0), this.this$1.getQueries().getRetrieveRuleSources(), (int)0, (Function1)((Function1)new Function1<PgGPlumBaseIntroQueries.OneRuleSource, Unit>(this.this$0, schema){
                                        final /* synthetic */ PgGPlumBaseSchemaRetriever<S> this$0;
                                        final /* synthetic */ S $schema;
                                        {
                                            this.this$0 = $receiver;
                                            this.$schema = $schema;
                                        }

                                        public final void invoke(PgGPlumBaseIntroQueries.OneRuleSource r) {
                                            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                            ModNamingIdentifyingFamily<? extends PgGPlumBaseRule> table = this.this$0.getTableOrView(this.$schema, r.table_kind, r.table_id);
                                            Object object = table;
                                            if (object == null || (object = object.getRules()) == null || (object = (PgGPlumBaseRule)object.getByObjectId(r.rule_id)) == null) {
                                                return;
                                            }
                                            Object rule = object;
                                            String string = r.source_text;
                                            rule.setSourceText((CompositeText)(string != null ? BaseIntrospectionFunctions.toCompositeText((String)string, (CompositeText.Kind)CompositeText.Kind.ORIGINAL_TEXT) : null));
                                            table.setDetailsLevel(Level.L3);
                                        }
                                    }), (int)2, null);
                                }
                            });
                        }
                    });
                    $this$iv$iv$iv = this_$iv$iv;
                    sectionReference$iv$iv$iv = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv == null) return;
                }
                catch (Throwable throwable) {
                    void this_$iv$iv$iv2;
                    sectionReference$iv$iv$iv = this_$iv$iv;
                    DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv2 == null) throw throwable;
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                    if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                    throw throwable;
                }
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                if (dataSourceDiagnosticRecorder3 == null) return;
                DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
                return;
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        @Nullable
        protected PgGPlumBaseLikeStoredTable getTableOrView(@NotNull S schema, char relKind, long tableId) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            PgBaseLikeStoredTable pgBaseLikeStoredTable = super.getTableOrView((PgBaseSchema)schema, relKind, tableId);
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = pgBaseLikeStoredTable instanceof PgGPlumBaseLikeStoredTable ? (PgGPlumBaseLikeStoredTable)pgBaseLikeStoredTable : null;
            if (pgGPlumBaseLikeStoredTable == null) {
                switch (Character.toLowerCase(relKind)) {
                    case '\u0000': 
                    case 'f': {
                        pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema.getForeignTables().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgGPlumBaseLikeStoredTable = null;
                    }
                }
            }
            return pgGPlumBaseLikeStoredTable;
        }

        @Nullable
        protected PgBaseLikeStoredTable renewTableOrViewImpl(@NotNull S schema, char relKind, long objectId, @NotNull String objectName) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            return relKind == 'f' ? (PgBaseLikeStoredTable)schema.getForeignTables().renew(objectId, objectName) : super.renewTableOrViewImpl((PgBaseSchema)schema, relKind, objectId, objectName);
        }

        private static final Unit steps$lambda$0(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u240_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveSequences($this$steps_u24lambda_u240_u240.getRemoveUnaffected(), $this$steps_u24lambda_u240_u240.getDetectDropped(), $this$steps_u24lambda_u240_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$1(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveEnumLabels();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$2(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u242_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveIndices($this$steps_u24lambda_u242_u240.getRemoveUnaffected(), $this$steps_u24lambda_u242_u240.getDetectDropped(), $this$steps_u24lambda_u242_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u243_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveTriggers($this$steps_u24lambda_u243_u240.getRemoveUnaffected(), $this$steps_u24lambda_u243_u240.getDetectDropped(), $this$steps_u24lambda_u243_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$4(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveRulesSources();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$5(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u245_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveRules($this$steps_u24lambda_u245_u240.getRemoveUnaffected(), $this$steps_u24lambda_u245_u240.getDetectDropped(), $this$steps_u24lambda_u245_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$6(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u246_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveCollations($this$steps_u24lambda_u246_u240.getRemoveUnaffected(), $this$steps_u24lambda_u246_u240.getDetectDropped(), $this$steps_u24lambda_u246_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$7(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveForeignTablesInfo();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$8(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u248_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveOperatorClasses($this$steps_u24lambda_u248_u240.getRemoveUnaffected(), $this$steps_u24lambda_u248_u240.getDetectDropped(), $this$steps_u24lambda_u248_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$9(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u249_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveOperatorFamilies($this$steps_u24lambda_u249_u240.getRemoveUnaffected(), $this$steps_u24lambda_u249_u240.getDetectDropped(), $this$steps_u24lambda_u249_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$10(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u2410_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveAccessMethodOperators($this$steps_u24lambda_u2410_u240.getRemoveUnaffected(), $this$steps_u24lambda_u2410_u240.getDetectDropped(), $this$steps_u24lambda_u2410_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$11(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u2411_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveAccessMethodProcedures($this$steps_u24lambda_u2411_u240.getRemoveUnaffected(), $this$steps_u24lambda_u2411_u240.getDetectDropped(), $this$steps_u24lambda_u2411_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$12(PgGPlumBaseSchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            this$0.retrieveRelations();
            return Unit.INSTANCE;
        }

        private static final boolean processKey$lambda$1(List $colNames, PgGPlumBaseIndex it) {
            return Intrinsics.areEqual((Object)((BasicColumniation)it).getColNames(), (Object)$colNames);
        }

        private static final boolean processKey$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveRules$lambda$0(PgGPlumBaseSchemaRetriever this$0, boolean $removeUnaffected, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            void removeUnaffected$iv;
            void fragments$iv;
            String[] $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv22 = this$0.tableFamilies((Object)schema);
            boolean $i$f$mapNotNull22 = false;
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                ModNamingFamily it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ModelFun.tryCast((ModNamingFamily)((ModNamingFamily)it), PgGPlumBaseLikeStoredTable.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            boolean $this$mapNotNull$iv22 = $removeUnaffected;
            Iterable $i$f$mapNotNull22 = tables;
            $this$mapNotNullTo$iv$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamilyFragmentsAndCleanupInner = false;
            List relevantInnerFamilies$iv = new ArrayList();
            if (fragments$iv == null) {
                for (ModNamingFamily family$iv : majorFamilies$iv) {
                    for (BasicModNamedElement element$iv : family$iv) {
                        Intrinsics.checkNotNull((Object)element$iv);
                        PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(t.getRules());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            } else {
                for (Iterator<Object> fragment$iv : fragments$iv) {
                    for (ModNamingFamily family$iv : majorFamilies$iv) {
                        BasicModNamedElement element$iv;
                        if ((BasicModNamedElement)family$iv.get(fragment$iv) == null) continue;
                        PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(t.getRules());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            }
            if (removeUnaffected$iv != false) {
                for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                    innerFamily$iv.markChildrenAsSyncPending();
                }
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl4 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentRules()));
                    Iterable $this$forEach$iv = tables;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModNamingFamily tf = (ModNamingFamily)element$iv;
                        boolean bl5 = false;
                        Iterable $this$forEach$iv2 = (Iterable)tf;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv2;
                            boolean bl6 = false;
                            ModNamingIdentifyingFamily<? extends PgGPlumBaseRule> modNamingIdentifyingFamily = t.getRules();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getRules(...)");
                            Iterable $this$forEach$iv3 = (Iterable)modNamingIdentifyingFamily;
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv3 : $this$forEach$iv3) {
                                PgGPlumBaseRule it = (PgGPlumBaseRule)element$iv3;
                                boolean bl7 = false;
                                if (!ids.contains(it.getObjectId())) continue;
                                it.resetSyncPending();
                            }
                        }
                    }
                }
                if ($loadNew && this$0.shouldIntrospectTableRelatedData()) {
                    Iterable $this$forEach$iv = (Iterable)this$0.performQuery(this$1.getQueries().getRetrieveRules());
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseLikeStoredTable table;
                        PgGPlumBaseIntroQueries.OneRule r = (PgGPlumBaseIntroQueries.OneRule)element$iv;
                        boolean bl8 = false;
                        if (this$0.getTableOrView((Object)schema, '\u0000', r.table_id) == null) continue;
                        BasicModNamedElement basicModNamedElement = table.getRules().renew(r.rule_id, r.rule_name);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                        PgGPlumBaseRule rule = (PgGPlumBaseRule)basicModNamedElement;
                        rule.setStateNumber(r.rule_state_number);
                        rule.setEvents(Collections.singleton(TrigEvent.of((char)r.rule_event_code)));
                        rule.setTurn(r.rule_is_instead ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                        PgFireMode pgFireMode = PgFireMode.of(r.rule_fire_mode);
                        if (pgFireMode == null) {
                            pgFireMode = PgFireMode.ORIGIN;
                        }
                        rule.setFireMode(pgFireMode);
                    }
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl9 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                if (removeUnaffected$iv != false) {
                    innerFamily$iv.removeSyncPendingChildren();
                }
                innerFamily$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignTablesInfo$lambda$0$0$0(PgGPlumBaseSchema $sc, PgGPlumBaseIntroQueries.OneForeignTable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            PgGPlumBaseForeignTable pgGPlumBaseForeignTable = (PgGPlumBaseForeignTable)$sc.getForeignTables().getByObjectId(t.table_id);
            if (pgGPlumBaseForeignTable == null) {
                return Unit.INSTANCE;
            }
            PgGPlumBaseForeignTable table = pgGPlumBaseForeignTable;
            table.setServerRef((BasicReference)BasicNameReference.create((String)t.table_server));
            table.setOptions(ArraysKt.toList((Object[])t.table_options));
            table.setOwnerRef((BasicReference)BasicNameReference.create((String)t.getOwnerName()));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignTablesInfo$lambda$0$0(PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, PgGPlumBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveForeignTables(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveForeignTablesInfo$lambda$0$0$0(sc, arg_0), (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCollations$lambda$0$0$0$1(PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneCollation c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            BasicModNamedElement basicModNamedElement = $schema.getCollations().renew(c.id, c.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseCollation collation = (PgGPlumBaseCollation)basicModNamedElement;
            collation.setStateNumber(c.state_number);
            String string = c.lc_collate;
            collation.setCollate(string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null);
            String string2 = c.lc_ctype;
            collation.setCType(string2 != null ? StringKt.nullize$default((String)string2, (boolean)false, (int)1, null) : null);
            collation.setOwnerRef((BasicReference)BasicNameReference.create((String)c.getOwnerName()));
            collation.setDetailsLevel(LevelFun.max((Level)collation.getDetailsLevel(), (Level)Level.L2));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveCollations$lambda$0(boolean $removeUnaffected, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getCollations();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentCollations());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it2 = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgGPlumBaseCollation pgGPlumBaseCollation = (PgGPlumBaseCollation)schema.getCollations().getByObjectId(it2);
                            if (pgGPlumBaseCollation != null) {
                                ((BasicModMixinElement)pgGPlumBaseCollation).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveCollations(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveCollations$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentCollations());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it3 = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgGPlumBaseCollation pgGPlumBaseCollation = (PgGPlumBaseCollation)schema.getCollations().getByObjectId(it3);
                            if (pgGPlumBaseCollation != null) {
                                ((BasicModMixinElement)pgGPlumBaseCollation).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveCollations(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveCollations$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveOperatorClasses$lambda$0$0$0$1(PgGPlumBaseSchema $schema, PgGPlumBaseIntrospector this$0, PgGPlumBaseIntroQueries.OneOperatorClass c) {
            String string;
            PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass;
            PgGPlumBaseOperatorClass opc;
            block7: {
                block6: {
                    String it;
                    PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass2;
                    String string2;
                    PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass3;
                    block5: {
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                            BasicModNamedElement basicModNamedElement = $schema.getOperatorClasses().renew(c.id, c.name);
                            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                            opc = (PgGPlumBaseOperatorClass)basicModNamedElement;
                            opc.setStateNumber(c.state_number);
                            pgGPlumBaseOperatorClass3 = opc;
                            string2 = c.in_type;
                            if (string2 == null) break block4;
                            String string3 = string2;
                            pgGPlumBaseOperatorClass2 = pgGPlumBaseOperatorClass3;
                            boolean bl = false;
                            DataType dataType = DataTypeFactory.of((String)it);
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                            DasType dasType = DasUnresolvedTypeReference.Companion.of(dataType);
                            pgGPlumBaseOperatorClass3 = pgGPlumBaseOperatorClass2;
                            string2 = dasType;
                            if (dasType != null) break block5;
                        }
                        string2 = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    pgGPlumBaseOperatorClass3.setInStoredType((DasType)string2);
                    pgGPlumBaseOperatorClass = opc;
                    string = c.key_type;
                    if (string == null) break block6;
                    it = string;
                    pgGPlumBaseOperatorClass2 = pgGPlumBaseOperatorClass;
                    boolean bl = false;
                    DataType dataType = DataTypeFactory.of((String)it);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    DasType dasType = DasUnresolvedTypeReference.Companion.of(dataType);
                    pgGPlumBaseOperatorClass = pgGPlumBaseOperatorClass2;
                    string = dasType;
                    if (dasType != null) break block7;
                }
                string = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            pgGPlumBaseOperatorClass.setKeyStoredType((DasType)string);
            opc.setDefaultClass(c.is_default);
            opc.setOperatorFamilyRef(this$0.createIdOrQNameRef(c.family_id, c.family, ((PgGPlumBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            opc.setAccessMethodRef((BasicReference)BasicIdReference.create((long)c.access_method_id));
            opc.setOwnerRef((BasicReference)BasicNameReference.create((String)c.getOwnerName()));
            opc.setDetailsLevel(LevelFun.max((Level)opc.getDetailsLevel(), (Level)Level.L2));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveOperatorClasses$lambda$0(boolean $removeUnaffected, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getOperatorClasses();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperatorClasses());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it2 = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass = (PgGPlumBaseOperatorClass)schema.getOperatorClasses().getByObjectId(it2);
                            if (pgGPlumBaseOperatorClass != null) {
                                ((BasicModMixinElement)pgGPlumBaseOperatorClass).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperatorClasses(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorClasses$lambda$0$0$0$1(schema, this$1, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperatorClasses());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it3 = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass = (PgGPlumBaseOperatorClass)schema.getOperatorClasses().getByObjectId(it3);
                            if (pgGPlumBaseOperatorClass != null) {
                                ((BasicModMixinElement)pgGPlumBaseOperatorClass).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperatorClasses(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorClasses$lambda$0$0$0$1(schema, this$1, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveAccessMethodOperators$lambda$0$0$2(IdCache $oh, ArrayList $ops, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneAmOp f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            var5_5 = $oh;
            v0 = f.class_id;
            id$iv = v0 != null ? v0 : f.family_id;
            $i$f$get = false;
            var9_9 = this_$iv;
            id$iv$iv = id$iv;
            $i$f$getOrCache = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v1 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v1);
            if (((BasicIdentifiedElement)v1).getObjectId() == id$iv$iv) {
                v2 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var13_13 = id$iv$iv;
                var15_14 = this_$iv$iv;
                var16_15 = this_$iv$iv;
                $i$a$-getOrCache-IdCache$get$1$iv = false;
                var18_17 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                    final /* synthetic */ long $id;
                    {
                        this.$id = $id;
                    }

                    public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                    }
                };
                $this$retrieveAccessMethodOperators_u24lambda_u240_u240_u242_u240 = $this$get_u24lambda_u240$iv;
                $i$a$-get-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveAccessMethodOperators$1$1$3$1 = false;
                v3 = (PgGPlumBaseOperatorAmHolder)$this$retrieveAccessMethodOperators_u24lambda_u240_u240_u242_u240.getV();
                if (v3 != null) {
                    PgGPlumBaseSchemaRetriever.access$appendOps(this$0, v3, $ops);
                }
                $ops.clear();
                v4 = $schema.getOperatorFamilies();
                Intrinsics.checkNotNullExpressionValue(v4, (String)"getOperatorFamilies(...)");
                v5 = (PgGPlumBaseOperatorAmHolder)it.invoke(v4);
                if (v5 == null) {
                    v6 = $schema.getOperatorClasses();
                    Intrinsics.checkNotNullExpressionValue(v6, (String)"getOperatorClasses(...)");
                    v5 = (PgGPlumBaseOperatorAmHolder)it.invoke(v6);
                }
                var16_15.setV((BasicModIdentifiedElement)v5);
                v2 = this_$iv$iv.getV();
            }
            var5_5 = $ops;
            $i$f$get = var7_20 = f.sort_family_id;
            var26_21 = f.op_sig;
            var24_22 = f.op_id;
            var23_23 = f.strategy;
            var21_24 = f.id;
            $i$a$-takeIf-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveAccessMethodOperators$1$1$3$2 = false;
            v7 = it;
            var10_11 = 0L;
            var27_25 = v7 == null || v7.longValue() != var10_11;
            v8 = var27_25 != false ? var7_20 : null;
            var28_26 = StringKt.nullize$default((String)f.sort_family, (boolean)false, (int)1, null);
            var29_27 = v8 != null ? v8 : -9223372036854775808L;
            var31_28 = var26_21;
            var32_29 = var24_22;
            var34_30 = var23_23;
            var35_31 = var21_24;
            var5_5.add(new PgAmOp(var35_31, var34_30, var32_29, var31_28, var29_27, var28_26));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveAccessMethodOperators$lambda$0$0(PgGPlumBaseSchemaRetriever this$0, boolean $detectDropped, PgGPlumBaseIntrospector this$1, boolean $loadNew, PgGPlumBaseSchema schema) {
            block6: {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                List<PgGPlumBaseOperatorAmHolder> relevantOwners = this$0.getRelevantAmOwners();
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentAmOps()));
                    Iterable $this$forEach$iv = relevantOwners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        PgGPlumBaseOperatorAmHolder ah = (PgGPlumBaseOperatorAmHolder)element$iv;
                        boolean bl = false;
                        List<PgAmOp> list = ah.getAmOps();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getAmOps(...)");
                        Iterable iterable = list;
                        PgGPlumBaseOperatorAmHolder pgGPlumBaseOperatorAmHolder = ah;
                        boolean $i$f$filter = false;
                        void var16_21 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            PgAmOp it = (PgAmOp)element$iv$iv;
                            boolean bl2 = false;
                            if (!ids.contains(it.getId())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        pgGPlumBaseOperatorAmHolder.setAmOps((List)destination$iv$iv);
                    }
                } else {
                    Iterable $this$forEach$iv = relevantOwners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseOperatorAmHolder it = (PgGPlumBaseOperatorAmHolder)element$iv;
                        boolean bl = false;
                        it.setAmOps(CollectionsKt.emptyList());
                    }
                }
                if (!$loadNew) break block6;
                IdCache oh = new IdCache();
                ArrayList<PgAmOp> ops = new ArrayList<PgAmOp>();
                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveAmOps(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveAccessMethodOperators$lambda$0$0$2(oh, ops, this$0, schema, arg_0), (int)2, null);
                PgGPlumBaseOperatorAmHolder pgGPlumBaseOperatorAmHolder = (PgGPlumBaseOperatorAmHolder)oh.getV();
                if (pgGPlumBaseOperatorAmHolder != null) {
                    this$0.appendOps(pgGPlumBaseOperatorAmHolder, ops);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Object appendOps$lambda$0(PgAmOp it) {
            return it.getId();
        }

        private static final Object appendOps$lambda$1(Function1 $tmp0, Object p0) {
            return $tmp0.invoke(p0);
        }

        private static final Object appendProcs$lambda$0(PgAmProc it) {
            return it.getId();
        }

        private static final Object appendProcs$lambda$1(Function1 $tmp0, Object p0) {
            return $tmp0.invoke(p0);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveAccessMethodProcedures$lambda$0$0$2(IdCache $oh, ArrayList $procs, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneAmProc f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            var5_5 = $oh;
            v0 = f.class_id;
            id$iv = v0 != null ? v0 : f.family_id;
            $i$f$get = false;
            var9_8 = this_$iv;
            id$iv$iv = id$iv;
            $i$f$getOrCache = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v1 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v1);
            if (((BasicIdentifiedElement)v1).getObjectId() == id$iv$iv) {
                v2 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var13_11 = id$iv$iv;
                var15_12 = this_$iv$iv;
                var16_13 = this_$iv$iv;
                $i$a$-getOrCache-IdCache$get$1$iv = false;
                var18_15 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                    final /* synthetic */ long $id;
                    {
                        this.$id = $id;
                    }

                    public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                    }
                };
                $this$retrieveAccessMethodProcedures_u24lambda_u240_u240_u242_u240 = $this$get_u24lambda_u240$iv;
                $i$a$-get-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveAccessMethodProcedures$1$1$3$1 = false;
                v3 = (PgGPlumBaseOperatorAmHolder)$this$retrieveAccessMethodProcedures_u24lambda_u240_u240_u242_u240.getV();
                if (v3 != null) {
                    PgGPlumBaseSchemaRetriever.access$appendProcs(this$0, v3, $procs);
                }
                $procs.clear();
                v4 = $schema.getOperatorFamilies();
                Intrinsics.checkNotNullExpressionValue(v4, (String)"getOperatorFamilies(...)");
                v5 = (PgGPlumBaseOperatorAmHolder)it.invoke(v4);
                if (v5 == null) {
                    v6 = $schema.getOperatorClasses();
                    Intrinsics.checkNotNullExpressionValue(v6, (String)"getOperatorClasses(...)");
                    v5 = (PgGPlumBaseOperatorAmHolder)it.invoke(v6);
                }
                var16_13.setV((BasicModIdentifiedElement)v5);
                v2 = this_$iv$iv.getV();
            }
            var5_5 = $procs;
            v7 = f.id;
            v8 = f.num;
            v9 = DataTypeFactory.of((String)f.left_type);
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"of(...)");
            v10 = DasUnresolvedTypeReference.Companion.of(v9);
            v11 = DataTypeFactory.of((String)f.right_type);
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"of(...)");
            var5_5.add(new PgAmProc(v7, v8, v10, DasUnresolvedTypeReference.Companion.of(v11), f.proc_id, f.proc_sig));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveAccessMethodProcedures$lambda$0$0(PgGPlumBaseSchemaRetriever this$0, boolean $detectDropped, PgGPlumBaseIntrospector this$1, boolean $loadNew, PgGPlumBaseSchema schema) {
            block6: {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                List<PgGPlumBaseOperatorAmHolder> relevantOwners = this$0.getRelevantAmOwners();
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentAmProcs()));
                    Iterable $this$forEach$iv = relevantOwners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        PgGPlumBaseOperatorAmHolder ah = (PgGPlumBaseOperatorAmHolder)element$iv;
                        boolean bl = false;
                        List<PgAmProc> list = ah.getAmProcs();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getAmProcs(...)");
                        Iterable iterable = list;
                        PgGPlumBaseOperatorAmHolder pgGPlumBaseOperatorAmHolder = ah;
                        boolean $i$f$filter = false;
                        void var16_21 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            PgAmProc it = (PgAmProc)element$iv$iv;
                            boolean bl2 = false;
                            if (!ids.contains(it.getId())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        pgGPlumBaseOperatorAmHolder.setAmProcs((List)destination$iv$iv);
                    }
                } else {
                    Iterable $this$forEach$iv = relevantOwners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgGPlumBaseOperatorAmHolder it = (PgGPlumBaseOperatorAmHolder)element$iv;
                        boolean bl = false;
                        it.setAmProcs(CollectionsKt.emptyList());
                    }
                }
                if (!$loadNew) break block6;
                IdCache oh = new IdCache();
                ArrayList<PgAmProc> procs = new ArrayList<PgAmProc>();
                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveAmProcs(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveAccessMethodProcedures$lambda$0$0$2(oh, procs, this$0, schema, arg_0), (int)2, null);
                PgGPlumBaseOperatorAmHolder pgGPlumBaseOperatorAmHolder = (PgGPlumBaseOperatorAmHolder)oh.getV();
                if (pgGPlumBaseOperatorAmHolder != null) {
                    this$0.appendProcs(pgGPlumBaseOperatorAmHolder, procs);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveOperatorFamilies$lambda$0$0$0$1(PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneOperatorFamily f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            BasicModNamedElement basicModNamedElement = $schema.getOperatorFamilies().renew(f.id, f.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseOperatorFamily opf = (PgGPlumBaseOperatorFamily)basicModNamedElement;
            opf.setStateNumber(f.state_number);
            opf.setAccessMethodRef((BasicReference)BasicIdReference.create((long)f.access_method_id));
            opf.setOwnerRef((BasicReference)BasicNameReference.create((String)f.getOwnerName()));
            opf.setDetailsLevel(LevelFun.max((Level)opf.getDetailsLevel(), (Level)Level.L2));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveOperatorFamilies$lambda$0(boolean $removeUnaffected, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getOperatorFamilies();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperatorFamilies());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it2 = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgGPlumBaseOperatorFamily pgGPlumBaseOperatorFamily = (PgGPlumBaseOperatorFamily)schema.getOperatorFamilies().getByObjectId(it2);
                            if (pgGPlumBaseOperatorFamily != null) {
                                ((BasicModMixinElement)pgGPlumBaseOperatorFamily).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperatorFamilies(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorFamilies$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperatorFamilies());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it3 = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgGPlumBaseOperatorFamily pgGPlumBaseOperatorFamily = (PgGPlumBaseOperatorFamily)schema.getOperatorFamilies().getByObjectId(it3);
                            if (pgGPlumBaseOperatorFamily != null) {
                                ((BasicModMixinElement)pgGPlumBaseOperatorFamily).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperatorFamilies(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveOperatorFamilies$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$0$2$0$1(PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneIndex ind) {
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = this$0.getTableOrView((Object)$schema, ind.table_kind, ind.table_id);
            if (pgGPlumBaseLikeStoredTable == null) {
                return Unit.INSTANCE;
            }
            PgGPlumBaseLikeStoredTable table = pgGPlumBaseLikeStoredTable;
            Object object = this$0.indexFamilyOf(table);
            if (object == null || (object = (PgGPlumBaseIndex)object.renew(ind.index_id, ind.index_name)) == null) {
                return Unit.INSTANCE;
            }
            Object index = object;
            this$0.processIndex((PgGPlumBaseIndex)index, ind);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveIndices$lambda$0(PgGPlumBaseSchemaRetriever this$0, boolean $removeUnaffected, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            void removeUnaffected$iv;
            void fragments$iv;
            String[] $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv22 = this$0.tableFamilies((Object)schema);
            boolean $i$f$mapNotNull22 = false;
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                ModNamingFamily it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ModelFun.tryCast((ModNamingFamily)((ModNamingFamily)it), PgBaseLikeStoredTable.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            boolean $this$mapNotNull$iv22 = $removeUnaffected;
            Iterable $i$f$mapNotNull22 = tables;
            $this$mapNotNullTo$iv$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamilyFragmentsAndCleanupInner = false;
            List relevantInnerFamilies$iv = new ArrayList();
            if (fragments$iv == null) {
                for (ModNamingFamily family$iv : majorFamilies$iv) {
                    for (BasicModNamedElement element$iv : family$iv) {
                        Intrinsics.checkNotNull((Object)element$iv);
                        PgBaseLikeStoredTable t = (PgBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOfNotNull(this$0.indexFamilyOf(t));
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            } else {
                for (Iterator<Object> fragment$iv : fragments$iv) {
                    for (ModNamingFamily family$iv : majorFamilies$iv) {
                        BasicModNamedElement element$iv;
                        if ((BasicModNamedElement)family$iv.get(fragment$iv) == null) continue;
                        PgBaseLikeStoredTable t = (PgBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOfNotNull(this$0.indexFamilyOf(t));
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            }
            if (removeUnaffected$iv != false) {
                for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                    innerFamily$iv.markChildrenAsSyncPending();
                }
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl4 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentIndices()));
                    Iterable $this$forEach$iv = tables;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModNamingFamily tf = (ModNamingFamily)element$iv;
                        boolean bl5 = false;
                        Iterable $this$forEach$iv2 = (Iterable)tf;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgBaseLikeStoredTable t = (PgBaseLikeStoredTable)element$iv2;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)t);
                            ModNamingIdentifyingFamily<PgGPlumBaseIndex> modNamingIdentifyingFamily = this$0.indexFamilyOf(t);
                            if (modNamingIdentifyingFamily == null) continue;
                            Iterable $this$forEach$iv3 = (Iterable)modNamingIdentifyingFamily;
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv3 : $this$forEach$iv3) {
                                PgGPlumBaseIndex it = (PgGPlumBaseIndex)element$iv3;
                                boolean bl7 = false;
                                if (!ids.contains(it.getObjectId())) continue;
                                it.resetSyncPending();
                            }
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveIndices(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveIndices$lambda$0$2$0$1(this$0, schema, arg_0), (int)2, null);
                    this$0.retrieveIndexColumns();
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl8 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                if (removeUnaffected$iv != false) {
                    innerFamily$iv.removeSyncPendingChildren();
                }
                innerFamily$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveIndexColumns$lambda$0$0(IdCache $idxCache, ArrayList $columns, PgGPlumBaseSchema $schema, PgGPlumBaseSchemaRetriever this$0, HashSet $affectedIndexFamilies, PgGPlumBaseIntroQueries.OneIndexColumn ind) {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
                    var6_6 = $idxCache;
                    id$iv = ind.index_id;
                    $i$f$getOrCache = false;
                    if (this_$iv.getV() == null) break block5;
                    v0 = this_$iv.getV();
                    Intrinsics.checkNotNull((Object)v0);
                    if (((BasicIdentifiedElement)v0).getObjectId() != id$iv) break block5;
                    v1 = this_$iv.getV();
                    break block6;
                }
                var10_9 = id$iv;
                var12_10 = this_$iv;
                var25_11 = this_$iv;
                $i$a$-getOrCache-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveIndexColumns$1$1$1 = false;
                v2 = (PgGPlumBaseIndex)$idxCache.getV();
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveIndexColumns$1$1$1$1 = false;
                    this$0.applyIndexColumns(it, $columns);
                }
                $columns.clear();
                var16_15 /* !! */  = (BasicSchema)$schema;
                objectId$iv = id;
                $i$f$findById = false;
                v3 = $this$findById$iv.getDatabase();
                if (v3 == null) ** GOTO lbl-1000
                var20_18 = v3;
                objectId$iv$iv = objectId$iv;
                $i$f$findAllById = false;
                v4 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements((long)objectId$iv$iv)).filter(PgGPlumBaseIndex.class);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"filter(...)");
                v3 = v4;
                if (v4 != null && (v3 = v3.filter(new Condition(var24_21 = (Function1)new Function1<PgGPlumBaseIndex, Boolean>((BasicSchema)$this$findById$iv){
                    final /* synthetic */ BasicSchema $this_findById;
                    {
                        this.$this_findById = $receiver;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Boolean invoke(BasicIdentifiedElement it) {
                        return Intrinsics.areEqual((Object)((BasicMixinElement)it).getSchema(), (Object)this.$this_findById);
                    }
                }){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })) != null) {
                    v5 = (BasicIdentifiedElement)v3.first();
                } else lbl-1000:
                // 2 sources

                {
                    v5 = null;
                }
                v6 = (PgGPlumBaseIndex)v5;
                if (v6 != null) {
                    var16_15 /* !! */  = v6;
                    it = var16_15 /* !! */ ;
                    $i$a$-also-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveIndexColumns$1$1$1$2 = false;
                    v7 = it.getParentFamily();
                    Intrinsics.checkNotNull(v7, (String)"null cannot be cast to non-null type com.intellij.database.model.families.ModFamily<out com.intellij.database.model.basic.BasicModElement>");
                    $affectedIndexFamilies.add((ModFamily)v7);
                    v8 /* !! */  = var16_15 /* !! */ ;
                } else {
                    v8 /* !! */  = null;
                }
                var25_11.setV((BasicModIdentifiedElement)v8 /* !! */ );
                v1 = this_$iv.getV();
            }
            $columns.add(ind);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndexColumns$lambda$0(PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            HashSet affectedIndexFamilies = new HashSet();
            IdCache idxCache = new IdCache();
            ArrayList columns = new ArrayList();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveIndexColumns(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveIndexColumns$lambda$0$0(idxCache, columns, schema, this$0, affectedIndexFamilies, arg_0), (int)2, null);
            PgGPlumBaseIndex pgGPlumBaseIndex = (PgGPlumBaseIndex)idxCache.getV();
            if (pgGPlumBaseIndex != null) {
                PgGPlumBaseIndex it = pgGPlumBaseIndex;
                boolean bl = false;
                this$0.applyIndexColumns(it, columns);
            }
            Iterator iterator = affectedIndexFamilies.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ModFamily f = (ModFamily)e;
                f.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveEnumLabels$lambda$0$0(Map $els, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (Map.Entry entry : $els.entrySet()) {
                PgGPlumBaseDefType defType;
                String[] stringArray;
                long type_id = ((Number)entry.getKey()).longValue();
                String[] labels = (String[])entry.getValue();
                if (type_id == 0L || (stringArray = labels) == null || stringArray.length == 0 || (defType = (PgGPlumBaseDefType)schema.getDefTypes().getByObjectId(type_id)) == null) continue;
                defType.setLabels(this$0.fixLabelsOrder(labels));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDataTypeChecks$lambda$1$1$0$1(PgGPlumBaseSchema $schema, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntroQueries.OneDataTypeCheck dc) {
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            PgGPlumBaseDefType pgGPlumBaseDefType = (PgGPlumBaseDefType)$schema.getDefTypes().getByObjectId(dc.type_id);
            if (pgGPlumBaseDefType == null) {
                return Unit.INSTANCE;
            }
            PgGPlumBaseDefType defType = pgGPlumBaseDefType;
            BasicModNamedElement basicModNamedElement = defType.getChecks().renew(dc.constraint_id, dc.constraint_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseDefTypeCheck check = (PgGPlumBaseDefTypeCheck)basicModNamedElement;
            check.setStateNumber(dc.constraint_state_number);
            String string = dc.predicate;
            check.setPredicate(string != null ? this$0.cleanupPredicate(string) : null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveDataTypeChecks$lambda$1(PgGPlumBaseIntrospector this$0, PgGPlumBaseSchemaRetriever this$1, PgGPlumBaseSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends PgGPlumBaseDefType> modNamingIdentifyingFamily = schema.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getDefTypes(...)");
            Iterable $this$map$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PgGPlumBaseDefType pgGPlumBaseDefType = (PgGPlumBaseDefType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getChecks());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                LongOpenHashSet ids = new LongOpenHashSet((long[])this$1.performQuery(this$0.getQueries().getRetrieveExistentDataTypeChecks()));
                ModNamingIdentifyingFamily<? extends PgGPlumBaseDefType> modNamingIdentifyingFamily2 = schema.getDefTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getDefTypes(...)");
                Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PgGPlumBaseDefType t = (PgGPlumBaseDefType)element$iv;
                    boolean bl3 = false;
                    ModNamingIdentifyingFamily<? extends PgGPlumBaseDefTypeCheck> modNamingIdentifyingFamily3 = t.getChecks();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getChecks(...)");
                    Iterable $this$forEach$iv2 = (Iterable)modNamingIdentifyingFamily3;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        PgGPlumBaseDefTypeCheck it = (PgGPlumBaseDefTypeCheck)element$iv2;
                        boolean bl4 = false;
                        if (!ids.contains(it.getObjectId())) continue;
                        it.resetSyncPending();
                    }
                }
                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getRetrieveDataTypeChecks(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveDataTypeChecks$lambda$1$1$0$1(schema, this$1, arg_0), (int)2, null);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSequences$lambda$0$0$0$1(PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneSequence sq) {
            Intrinsics.checkNotNullParameter((Object)sq, (String)"sq");
            BasicModNamedElement basicModNamedElement = $schema.getSequences().renew(sq.sequence_id, sq.sequence_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseSequence sequence = (PgGPlumBaseSequence)basicModNamedElement;
            sequence.setStateNumber(sq.sequence_state_number);
            sequence.setOwnerRef((BasicReference)BasicNameReference.create((String)sq.getOwnerName()));
            PgGPlumBaseIntrospectorKt.access$assignSequenceParams(sequence, sq);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSequences$lambda$0(boolean $removeUnaffected, PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getSequences();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentSequences());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it2 = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgGPlumBaseSequence pgGPlumBaseSequence = (PgGPlumBaseSequence)schema.getSequences().getByObjectId(it2);
                            if (pgGPlumBaseSequence != null) {
                                ((BasicModMixinElement)pgGPlumBaseSequence).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$0.getSequencesQuery(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveSequences$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentSequences());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it3 = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgGPlumBaseSequence pgGPlumBaseSequence = (PgGPlumBaseSequence)schema.getSequences().getByObjectId(it3);
                            if (pgGPlumBaseSequence != null) {
                                ((BasicModMixinElement)pgGPlumBaseSequence).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$0.getSequencesQuery(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveSequences$lambda$0$0$0$1(schema, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveRelations$lambda$0$0(IdCache $tableCache, Long2LongOpenHashMap $colPosToSeqId, PgGPlumBaseSchema $sc, PgGPlumBaseSchemaRetriever this$0, LongOpenHashSet $processedTables, PgGPlumBaseIntroQueries.OneRelation r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            var6_6 = $tableCache;
            id$iv = r.owner_id;
            $i$f$get = false;
            var10_9 = this_$iv;
            id$iv$iv = id$iv;
            $i$f$getOrCache = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (((BasicIdentifiedElement)v0).getObjectId() == id$iv$iv) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var14_12 = id$iv$iv;
                var16_13 = this_$iv$iv;
                var17_14 = this_$iv$iv;
                $i$a$-getOrCache-IdCache$get$1$iv = false;
                var19_16 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                    final /* synthetic */ long $id;
                    {
                        this.$id = $id;
                    }

                    public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                    }
                };
                $this$retrieveRelations_u24lambda_u240_u240_u240 = $this$get_u24lambda_u240$iv;
                $i$a$-get-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveRelations$1$1$1 = false;
                v2 = (PgGPlumBaseLocalTable)$this$retrieveRelations_u24lambda_u240_u240_u240.getV();
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever$retrieveRelations$1$1$1$1 = false;
                    PgGPlumBaseSchemaRetriever.access$applyTableRelations(this$0, it, $colPosToSeqId, $processedTables);
                }
                $colPosToSeqId.clear();
                v3 = $sc.getTables();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"getTables(...)");
                var17_14.setV((BasicModIdentifiedElement)((PgGPlumBaseLocalTable)it.invoke(v3)));
                v1 = this_$iv$iv.getV();
            }
            $colPosToSeqId.put(r.owner_subobject_id, r.dependent_id);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRelations$lambda$0(PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseIntrospector this$1, PgGPlumBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            LongOpenHashSet processedTables = new LongOpenHashSet();
            IdCache tableCache = new IdCache();
            Long2LongOpenHashMap colPosToSeqId = new Long2LongOpenHashMap();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveRelations(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveRelations$lambda$0$0(tableCache, colPosToSeqId, sc, this$0, processedTables, arg_0), (int)2, null);
            PgGPlumBaseLocalTable pgGPlumBaseLocalTable = (PgGPlumBaseLocalTable)tableCache.getV();
            if (pgGPlumBaseLocalTable != null) {
                PgGPlumBaseLocalTable it = pgGPlumBaseLocalTable;
                boolean bl = false;
                this$0.applyTableRelations(it, colPosToSeqId, processedTables);
            }
            for (PgGPlumBaseLocalTable table : sc.getTables()) {
                if (processedTables.contains(table.getObjectId())) continue;
                for (PgGPlumBaseLocalTableColumn column : table.getColumns()) {
                    column.setSequenceRef(null);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTriggers$lambda$0$2$0$1(PgGPlumBaseSchemaRetriever this$0, PgGPlumBaseSchema $schema, PgGPlumBaseIntroQueries.OneTrigger t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = this$0.getTableOrView((Object)$schema, '\u0000', t.table_id);
            if (pgGPlumBaseLikeStoredTable == null) {
                return Unit.INSTANCE;
            }
            PgGPlumBaseLikeStoredTable table = pgGPlumBaseLikeStoredTable;
            BasicModNamedElement basicModNamedElement = table.getTriggers().renew(t.trigger_id, t.trigger_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgGPlumBaseTrigger trigger = (PgGPlumBaseTrigger)basicModNamedElement;
            this$0.processTrigger(trigger, t);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveTriggers$lambda$0(PgGPlumBaseSchemaRetriever this$0, boolean $removeUnaffected, PgGPlumBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgGPlumBaseSchema schema) {
            void removeUnaffected$iv;
            void fragments$iv;
            String[] $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv22 = this$0.tableFamilies((Object)schema);
            boolean $i$f$mapNotNull22 = false;
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                ModNamingFamily it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ModelFun.tryCast((ModNamingFamily)((ModNamingFamily)it), PgGPlumBaseLikeStoredTable.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            boolean $this$mapNotNull$iv22 = $removeUnaffected;
            Iterable $i$f$mapNotNull22 = tables;
            $this$mapNotNullTo$iv$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamilyFragmentsAndCleanupInner = false;
            List relevantInnerFamilies$iv = new ArrayList();
            if (fragments$iv == null) {
                for (ModNamingFamily family$iv : majorFamilies$iv) {
                    for (BasicModNamedElement element$iv : family$iv) {
                        Intrinsics.checkNotNull((Object)element$iv);
                        PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(t.getTriggers());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            } else {
                for (Iterator<Object> fragment$iv : fragments$iv) {
                    for (ModNamingFamily family$iv : majorFamilies$iv) {
                        BasicModNamedElement element$iv;
                        if ((BasicModNamedElement)family$iv.get(fragment$iv) == null) continue;
                        PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(t.getTriggers());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            }
            if (removeUnaffected$iv != false) {
                for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                    innerFamily$iv.markChildrenAsSyncPending();
                }
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl4 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentTriggers()));
                    Iterable $this$forEach$iv = tables;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModNamingFamily tf = (ModNamingFamily)element$iv;
                        boolean bl5 = false;
                        Iterable $this$forEach$iv2 = (Iterable)tf;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgGPlumBaseLikeStoredTable t = (PgGPlumBaseLikeStoredTable)element$iv2;
                            boolean bl6 = false;
                            ModNamingIdentifyingFamily<? extends PgGPlumBaseTrigger> modNamingIdentifyingFamily = t.getTriggers();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTriggers(...)");
                            Iterable $this$forEach$iv3 = (Iterable)modNamingIdentifyingFamily;
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv3 : $this$forEach$iv3) {
                                PgGPlumBaseTrigger it = (PgGPlumBaseTrigger)element$iv3;
                                boolean bl7 = false;
                                if (!ids.contains(it.getObjectId())) continue;
                                it.resetSyncPending();
                            }
                        }
                    }
                }
                if ($loadNew && this$0.shouldIntrospectTableRelatedData()) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveTriggers(), (int)0, arg_0 -> PgGPlumBaseSchemaRetriever.retrieveTriggers$lambda$0$2$0$1(this$0, schema, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl8 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                if (removeUnaffected$iv != false) {
                    innerFamily$iv.removeSyncPendingChildren();
                }
                innerFamily$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final String parseTriggerCallArgs$lambda$2$0(String arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return ScriptGeneratorHelperKt.getSqlString((String)arg);
        }

        public static final /* synthetic */ void access$inSchema(PgGPlumBaseSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$appendOps(PgGPlumBaseSchemaRetriever $this, PgGPlumBaseOperatorAmHolder $receiver, ArrayList ops) {
            $this.appendOps($receiver, ops);
        }

        public static final /* synthetic */ void access$appendProcs(PgGPlumBaseSchemaRetriever $this, PgGPlumBaseOperatorAmHolder $receiver, ArrayList ops) {
            $this.appendProcs($receiver, ops);
        }

        public static final /* synthetic */ void access$applyTableRelations(PgGPlumBaseSchemaRetriever $this, PgGPlumBaseLocalTable table, Long2LongOpenHashMap relations, LongOpenHashSet processedTables) {
            $this.applyTableRelations(table, relations, processedTables);
        }
    }
}

