/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.EditorCodeVisionContextKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.ClickInfo;
import com.jetbrains.rd.ide.model.ClickPosition;
import com.jetbrains.rd.ide.model.CodeVisionExtraActionClickedArguments;
import com.jetbrains.rd.ide.model.CodeVisionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CodeVisionProviderClickedArguments;
import com.jetbrains.rd.ide.model.CodeVisionProviderModel;
import com.jetbrains.rd.ide.model.CodeVisionSettingsModel;
import com.jetbrains.rd.ide.model.CodeVisionSettingsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.LensPoint;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rdclient.codeVision.FrontendCodeVisionProvider;
import com.jetbrains.rdclient.codeVision.FrontendCodeVisionProviderKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ5\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001fJ*\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdclient/codeVision/FrontendCodeVisionHandler;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "settingsModel", "Lcom/jetbrains/rd/ide/model/CodeVisionSettingsModel;", "getRemoteProviders", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionProvider;", "getRemoteProvider", "Lcom/jetbrains/rd/ide/model/CodeVisionProviderModel;", "providerId", "", "handleLensClick", "", "provider", "Lcom/jetbrains/rdclient/codeVision/FrontendCodeVisionProvider;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "entry", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "handleLensClick$intellij_rd_client", "handleLensExtraAction", "range", "actionId", "handleLensExtraAction$intellij_rd_client", "sendClickInfoToServer", "intellij.rd.client"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFrontendCodeVisionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCodeVisionHandler.kt\ncom/jetbrains/rdclient/codeVision/FrontendCodeVisionHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n129#2:121\n158#2,3:122\n296#3,2:125\n13#4:127\n*S KotlinDebug\n*F\n+ 1 FrontendCodeVisionHandler.kt\ncom/jetbrains/rdclient/codeVision/FrontendCodeVisionHandler\n*L\n39#1:121\n39#1:122,3\n43#1:125,2\n95#1:127\n*E\n"})
public final class FrontendCodeVisionHandler
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final CodeVisionSettingsModel settingsModel;

    public FrontendCodeVisionHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.settingsModel = CodeVisionSettingsModel_GeneratedKt.getCodeVisionSettingsModel((IProtocol)IdeBackend.Companion.getInstance(this.project).getProtocol());
        BuildersKt.launch$default((CoroutineScope)this.getServiceLifetime().getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendCodeVisionHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.settingsModel.getProviders().advise(this.this$0.getServiceLifetime(), arg_0 -> 1.invokeSuspend$lambda$0(this.this$0, arg_0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(FrontendCodeVisionHandler this$0, IViewableMap.Event it) {
                ComponentManager $this$service$iv = (ComponentManager)this$0.getProject();
                boolean $i$f$service = false;
                Class<CodeVisionHost> serviceClass$iv = CodeVisionHost.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((CodeVisionHost)object).recollectAndRearrangeProviders();
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeVisionProvider<?>> getRemoteProviders() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = (Map)this.settingsModel.getProviders();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FrontendCodeVisionProviderKt.toIdeaModel((Map.Entry<String, CodeVisionProviderModel>)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final CodeVisionProviderModel getRemoteProvider(@NotNull String providerId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Iterable $this$firstOrNull$iv = this.settingsModel.getProviders().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)providerId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (CodeVisionProviderModel)entry.getValue() : null;
    }

    public final void handleLensClick$intellij_rd_client(@NotNull FrontendCodeVisionProvider provider2, @NotNull Editor editor, @NotNull TextRange textRange, @NotNull CodeVisionEntry entry) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        CodeVisionProviderModel codeVisionProviderModel = this.getRemoteProvider(provider2.getId());
        if (codeVisionProviderModel == null) {
            return;
        }
        CodeVisionProviderModel providerModel = codeVisionProviderModel;
        if (provider2.getUseClickInfoEvents()) {
            this.sendClickInfoToServer(editor, textRange, entry, null);
        } else {
            ClickPosition clickPosition;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, this.project);
            Intrinsics.checkNotNull((Object)rdDocumentId);
            RdDocumentId documentId = rdDocumentId;
            MouseEvent clickPosition2 = (MouseEvent)entry.getUserData(EditorCodeVisionContextKt.getCodeVisionEntryMouseEventKey());
            if (clickPosition2 != null) {
                Point point = clickPosition2.getPoint();
                clickPosition = new ClickPosition(point.x, point.y, DocumentExKt.getTextControlId(editor));
            } else {
                clickPosition = null;
            }
            ClickPosition position = clickPosition;
            providerModel.getClicked().fire((Object)new CodeVisionProviderClickedArguments(documentId, RangeUtilKt.toRdTextRange(textRange), position));
        }
    }

    public final void handleLensExtraAction$intellij_rd_client(@NotNull FrontendCodeVisionProvider provider2, @NotNull Editor editor, @NotNull TextRange range, @NotNull CodeVisionEntry entry, @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        CodeVisionProviderModel codeVisionProviderModel = this.getRemoteProvider(provider2.getId());
        if (codeVisionProviderModel == null) {
            return;
        }
        CodeVisionProviderModel providerModel = codeVisionProviderModel;
        if (provider2.getUseClickInfoEvents()) {
            this.sendClickInfoToServer(editor, range, entry, actionId);
        } else {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, project);
            Intrinsics.checkNotNull((Object)rdDocumentId);
            RdDocumentId documentId = rdDocumentId;
            CodeVisionExtraActionClickedArguments clickedArguments = new CodeVisionExtraActionClickedArguments(documentId, RangeUtilKt.toRdTextRange(range), actionId);
            providerModel.getExtraActionClicked().fire((Object)clickedArguments);
        }
    }

    private final void sendClickInfoToServer(Editor editor, TextRange range, CodeVisionEntry entry, String actionId) {
        Point point;
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        if (textControlModel == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendCodeVisionHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Text control model for " + editor + " is null");
            return;
        }
        MouseEvent clickPosition = (MouseEvent)entry.getUserData(EditorCodeVisionContextKt.getCodeVisionEntryMouseEventKey());
        if (clickPosition != null) {
            point = new Point(clickPosition.getPoint().x, clickPosition.getPoint().y);
        } else {
            Point point2 = editor.offsetToXY(range.getStartOffset());
            point = point2;
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        }
        Point position = point;
        ClickInfo clickInfo = new ClickInfo(entry.getProviderId(), RangeUtilKt.toRdTextRange(range), new LensPoint(position.x, position.y), actionId);
        CodeVisionModel_GeneratedKt.getCodeVisionModel((TextControlModel)textControlModel).getClicked().fire((Object)clickInfo);
    }
}

