/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "handlers", "", "<init>", "(Ljava/util/List;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "getHandler", "intellij.rd.client"})
public final class CompoundHighlighterModelsHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final List<IProtocolHighlighterModelHandler> handlers;

    public CompoundHighlighterModelsHandler(@NotNull List<? extends IProtocolHighlighterModelHandler> handlers) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        this.handlers = handlers;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.getHandler(model2);
        return true;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.getHandler(model2).initialize(model2, highlighter);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return this.getHandler(model2).compare(model2, highlighter);
    }

    @Override
    @Nullable
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return this.getHandler(model2).move(startOffset, endOffset, model2);
    }

    @NotNull
    public final IProtocolHighlighterModelHandler getHandler(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Object matchingHandler = null;
        for (IProtocolHighlighterModelHandler handler : this.handlers) {
            if (!handler.accept(model2)) continue;
            if (matchingHandler != null) {
                String message = "Both '" + Reflection.getOrCreateKotlinClass(matchingHandler.getClass()).getQualifiedName() + "' and '" + Reflection.getOrCreateKotlinClass(handler.getClass()).getQualifiedName() + "' are registered for " + HighlightersUtilKt.prettyPrint(model2) + ", class: " + Reflection.getOrCreateKotlinClass(model2.getClass()).getQualifiedName();
                throw new IllegalArgumentException(message);
            }
            matchingHandler = handler;
        }
        if (matchingHandler == null) {
            throw new IllegalArgumentException("Haven't found matching handler for " + HighlightersUtilKt.prettyPrint(model2) + ", class: " + Reflection.getOrCreateKotlinClass(model2.getClass()).getQualifiedName());
        }
        return matchingHandler;
    }
}

