/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.rd.ide.model.ValueModelBase;
import com.jetbrains.rd.ide.model.ValuePresentationPart;
import com.jetbrains.rd.ide.model.ValuePropertiesModelBase;
import com.jetbrains.rdclient.debugger.ValueModelBaseUtilsKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "objectPropertiesProxy", "Lcom/jetbrains/rd/ide/model/ValuePropertiesModelBase;", "hideType", "", "truncateToMaxLength", "", "value", "currentLength", "", "intellij.rd.client"})
public final class ValueModelBaseUtilsKt {
    public static final void computePresentation(@NotNull XValueNode node, @Nullable Icon icon, @NotNull ValuePropertiesModelBase objectPropertiesProxy, boolean hideType) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)objectPropertiesProxy, (String)"objectPropertiesProxy");
        node.setPresentation(icon, new XValuePresentation(objectPropertiesProxy, hideType){
            final /* synthetic */ ValuePropertiesModelBase $objectPropertiesProxy;
            final /* synthetic */ boolean $hideType;
            {
                this.$objectPropertiesProxy = $objectPropertiesProxy;
                this.$hideType = $hideType;
            }

            public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                int presentationLength = 0;
                for (ValuePresentationPart valuePart : this.$objectPropertiesProxy.getValue()) {
                    if (presentationLength >= 1000) break;
                    String value = ValueModelBaseUtilsKt.access$truncateToMaxLength(valuePart.getValue(), presentationLength);
                    switch (computePresentation.WhenMappings.$EnumSwitchMapping$0[valuePart.getKind().ordinal()]) {
                        case 1: {
                            renderer.renderValue(value);
                            break;
                        }
                        case 2: {
                            renderer.renderComment(value);
                            break;
                        }
                        case 3: {
                            renderer.renderStringValue(value, "\"", 1000);
                            break;
                        }
                        case 4: {
                            renderer.renderError(value);
                            break;
                        }
                        case 5: {
                            renderer.renderNumericValue(value);
                            break;
                        }
                        case 6: {
                            renderer.renderKeywordValue(value);
                            break;
                        }
                        case 7: {
                            renderer.renderSpecialSymbol(value);
                            break;
                        }
                        default: {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(ValueModelBase.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.error("Unknown value presentation type: " + valuePart.getKind());
                            renderer.renderValue(value);
                        }
                    }
                    presentationLength += value.length();
                }
            }

            public String getType() {
                return this.$hideType ? null : this.$objectPropertiesProxy.getType();
            }
        }, objectPropertiesProxy.getHasChildren());
    }

    public static /* synthetic */ void computePresentation$default(XValueNode xValueNode, Icon icon, ValuePropertiesModelBase valuePropertiesModelBase, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        ValueModelBaseUtilsKt.computePresentation(xValueNode, icon, valuePropertiesModelBase, bl);
    }

    private static final String truncateToMaxLength(String value, int currentLength) {
        if (currentLength >= 1000) {
            return "";
        }
        String string = value.substring(0, Math.min(value.length(), 1000 - currentLength));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static final /* synthetic */ String access$truncateToMaxLength(String value, int currentLength) {
        return ValueModelBaseUtilsKt.truncateToMaxLength(value, currentLength);
    }
}

