/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.SmartList;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import com.jetbrains.jsonSchema.impl.tree.AllOfOperation;
import com.jetbrains.jsonSchema.impl.tree.AnyOfOperation;
import com.jetbrains.jsonSchema.impl.tree.IfThenElseBranchOperation;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import com.jetbrains.jsonSchema.impl.tree.OneOfOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Operation {
    @NotNull
    public final JsonSchemaNodeExpansionRequest myExpansionRequest;
    @NotNull
    public final List<JsonSchemaObject> myAnyOfGroup;
    @NotNull
    public final List<List<JsonSchemaObject>> myOneOfGroup;
    @NotNull
    public final List<Operation> myChildOperations;
    @NotNull
    public final JsonSchemaObject mySourceNode;
    public SchemaResolveState myState;

    protected Operation(@NotNull JsonSchemaObject sourceNode, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        if (sourceNode == null) {
            Operation.$$$reportNull$$$0(0);
        }
        this.myAnyOfGroup = new SmartList();
        this.myOneOfGroup = new SmartList();
        this.myState = SchemaResolveState.normal;
        this.mySourceNode = sourceNode;
        this.myChildOperations = new ArrayList<Operation>();
        this.myExpansionRequest = expansionRequest == null ? new JsonSchemaNodeExpansionRequest(null, true) : expansionRequest;
    }

    protected abstract void map(@NotNull Set<JsonSchemaObject> var1);

    protected abstract void reduce();

    public void doMap(@NotNull Set<JsonSchemaObject> visited) {
        if (visited == null) {
            Operation.$$$reportNull$$$0(1);
        }
        this.map(visited);
        for (Operation operation : this.myChildOperations) {
            ProgressManager.checkCanceled();
            operation.doMap(visited);
        }
    }

    public void doReduce() {
        if (!SchemaResolveState.normal.equals((Object)this.myState)) {
            this.myChildOperations.clear();
            this.myAnyOfGroup.clear();
            this.myOneOfGroup.clear();
            return;
        }
        for (Operation myChildOperation : this.myChildOperations) {
            ProgressManager.checkCanceled();
            myChildOperation.doReduce();
        }
        this.reduce();
        this.myChildOperations.clear();
    }

    @Nullable
    protected Operation createExpandOperation(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        Operation forConflict;
        if (schema == null) {
            Operation.$$$reportNull$$$0(2);
        }
        if (service == null) {
            Operation.$$$reportNull$$$0(3);
        }
        if ((forConflict = Operation.getOperationForConflict(schema, service, expansionRequest)) != null) {
            return forConflict;
        }
        if (schema.hasChildNode("anyOf")) {
            return new AnyOfOperation(schema, service, expansionRequest);
        }
        if (schema.hasChildNode("oneOf")) {
            return new OneOfOperation(schema, service, expansionRequest);
        }
        if (schema.hasChildNode("allOf")) {
            return new AllOfOperation(schema, service, expansionRequest);
        }
        if (schema.hasChildNode("if")) {
            return new IfThenElseBranchOperation(schema, expansionRequest, service);
        }
        return null;
    }

    @Nullable
    private static Operation getOperationForConflict(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        if (schema == null) {
            Operation.$$$reportNull$$$0(4);
        }
        if (service == null) {
            Operation.$$$reportNull$$$0(5);
        }
        boolean anyOf = schema.hasChildNode("anyOf");
        boolean oneOf = schema.hasChildNode("oneOf");
        boolean allOf = schema.hasChildNode("allOf");
        if (anyOf && (oneOf || allOf)) {
            return new AnyOfOperation(schema, service, expansionRequest){
                {
                    this.myState = SchemaResolveState.conflict;
                }
            };
        }
        if (oneOf && allOf) {
            return new OneOfOperation(schema, service, expansionRequest){
                {
                    this.myState = SchemaResolveState.conflict;
                }
            };
        }
        return null;
    }

    protected static List<JsonSchemaObject> mergeOneOf(Operation op) {
        return op.myOneOfGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/tree/Operation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpandOperation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperationForConflict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

