/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.json;

import com.intellij.clouds.docker.gateway.utils.UtilsKt;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonElementTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 \u001b2\u00020\u0001:\u0007\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH$J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "createPropertyWithObjectLookup", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "name", "", "addQuotes", "", "contextPath", "Ljava/nio/file/Path;", "currElement", "Lcom/intellij/psi/PsiElement;", "isInDevcontainerJson", "EmptyObjectInsertHandler", "EmptyArrayInsertHandler", "EmptyStringInsertHandler", "EmptyValueInsertHandler", "OptionInsertHandler", "OptionStringValueInsertHandler", "Companion", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerJsonCompletionContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerJsonCompletionContributorBase.kt\ncom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,80:1\n34#2:81\n*S KotlinDebug\n*F\n+ 1 DevcontainerJsonCompletionContributorBase.kt\ncom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase\n*L\n27#1:81\n*E\n"})
public abstract class DevcontainerJsonCompletionContributorBase
extends CompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (this.isInDevcontainerJson(parameters)) {
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement currElement = psiElement;
            Path contextPath = parameters.getOriginalFile().getVirtualFile().toNioPath().getParent();
            boolean addQuotes = !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)currElement), (Object)JsonElementTypes.DOUBLE_QUOTED_STRING);
            Intrinsics.checkNotNull((Object)contextPath);
            this.fillCompletionVariants(parameters, contextPath, currElement, addQuotes, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final LookupElementBuilder createPropertyWithObjectLookup(@NotNull String name, boolean addQuotes) {
        LookupElementBuilder lookupElementBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LookupElementBuilder lookupElementBuilder2 = LookupElementBuilder.create((String)name).withIcon(AllIcons.Nodes.Property);
        boolean condition$iv = addQuotes;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$createPropertyWithObjectLookup_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            lookupElementBuilder = $this$createPropertyWithObjectLookup_u24lambda_u240.withInsertHandler((InsertHandler)EmptyObjectInsertHandler.INSTANCE);
        } else {
            lookupElementBuilder = lookupElementBuilder2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"applyIf(...)");
        return lookupElementBuilder;
    }

    protected abstract void fillCompletionVariants(@NotNull CompletionParameters var1, @NotNull Path var2, @NotNull PsiElement var3, boolean var4, @NotNull CompletionResultSet var5);

    private final boolean isInDevcontainerJson(CompletionParameters parameters) {
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        return file.isPhysical() && UtilsKt.isDevcontainerFile(file);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$Companion;", "", "<init>", "()V", "surroundWithQuotes", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "surroundWithQuotes$intellij_clouds_docker_gateway", "intellij.clouds.docker.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public final void surroundWithQuotes$intellij_clouds_docker_gateway(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Editor editor = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            int currPos = editor2.getCaretModel().getCurrentCaret().getOffset();
            int itemStart = currPos - item.getLookupString().length();
            editor2.getDocument().replaceString(itemStart, currPos, (CharSequence)("\"" + item.getLookupString() + "\""));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c4\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyArrayInsertHandler;", "Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyValueInsertHandler;", "<init>", "()V", "intellij.clouds.docker.gateway"})
    protected static final class EmptyArrayInsertHandler
    extends EmptyValueInsertHandler {
        @NotNull
        public static final EmptyArrayInsertHandler INSTANCE = new EmptyArrayInsertHandler();

        private EmptyArrayInsertHandler() {
            super('[', ']');
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c4\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyObjectInsertHandler;", "Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyValueInsertHandler;", "<init>", "()V", "intellij.clouds.docker.gateway"})
    protected static final class EmptyObjectInsertHandler
    extends EmptyValueInsertHandler {
        @NotNull
        public static final EmptyObjectInsertHandler INSTANCE = new EmptyObjectInsertHandler();

        private EmptyObjectInsertHandler() {
            super('{', '}');
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c4\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyStringInsertHandler;", "Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyValueInsertHandler;", "<init>", "()V", "intellij.clouds.docker.gateway"})
    protected static final class EmptyStringInsertHandler
    extends EmptyValueInsertHandler {
        @NotNull
        public static final EmptyStringInsertHandler INSTANCE = new EmptyStringInsertHandler();

        private EmptyStringInsertHandler() {
            super('\"', '\"');
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$EmptyValueInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "left", "", "right", "<init>", "(CC)V", "getLeft", "()C", "getRight", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.clouds.docker.gateway"})
    protected static class EmptyValueInsertHandler
    implements InsertHandler<LookupElement> {
        private final char left;
        private final char right;

        public EmptyValueInsertHandler(char left, char right) {
            this.left = left;
            this.right = right;
        }

        public final char getLeft() {
            return this.left;
        }

        public final char getRight() {
            return this.right;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Editor editor = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Companion.surroundWithQuotes$intellij_clouds_docker_gateway(context, item);
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)(" : " + this.left + this.right + ","));
            int currPos = editor2.getCaretModel().getCurrentCaret().getOffset();
            editor2.getCaretModel().moveToOffset(currPos - 2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c4\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$OptionInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.clouds.docker.gateway"})
    protected static final class OptionInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final OptionInsertHandler INSTANCE = new OptionInsertHandler();

        private OptionInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Companion.surroundWithQuotes$intellij_clouds_docker_gateway(context, item);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)": ");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c4\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonCompletionContributorBase$OptionStringValueInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.clouds.docker.gateway"})
    protected static final class OptionStringValueInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final OptionStringValueInsertHandler INSTANCE = new OptionStringValueInsertHandler();

        private OptionStringValueInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Companion.surroundWithQuotes$intellij_clouds_docker_gateway(context, item);
        }
    }
}

