/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.completion.spec.ShellCompletionSuggestion;
import com.intellij.terminal.frontend.view.completion.CompletionItemInsertionInfo;
import com.intellij.terminal.frontend.view.completion.PowerShellCompletionContributorKt;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionProcess;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import com.intellij.terminal.frontend.view.impl.TerminalInput;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.session.ShellName;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u001a \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0012H\u0002\"\u000e\u0010\u001c\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"insertTerminalCompletionItem", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "calculateInsertionInfo", "Lcom/intellij/terminal/frontend/view/completion/CompletionItemInsertionInfo;", "process", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionProcess;", "suggestion", "Lcom/intellij/terminal/completion/spec/ShellCompletionSuggestion;", "typedPrefixLength", "", "initialBeforeReplacementLength", "initialAfterReplacementLength", "optimizeInsertionInfo", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "baseInfo", "doOptimizeInsertionInfo", "needsEscaping", "", "shellName", "Lorg/jetbrains/plugins/terminal/session/ShellName;", "value", "", "getCursorLineContext", "CURSOR_MARKER", "POWERSHELL_CHARS_TO_ESCAPE", "UNIX_SHELLS_CHARS_TO_ESCAPE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalCompletionItemInsertion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCompletionItemInsertion.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCompletionItemInsertionKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,205:1\n1107#2,2:206\n57#3:208\n35#3,2:209\n*S KotlinDebug\n*F\n+ 1 TerminalCompletionItemInsertion.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCompletionItemInsertionKt\n*L\n179#1:206,2\n205#1:208\n205#1:209,2\n*E\n"})
public final class TerminalCompletionItemInsertionKt {
    @NotNull
    private static final String CURSOR_MARKER = "{cursor}";
    @NotNull
    private static final String POWERSHELL_CHARS_TO_ESCAPE = " \n\t\r`$'\"(){}[]<>|;&,@#";
    @NotNull
    private static final String UNIX_SHELLS_CHARS_TO_ESCAPE = " \n\t\r`$'\"(){}[]<>|;&*?\\";
    @NotNull
    private static final Logger LOG;

    public static final void insertTerminalCompletionItem(@NotNull LookupImpl lookup, @NotNull LookupElement item) {
        int charsToRemove;
        TerminalInput terminalInput;
        byte[] it2;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        TerminalInput terminalInput2 = (TerminalInput)lookup.getEditor().getUserData(TerminalInput.Companion.getKEY());
        if (terminalInput2 == null) {
            String string = "No TerminalInput found in the editor";
            throw new IllegalStateException(string.toString());
        }
        TerminalInput terminalInput3 = terminalInput2;
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TerminalCommandCompletionProcess terminalCommandCompletionProcess = TerminalCommandCompletionService.Companion.getInstance(project).getActiveProcess$intellij_terminal_frontend();
        if (terminalCommandCompletionProcess == null) {
            String string = "No active completion process";
            throw new IllegalStateException(string.toString());
        }
        TerminalCommandCompletionProcess process = terminalCommandCompletionProcess;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.terminal.completion.spec.ShellCompletionSuggestion");
        ShellCompletionSuggestion suggestion = (ShellCompletionSuggestion)object;
        int typedPrefixLength = lookup.itemPattern(item).length();
        CompletionItemInsertionInfo insertionInfo = TerminalCompletionItemInsertionKt.calculateInsertionInfo(process, suggestion, typedPrefixLength, process.getBeforePrefixReplacementLength(), process.getAfterPrefixReplacementLength());
        CompletionItemInsertionInfo optimizedInfo = TerminalCompletionItemInsertionKt.optimizeInsertionInfo(process.getContext().getOutputModel(), insertionInfo, typedPrefixLength);
        if (optimizedInfo.getAfterPrefixReplacementLength() > 0) {
            int n3 = optimizedInfo.getAfterPrefixReplacementLength();
            n2 = 0;
            while (n2 < n3) {
                int it2 = n2++;
                n = 0;
                terminalInput3.sendRight();
            }
            n3 = 0;
            n2 = optimizedInfo.getAfterPrefixReplacementLength();
            it2 = new byte[n2];
            terminalInput = terminalInput3;
            while (n3 < n2) {
                n = n3++;
                it2[n] = 127;
            }
            terminalInput.sendBytes(it2);
        }
        if ((charsToRemove = typedPrefixLength + optimizedInfo.getBeforePrefixReplacementLength()) > 0) {
            n2 = 0;
            it2 = new byte[charsToRemove];
            terminalInput = terminalInput3;
            while (n2 < charsToRemove) {
                n = n2++;
                it2[n] = 127;
            }
            terminalInput.sendBytes(it2);
        }
        String realInsertValue = StringsKt.replace$default((String)optimizedInfo.getInsertValue(), (String)CURSOR_MARKER, (String)"", (boolean)false, (int)4, null);
        terminalInput3.sendString(realInsertValue);
        int cursorOffset = StringsKt.indexOf$default((CharSequence)optimizedInfo.getInsertValue(), (String)CURSOR_MARKER, (int)0, (boolean)false, (int)6, null);
        if (cursorOffset != -1) {
            int delta = realInsertValue.length() - cursorOffset;
            int n4 = 0;
            while (n4 < delta) {
                int it3 = n4++;
                boolean bl = false;
                terminalInput3.sendLeft();
            }
        }
    }

    private static final CompletionItemInsertionInfo calculateInsertionInfo(TerminalCommandCompletionProcess process, ShellCompletionSuggestion suggestion, int typedPrefixLength, int initialBeforeReplacementLength, int initialAfterReplacementLength) {
        StringBuilder stringBuilder;
        String baseInsertValue;
        String string = suggestion.getInsertValue();
        if (string == null) {
            string = baseInsertValue = suggestion.getName();
        }
        if (!suggestion.getShouldEscape()) {
            return new CompletionItemInsertionInfo(baseInsertValue, initialBeforeReplacementLength, initialAfterReplacementLength);
        }
        if (PowerShellCompletionContributorKt.isSurroundedByQuotes(baseInsertValue)) {
            return new CompletionItemInsertionInfo(baseInsertValue, initialBeforeReplacementLength, initialAfterReplacementLength);
        }
        ShellName shellName = process.getContext().getShellName();
        if (!TerminalCompletionItemInsertionKt.needsEscaping(shellName, baseInsertValue)) {
            return new CompletionItemInsertionInfo(baseInsertValue, initialBeforeReplacementLength, initialAfterReplacementLength);
        }
        TerminalOutputModel outputModel = process.getContext().getOutputModel();
        TerminalOffset prefixStartOffset = outputModel.getCursorOffset().minus(typedPrefixLength);
        TerminalOffset tokenStartOffset = prefixStartOffset.minus(suggestion.getPrefixReplacementIndex());
        String tokenText = ((Object)outputModel.getText(tokenStartOffset, prefixStartOffset)).toString();
        String beforeTokenText = ((Object)outputModel.getText((TerminalOffset)RangesKt.coerceAtLeast((Comparable)tokenStartOffset.minus(1L), (Comparable)outputModel.getStartOffset()), tokenStartOffset)).toString();
        if (Intrinsics.areEqual((Object)beforeTokenText, (Object)"'") || Intrinsics.areEqual((Object)beforeTokenText, (Object)"\"")) {
            return new CompletionItemInsertionInfo(baseInsertValue, initialBeforeReplacementLength, initialAfterReplacementLength);
        }
        if (ShellName.Companion.isPowerShell(shellName)) {
            boolean addCursor = !StringsKt.contains$default((CharSequence)baseInsertValue, (CharSequence)CURSOR_MARKER, (boolean)false, (int)2, null);
            String insertValue = "'" + tokenText + baseInsertValue + (addCursor ? CURSOR_MARKER : "") + "'";
            int beforeReplacementLength = tokenText.length();
            String textAfterCursor = ((Object)outputModel.getText(outputModel.getCursorOffset(), (TerminalOffset)RangesKt.coerceAtMost((Comparable)outputModel.getCursorOffset().plus(1L), (Comparable)outputModel.getEndOffset()))).toString();
            int afterReplacementLength = Intrinsics.areEqual((Object)textAfterCursor, (Object)"'") || Intrinsics.areEqual((Object)textAfterCursor, (Object)"\"") ? 1 : 0;
            return new CompletionItemInsertionInfo(insertValue, beforeReplacementLength, afterReplacementLength);
        }
        StringBuilder $this$calculateInsertionInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int cursorIndex = StringsKt.indexOf$default((CharSequence)baseInsertValue, (String)CURSOR_MARKER, (int)0, (boolean)false, (int)6, null);
        String valueNoCursor = StringsKt.replace$default((String)baseInsertValue, (String)CURSOR_MARKER, (String)"", (boolean)false, (int)4, null);
        int n = valueNoCursor.length();
        for (int ind = 0; ind < n; ++ind) {
            char ch = valueNoCursor.charAt(ind);
            if (ind == cursorIndex) {
                $this$calculateInsertionInfo_u24lambda_u240.append(CURSOR_MARKER);
            }
            if (StringsKt.contains$default((CharSequence)UNIX_SHELLS_CHARS_TO_ESCAPE, (char)ch, (boolean)false, (int)2, null)) {
                $this$calculateInsertionInfo_u24lambda_u240.append("\\");
            }
            $this$calculateInsertionInfo_u24lambda_u240.append(ch);
        }
        String insertValue = stringBuilder.toString();
        return new CompletionItemInsertionInfo(insertValue, initialBeforeReplacementLength, initialAfterReplacementLength);
    }

    private static final CompletionItemInsertionInfo optimizeInsertionInfo(TerminalOutputModel outputModel, CompletionItemInsertionInfo baseInfo, int typedPrefixLength) {
        CompletionItemInsertionInfo completionItemInsertionInfo;
        try {
            completionItemInsertionInfo = TerminalCompletionItemInsertionKt.doOptimizeInsertionInfo(outputModel, baseInfo, typedPrefixLength);
        }
        catch (Exception e) {
            LOG.error(StringsKt.trimIndent((String)("\n      Failed to optimize completion item insertion, typedPrefixLength: " + typedPrefixLength + ", base info: " + baseInfo + ",\n      cursor line context: '" + TerminalCompletionItemInsertionKt.getCursorLineContext(outputModel) + "'\n    ")), (Throwable)e);
            completionItemInsertionInfo = baseInfo;
        }
        return completionItemInsertionInfo;
    }

    private static final CompletionItemInsertionInfo doOptimizeInsertionInfo(TerminalOutputModel outputModel, CompletionItemInsertionInfo baseInfo, int typedPrefixLength) {
        TerminalOffset cursorOffset = outputModel.getCursorOffset();
        TerminalOffset prefixStartOffset = cursorOffset.minus(typedPrefixLength);
        TerminalOffset tokenStartOffset = prefixStartOffset.minus(baseInfo.getBeforePrefixReplacementLength());
        String typedTokenText = ((Object)outputModel.getText(tokenStartOffset, prefixStartOffset)).toString();
        int commonPrefixLength = StringsKt.commonPrefixWith$default((CharSequence)typedTokenText, (CharSequence)baseInfo.getInsertValue(), (boolean)false, (int)2, null).length();
        String afterCursorText = ((Object)outputModel.getText(cursorOffset, cursorOffset.plus(baseInfo.getAfterPrefixReplacementLength()))).toString();
        int commonSuffixLength = StringsKt.commonSuffixWith$default((CharSequence)afterCursorText, (CharSequence)baseInfo.getInsertValue(), (boolean)false, (int)2, null).length();
        int newBeforeReplacementLength = baseInfo.getBeforePrefixReplacementLength() - commonPrefixLength;
        int newAfterReplacementLength = baseInfo.getAfterPrefixReplacementLength() - commonSuffixLength;
        String string = baseInfo.getInsertValue().substring(commonPrefixLength, baseInfo.getInsertValue().length() - commonSuffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String newInsertValue = string;
        return new CompletionItemInsertionInfo(newInsertValue, newBeforeReplacementLength, newAfterReplacementLength);
    }

    private static final boolean needsEscaping(ShellName shellName, String value) {
        boolean bl;
        block1: {
            String charsToEscape = ShellName.Companion.isPowerShell(shellName) ? POWERSHELL_CHARS_TO_ESCAPE : UNIX_SHELLS_CHARS_TO_ESCAPE;
            CharSequence $this$any$iv = StringsKt.replace$default((String)value, (String)CURSOR_MARKER, (String)"", (boolean)false, (int)4, null);
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)charsToEscape, (char)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String getCursorLineContext(TerminalOutputModel $this$getCursorLineContext) {
        StringBuilder stringBuilder;
        TerminalLineIndex cursorLine = $this$getCursorLineContext.getLineByOffset($this$getCursorLineContext.getCursorOffset());
        TerminalOffset lineStartOffset = $this$getCursorLineContext.getStartOfLine(cursorLine);
        TerminalOffset lineEndOffset = TerminalOutputModel.getEndOfLine$default($this$getCursorLineContext, cursorLine, false, 2, null);
        StringBuilder $this$getCursorLineContext_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getCursorLineContext_u24lambda_u240.append(((Object)$this$getCursorLineContext.getText(lineStartOffset, lineEndOffset)).toString());
        $this$getCursorLineContext_u24lambda_u240.insert((int)$this$getCursorLineContext.getCursorOffset().minus(lineStartOffset), "<cursor>");
        return stringBuilder.toString();
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

