/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.workspaceModel.ExternalProjectsBuildClasspathEntity;
import com.intellij.openapi.externalSystem.settings.workspaceModel.ExternalProjectsBuildClasspathEntityBuilder;
import com.intellij.openapi.externalSystem.settings.workspaceModel.ExternalProjectsBuildClasspathEntityModifications;
import com.intellij.openapi.externalSystem.settings.workspaceModel.MappersKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0007J\"\u0010\u0012\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0014\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/externalSystem/settings/ProjectBuildClasspathManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setProjectBuildClasspathSync", "", "value", "", "", "Lcom/intellij/openapi/externalSystem/model/project/ExternalProjectBuildClasspathPojo;", "setProjectBuildClasspath", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOrAddValueToStorage", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getProjectBuildClasspath", "removeUnavailableClasspaths", "getAvailableProjectsPaths", "", "intellij.platform.externalSystem"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectBuildClasspathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectBuildClasspathManager.kt\ncom/intellij/openapi/externalSystem/settings/ProjectBuildClasspathManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n491#3,7:90\n1586#4:97\n1661#4,3:98\n1391#4:101\n1480#4,5:102\n1586#4:107\n1661#4,3:108\n*S KotlinDebug\n*F\n+ 1 ProjectBuildClasspathManager.kt\ncom/intellij/openapi/externalSystem/settings/ProjectBuildClasspathManager\n*L\n80#1:90,7\n85#1:97\n85#1:98,3\n86#1:101\n86#1:102,5\n87#1:107\n87#1:108,3\n*E\n"})
public final class ProjectBuildClasspathManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public ProjectBuildClasspathManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @RequiresBackgroundThread
    public final void setProjectBuildClasspathSync(@NotNull Map<String, ? extends ExternalProjectBuildClasspathPojo> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ ProjectBuildClasspathManager this$0;
            final /* synthetic */ Map<String, ExternalProjectBuildClasspathPojo> $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.setProjectBuildClasspath(this.$value, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final Object setProjectBuildClasspath(@NotNull Map<String, ? extends ExternalProjectBuildClasspathPojo> value, @NotNull Continuation<? super Unit> $completion) {
        Object object = WorkspaceModelKt.getWorkspaceModel((Project)this.project).update("AbstractExternalSystemLocalSettings async update", arg_0 -> ProjectBuildClasspathManager.setProjectBuildClasspath$lambda$0(this, value, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void updateOrAddValueToStorage(Map<String, ? extends ExternalProjectBuildClasspathPojo> value, MutableEntityStorage storage) {
        ExternalProjectsBuildClasspathEntityBuilder newClasspathEntity = MappersKt.getExternalProjectsBuildClasspathEntity(value);
        ExternalProjectsBuildClasspathEntity buildClasspathEntity = (ExternalProjectsBuildClasspathEntity)SequencesKt.firstOrNull((Sequence)storage.entities(ExternalProjectsBuildClasspathEntity.class));
        ExternalProjectsBuildClasspathEntity externalProjectsBuildClasspathEntity = buildClasspathEntity != null ? ExternalProjectsBuildClasspathEntityModifications.modifyExternalProjectsBuildClasspathEntity(storage, buildClasspathEntity, (Function1<? super ExternalProjectsBuildClasspathEntityBuilder, Unit>)((Function1)arg_0 -> ProjectBuildClasspathManager.updateOrAddValueToStorage$lambda$0(newClasspathEntity, arg_0))) : (ExternalProjectsBuildClasspathEntity)storage.addEntity((WorkspaceEntity.Builder)newClasspathEntity);
    }

    @NotNull
    public final Map<String, ExternalProjectBuildClasspathPojo> getProjectBuildClasspath() {
        Map<String, ExternalProjectBuildClasspathPojo> map;
        block3: {
            block2: {
                ExternalProjectsBuildClasspathEntity externalProjectsBuildClasspathEntity = (ExternalProjectsBuildClasspathEntity)SequencesKt.firstOrNull((Sequence)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ExternalProjectsBuildClasspathEntity.class));
                if (externalProjectsBuildClasspathEntity == null) break block2;
                ExternalProjectsBuildClasspathEntity it = externalProjectsBuildClasspathEntity;
                boolean bl = false;
                map = MappersKt.getExternalProjectBuildClasspathPojo(it);
                if (map != null) break block3;
            }
            Map<String, ExternalProjectBuildClasspathPojo> map2 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
            return map2;
        }
        return map;
    }

    public final void removeUnavailableClasspaths() {
        Map<String, ExternalProjectBuildClasspathPojo> currentClasspath;
        Set availableProjectsPaths = CollectionsKt.toSet((Iterable)this.getAvailableProjectsPaths());
        Map<String, ExternalProjectBuildClasspathPojo> $this$filterKeys$iv = currentClasspath = this.getProjectBuildClasspath();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, ExternalProjectBuildClasspathPojo> result$iv = new LinkedHashMap<String, ExternalProjectBuildClasspathPojo>();
        for (Map.Entry<String, ExternalProjectBuildClasspathPojo> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!availableProjectsPaths.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map updatedClasspath = result$iv;
        this.setProjectBuildClasspathSync(updatedClasspath);
    }

    private final List<String> getAvailableProjectsPaths() {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        AbstractExternalSystemLocalSettings it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<ExternalSystemManager<?, ?, ?, ?, ?>> list = ExternalSystemApiUtil.getAllManagers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllManagers(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ExternalSystemManager externalSystemManager = (ExternalSystemManager)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((AbstractExternalSystemLocalSettings)it.getLocalSettingsProvider().fun((Object)this.project));
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (AbstractExternalSystemLocalSettings)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getAvailableProjects().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ExternalProjectPojo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ExternalProjectPojo)((Object)it)).getPath());
        }
        return (List)destination$iv$iv;
    }

    private static final Unit setProjectBuildClasspath$lambda$0(ProjectBuildClasspathManager this$0, Map $value, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this$0.updateOrAddValueToStorage($value, storage);
        return Unit.INSTANCE;
    }

    private static final Unit updateOrAddValueToStorage$lambda$0(ExternalProjectsBuildClasspathEntityBuilder $newClasspathEntity, ExternalProjectsBuildClasspathEntityBuilder $this$modifyExternalProjectsBuildClasspathEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyExternalProjectsBuildClasspathEntity, (String)"$this$modifyExternalProjectsBuildClasspathEntity");
        $this$modifyExternalProjectsBuildClasspathEntity.setProjectsBuildClasspath($newClasspathEntity.getProjectsBuildClasspath());
        return Unit.INSTANCE;
    }
}

