/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.process;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.channels.SshChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SshProcess<C extends SshChannel>
extends RemoteSshProcess {
    private static final Logger LOG = Logger.getInstance(SshProcess.class);
    private static final long WAIT_FOR_TIMEOUT = 5000L;
    private boolean myCtrlCSent;
    private long myCtrlCSentMillis;
    @NotNull
    private final C myChannel;

    public SshProcess(@NotNull C channel2) {
        if (channel2 == null) {
            SshProcess.h(0);
        }
        this.myCtrlCSent = false;
        this.myChannel = channel2;
    }

    @NotNull
    public C getChannel() {
        C c = this.myChannel;
        if (c == null) {
            SshProcess.h(1);
        }
        return c;
    }

    public InputStream getInputStream() {
        return this.getChannel().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getChannel().getOutputStream();
    }

    public boolean isDisconnected() {
        return this.getChannel().isClosed();
    }

    public int exitValue() {
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        return this.getChannel().getExitStatus();
    }

    public boolean isAlive() {
        return this.getChannel().getExitStatus() < 0 && this.getChannel().isConnected();
    }

    public void destroy() {
        if (this.getChannel().isConnected()) {
            this.getChannel().close();
        }
    }

    public int waitFor() throws InterruptedException {
        while (this.isAlive()) {
            Thread.sleep(100L);
            if (!this.myCtrlCSent || System.currentTimeMillis() - this.myCtrlCSentMillis <= 5000L) continue;
            LOG.warn("Remote process wasn't closed within timeout after Ctrl+C. Disconnecting.");
            this.destroy();
        }
        return this.exitValue();
    }

    public void addRemoteTunnel(int remotePort, @NotNull String host, int localPort) throws RemoteSdkException {
        if (host == null) {
            SshProcess.h(2);
        }
        try {
            this.myChannel.getSshSession().addRemoteTunnel(remotePort, host, localPort);
        }
        catch (SshException sshException) {
            throw new RemoteSdkException(sshException.getMessage(), (Throwable)((Object)sshException));
        }
    }

    public void addLocalTunnel(int localPort, int remotePort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().addLocalTunnel(localPort, this.myChannel.getSshSession().getHost(), remotePort);
        }
        catch (SshException sshException) {
            throw new RemoteSdkException(sshException.getMessage(), (Throwable)((Object)sshException));
        }
    }

    public void addLocalTunnel(int localPort, @NotNull String host, int remotePort) throws RemoteSdkException {
        if (host == null) {
            SshProcess.h(3);
        }
        try {
            this.myChannel.getSshSession().addLocalTunnel(localPort, host, remotePort);
        }
        catch (SshException sshException) {
            throw new RemoteSdkException(sshException.getMessage(), (Throwable)((Object)sshException));
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.myChannel.getLocalTunnel(remotePort);
    }

    public void removeLocalTunnel(int localPort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().removeLocalTunnel(localPort);
        }
        catch (SshException sshException) {
            throw new RemoteSdkException(sshException.getMessage(), (Throwable)((Object)sshException));
        }
    }

    public boolean killProcessTree() {
        if (this.hasPty()) {
            try {
                this.getOutputStream().write(3);
                this.getOutputStream().flush();
                this.myCtrlCSent = true;
                this.myCtrlCSentMillis = System.currentTimeMillis();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @NotNull
    public SshSession getSession() {
        SshSession sshSession = this.myChannel.getSshSession();
        if (sshSession == null) {
            SshProcess.h(4);
        }
        return sshSession;
    }

    private static /* synthetic */ void h(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/process/SshProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/process/SshProcess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChannel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteTunnel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLocalTunnel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

