/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerDocumentOffsetEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.jetbrains.python.console.PyConsoleIndentUtil;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/jetbrains/python/debugger/PyDebuggerEvaluator;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "Lcom/intellij/xdebugger/impl/evaluate/quick/XDebuggerDocumentOffsetEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myDebugProcess", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "evaluate", "", "expression", "", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "none", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getNone", "()Lcom/jetbrains/python/debugger/PyDebugValue;", "doEvaluate", "expr", "doTrunc", "", "getExpressionRangeAtOffset", "Lcom/intellij/openapi/util/TextRange;", "project", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "sideEffectsAllowed", "formatTextForEvaluation", "text", "hintType", "Lcom/intellij/xdebugger/impl/evaluate/quick/common/ValueHintType;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDebuggerEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDebuggerEvaluator.kt\ncom/jetbrains/python/debugger/PyDebuggerEvaluator\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,85:1\n106#2:86\n78#2,22:87\n*S KotlinDebug\n*F\n+ 1 PyDebuggerEvaluator.kt\ncom/jetbrains/python/debugger/PyDebuggerEvaluator\n*L\n31#1:86\n31#1:87,22\n*E\n"})
public final class PyDebuggerEvaluator
extends XDebuggerEvaluator
implements XDebuggerDocumentOffsetEvaluator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PyFrameAccessor myDebugProcess;

    public PyDebuggerEvaluator(@NotNull Project myProject, @NotNull PyFrameAccessor myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        this.myProject = myProject;
        this.myDebugProcess = myDebugProcess;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.doEvaluate(expression, callback, true);
    }

    private final PyDebugValue getNone() {
        return new PyDebugValue("", "NoneType", null, "None", false, null, null, false, false, false, null, null, this.myDebugProcess);
    }

    private final void doEvaluate(String expr, XDebuggerEvaluator.XEvaluationCallback callback, boolean doTrunc) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDebuggerEvaluator.doEvaluate$lambda$0(expr, callback, this, doTrunc));
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(@Nullable Project project, @Nullable Document document, int offset, boolean sideEffectsAllowed) {
        return PyDebugSupportUtils.getExpressionRangeAtOffset(project, document, offset);
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = PyConsoleIndentUtil.normalize(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        return string;
    }

    public void evaluate(@NotNull Document document, int offset, @NotNull ValueHintType hintType, @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)hintType, (String)"hintType");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!Registry.Companion.is("python.debugger.show.value.tooltip")) {
            callback.errorOccurred("");
            return;
        }
        PsiReference ref = (PsiReference)ReadAction.compute(() -> PyDebuggerEvaluator.evaluate$lambda$0(this, document, offset));
        if (ref == null) {
            callback.errorOccurred("");
            return;
        }
        PsiElement psiElement = ref.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element2 = psiElement;
        if (element2 instanceof PyExpression) {
            if (element2.getParent() instanceof PyCallExpression) {
                callback.errorOccurred("");
            } else {
                String string = element2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.doEvaluate(string, callback, false);
            }
        } else {
            callback.errorOccurred("");
        }
    }

    private static final void doEvaluate$lambda$0(String $expr, XDebuggerEvaluator.XEvaluationCallback $callback, PyDebuggerEvaluator this$0, boolean $doTrunc) {
        String expression;
        String $this$trim$iv = $expr;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)(expression = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            $callback.evaluated((XValue)this$0.getNone());
            return;
        }
        boolean isExpression = PyDebugSupportUtils.isExpression(this$0.myProject, expression);
        try {
            PyDebugValue value = this$0.myDebugProcess.evaluate(expression, !isExpression, $doTrunc);
            if (value.isErrorOnEval()) {
                $callback.errorOccurred("{" + value.getType() + "}" + value.getValue());
            } else {
                $callback.evaluated((XValue)value);
            }
        }
        catch (PyDebuggerException e) {
            $callback.errorOccurred(e.getTracebackError());
        }
    }

    private static final PsiReference evaluate$lambda$0(PyDebuggerEvaluator this$0, Document $document, int $offset) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this$0.myProject).getPsiFile($document);
        return psiFile != null ? psiFile.findReferenceAt($offset) : null;
    }
}

