/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XCopyValueAction;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.PyCopyValueEvaluationCallback;
import com.jetbrains.python.debugger.PyDebugUtilsKt;
import com.jetbrains.python.debugger.QuotingPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J*\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0005R\u00020\u0006H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/debugger/actions/PyXCopyValueAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XCopyValueAction;", "<init>", "()V", "createCollector", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addToCollector", "", "paths", "", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "valueNode", "valueCollector", "isNotPython", "", "session", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "MyCollector", "intellij.python.community.impl"})
public final class PyXCopyValueAction
extends XCopyValueAction {
    @NotNull
    protected XFetchValueActionBase.ValueCollector createCollector(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XDebugSessionProxy session = DebuggerUIUtil.getSessionProxy((AnActionEvent)e);
        if (session == null || this.isNotPython(session)) {
            XFetchValueActionBase.ValueCollector valueCollector = super.createCollector(e);
            Intrinsics.checkNotNullExpressionValue((Object)valueCollector, (String)"createCollector(...)");
            return valueCollector;
        }
        return new MyCollector(session);
    }

    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode, @NotNull XFetchValueActionBase.ValueCollector valueCollector) {
        XDebugSessionProxy session;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)valueNode, (String)"valueNode");
        Intrinsics.checkNotNullParameter((Object)valueCollector, (String)"valueCollector");
        MyCollector myCollector = valueCollector instanceof MyCollector ? (MyCollector)valueCollector : null;
        Object object = session = myCollector != null ? myCollector.getSession() : null;
        if (session == null || this.isNotPython(session)) {
            super.addToCollector(paths, valueNode, valueCollector);
            return;
        }
        if (paths.size() > 1) {
            valueCollector.add(valueNode.getText().toString(), valueNode.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
            QuotingPolicy quotingPolicy = PyDebuggerSettings.getInstance().getQuotingPolicy();
            if (fullValueEvaluator != null) {
                Intrinsics.checkNotNull((Object)quotingPolicy);
                new PyCopyValueEvaluationCallback(valueNode, valueCollector, quotingPolicy).startFetchingValue(fullValueEvaluator);
            } else {
                Intrinsics.checkNotNull((Object)quotingPolicy);
                String string = DebuggerUIUtil.getNodeRawValue((XValueNodeImpl)valueNode);
                if (string == null) {
                    string = "";
                }
                valueCollector.add(PyDebugUtilsKt.getQuotingString((QuotingPolicy)quotingPolicy, (String)string));
            }
        }
    }

    private final boolean isNotPython(XDebugSessionProxy session) {
        return !(session.getEditorsProvider().getFileType() instanceof PythonFileType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/debugger/actions/PyXCopyValueAction$MyCollector;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase;", "session", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "<init>", "(Lcom/jetbrains/python/debugger/actions/PyXCopyValueAction;Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;)V", "getSession", "()Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "intellij.python.community.impl"})
    private final class MyCollector
    extends XFetchValueActionBase.ValueCollector {
        @NotNull
        private final XDebugSessionProxy session;

        public MyCollector(XDebugSessionProxy session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super((XFetchValueActionBase)PyXCopyValueAction.this, session.getProject());
            this.session = session;
        }

        @NotNull
        public final XDebugSessionProxy getSession() {
            return this.session;
        }
    }
}

