/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.project.Project;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R!\u0010\u001d\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u001c\u0010!\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010\u0011R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFrameAccessor", "()Lcom/jetbrains/python/debugger/PyFrameAccessor;", "format", "", "getFormat", "()Ljava/lang/String;", "setFormat", "(Ljava/lang/String;)V", "slicing", "getSlicing", "setSlicing", "isColored", "", "()Z", "setColored", "(Z)V", "protectedColored", "getProtectedColored", "setProtectedColored", "originalVarName", "Lcom/intellij/openapi/util/NlsSafe;", "getOriginalVarName", "setOriginalVarName", "modifiedVarName", "getModifiedVarName", "setModifiedVarName", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getDebugValue", "()Lcom/jetbrains/python/debugger/PyDebugValue;", "setDebugValue", "(Lcom/jetbrains/python/debugger/PyDebugValue;)V", "isModified", "setModified", "intellij.python.community.impl"})
public final class PyDataViewerModel {
    @NotNull
    private final Project project;
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private String format;
    @NotNull
    private String slicing;
    private boolean isColored;
    private boolean protectedColored;
    @Nullable
    private String originalVarName;
    @Nullable
    private String modifiedVarName;
    @Nullable
    private PyDebugValue debugValue;
    private boolean isModified;

    public PyDataViewerModel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        this.project = project;
        this.frameAccessor = frameAccessor;
        this.format = "";
        this.slicing = "";
        this.protectedColored = PyDataView.Companion.isColoringEnabled(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PyFrameAccessor getFrameAccessor() {
        return this.frameAccessor;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.format = string;
    }

    @NotNull
    public final String getSlicing() {
        return this.slicing;
    }

    public final void setSlicing(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.slicing = string;
    }

    public final boolean isColored() {
        return this.isColored;
    }

    public final void setColored(boolean bl) {
        this.isColored = bl;
    }

    public final boolean getProtectedColored() {
        return this.protectedColored;
    }

    public final void setProtectedColored(boolean bl) {
        this.protectedColored = bl;
    }

    @Nullable
    public final String getOriginalVarName() {
        return this.originalVarName;
    }

    public final void setOriginalVarName(@Nullable String string) {
        this.originalVarName = string;
    }

    @Nullable
    public final String getModifiedVarName() {
        return this.modifiedVarName;
    }

    public final void setModifiedVarName(@Nullable String string) {
        this.modifiedVarName = string;
    }

    @Nullable
    public final PyDebugValue getDebugValue() {
        return this.debugValue;
    }

    public final void setDebugValue(@Nullable PyDebugValue pyDebugValue) {
        this.debugValue = pyDebugValue;
    }

    public final boolean isModified() {
        return this.isModified;
    }

    public final void setModified(boolean bl) {
        this.isModified = bl;
    }
}

