/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.validation;

import com.intellij.stats.completion.DeserializedLogEvent;
import com.intellij.stats.completion.LogEventSerializer;
import com.intellij.stats.completion.ValidationStatus;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.validation.CompletionValidationState;
import com.intellij.stats.validation.EventLine;
import com.intellij.stats.validation.InvalidSessionType;
import com.intellij.stats.validation.UnsupportedRecorderVersion;
import com.intellij.stats.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/stats/validation/InputSessionValidator;", "", "()V", "processCompletionSession", "Lcom/intellij/stats/validation/ValidationResult;", "session", "", "Lcom/intellij/stats/validation/EventLine;", "validate", "", "", "completion-log-events"})
public final class InputSessionValidator {
    @NotNull
    public final ValidationResult validate(@NotNull Iterable<String> session) {
        Intrinsics.checkParameterIsNotNull(session, (String)"session");
        String currentSessionUid = null;
        boolean bl = false;
        List events = new ArrayList();
        for (String line : session) {
            DeserializedLogEvent deserializedLogEvent;
            CharSequence charSequence = line;
            boolean bl2 = false;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            bl2 = false;
            if (charSequence.length() == 0) continue;
            try {
                deserializedLogEvent = LogEventSerializer.INSTANCE.fromString(line);
            }
            catch (UnsupportedRecorderVersion e) {
                return new ValidationResult(ValidationStatus.OBSOLETE, null, 2, null);
            }
            DeserializedLogEvent event = deserializedLogEvent;
            EventLine eventLine = new EventLine(event, line);
            if (currentSessionUid == null || Intrinsics.areEqual((Object)eventLine.getSessionUid(), (Object)currentSessionUid)) {
                events.add(eventLine);
                currentSessionUid = eventLine.getSessionUid();
                continue;
            }
            return new ValidationResult(ValidationStatus.INVALID, InvalidSessionType.MIXED_SESSIONS);
        }
        return this.processCompletionSession(events);
    }

    private final ValidationResult processCompletionSession(List<EventLine> session) {
        ValidationResult validationResult;
        if (session.isEmpty()) {
            validationResult = new ValidationResult(ValidationStatus.INVALID, InvalidSessionType.EMPTY_SESSION);
        } else {
            EventLine it;
            boolean bl;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block16: {
                $this$any$iv = session;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (EventLine)element$iv;
                        boolean bl2 = false;
                        if (!(it.getEvent() == null)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                validationResult = new ValidationResult(ValidationStatus.INVALID, InvalidSessionType.PARSING_ERROR);
            } else {
                boolean bl3;
                block17: {
                    $this$any$iv = session;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (EventLine)element$iv;
                            boolean bl4 = false;
                            if (!(!it.getHasUnknownOrAbsentFields())) continue;
                            bl3 = true;
                            break block17;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    validationResult = new ValidationResult(ValidationStatus.INVALID, InvalidSessionType.UNKNOWN_ABSENT_FIELDS);
                } else {
                    EventLine initial = (EventLine)CollectionsKt.first(session);
                    if (initial.getEvent() instanceof CompletionStartedEvent) {
                        CompletionValidationState state = new CompletionValidationState((CompletionStartedEvent)initial.getEvent());
                        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)session, (int)1);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            EventLine it2 = (EventLine)element$iv;
                            boolean bl5 = false;
                            LogEvent logEvent = it2.getEvent();
                            if (logEvent == null) {
                                Intrinsics.throwNpe();
                            }
                            state.accept(logEvent);
                        }
                        validationResult = !state.isSessionValid() ? new ValidationResult(ValidationStatus.INVALID, state.errorType()) : new ValidationResult(ValidationStatus.VALID, null, 2, null);
                    } else {
                        validationResult = new ValidationResult(ValidationStatus.INVALID, InvalidSessionType.WRONG_EVENTS_ORDER);
                    }
                }
            }
        }
        return validationResult;
    }
}

