/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.ref;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jinja.psi.Jinja2ElementImpl;
import com.intellij.jinja.ref.Jinja2Reference;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0015\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference;", "Lcom/intellij/jinja/ref/Jinja2Reference;", "element", "Lcom/intellij/psi/PsiElement;", "elementType", "Ljava/lang/Class;", "Lcom/intellij/jinja/psi/Jinja2ElementImpl;", "definingTagName", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Class;Ljava/lang/String;)V", "getElementType", "()Ljava/lang/Class;", "getDefiningTagName", "()Ljava/lang/String;", "resolve", "getVariants", "", "", "()[Ljava/lang/Object;", "openBlockCandidateName", "getOpenBlockCandidateName", "processPrecedingBlockTags", "", "blockProcessor", "Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$BlockProcessor;", "BlockProcessor", "FindPrecedingBlocksProcessor", "FindMatchingOpenBlock", "FindOpenBlockProcessor", "intellij.jinja"})
@SourceDebugExtension(value={"SMAP\nJinja2AbstractBlockNameReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jinja2AbstractBlockNameReference.kt\ncom/intellij/jinja/ref/Jinja2AbstractBlockNameReference\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n66#2,2:134\n1586#3:136\n1661#3,3:137\n37#4,2:140\n1#5:142\n*S KotlinDebug\n*F\n+ 1 Jinja2AbstractBlockNameReference.kt\ncom/intellij/jinja/ref/Jinja2AbstractBlockNameReference\n*L\n18#1:134,2\n34#1:136\n34#1:137,3\n35#1:140,2\n*E\n"})
public abstract class Jinja2AbstractBlockNameReference
extends Jinja2Reference {
    @NotNull
    private final Class<? extends Jinja2ElementImpl> elementType;
    @NotNull
    private final String definingTagName;

    public Jinja2AbstractBlockNameReference(@NotNull PsiElement element, @NotNull Class<? extends Jinja2ElementImpl> elementType, @NotNull String definingTagName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)definingTagName, (String)"definingTagName");
        super(element);
        this.elementType = elementType;
        this.definingTagName = definingTagName;
    }

    @NotNull
    public final Class<? extends Jinja2ElementImpl> getElementType() {
        return this.elementType;
    }

    @NotNull
    public final String getDefiningTagName() {
        return this.definingTagName;
    }

    @Nullable
    public PsiElement resolve() {
        DjangoTagElementImpl tag;
        PsiElement $this$parentOfType_u24default$iv = this.getElement();
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        DjangoTagElementImpl djangoTagElementImpl = tag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, DjangoTagElementImpl.class, (boolean)true);
        if (Intrinsics.areEqual((Object)(djangoTagElementImpl != null ? djangoTagElementImpl.getName() : null), (Object)this.definingTagName)) {
            return null;
        }
        String string = this.getElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        FindOpenBlockProcessor processor = new FindOpenBlockProcessor(string);
        this.processPrecedingBlockTags(this.getElement(), processor);
        if (processor.getOpenBlock() != null) {
            return PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)processor.getOpenBlock()), this.elementType);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapTo$iv$iv;
        FindPrecedingBlocksProcessor processor = new FindPrecedingBlocksProcessor();
        this.processPrecedingBlockTags(this.getElement(), processor);
        Iterable $this$map$iv = processor.getOpenBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Jinja2ElementImpl jinja2ElementImpl = (Jinja2ElementImpl)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNull((Object)string);
            collection.add(LookupElementBuilder.create((String)string));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @Nullable
    public final String getOpenBlockCandidateName() {
        Jinja2ElementImpl blockName;
        FindMatchingOpenBlock processor = new FindMatchingOpenBlock();
        this.processPrecedingBlockTags(this.getElement(), processor);
        if (processor.getMatchingOpenBlock() != null && (blockName = (Jinja2ElementImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)processor.getMatchingOpenBlock()), this.elementType)) != null) {
            return blockName.getName();
        }
        return null;
    }

    private final void processPrecedingBlockTags(PsiElement element, BlockProcessor blockProcessor) {
        DjangoTagElementImpl tagElement = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        while ((tagElement = (DjangoTagElementImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)((PsiElement)tagElement), DjangoTagElementImpl.class)) != null) {
            boolean it;
            boolean bl;
            if (Intrinsics.areEqual((Object)tagElement.getName(), (Object)this.definingTagName)) {
                it = bl = blockProcessor.block(tagElement);
                boolean bl2 = false;
                if (!it) break;
            }
            if (!Intrinsics.areEqual((Object)tagElement.getName(), (Object)("end" + this.definingTagName))) continue;
            it = bl = blockProcessor.endBlock(tagElement);
            boolean bl3 = false;
            if (it) continue;
            break;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0004H&J\u0012\u0010\u0005\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$BlockProcessor;", "", "block", "", "Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "endBlock", "intellij.jinja"})
    private static interface BlockProcessor {
        public boolean block(@Nullable DjangoTagElementImpl var1);

        public boolean endBlock(@Nullable DjangoTagElementImpl var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0014R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$FindMatchingOpenBlock;", "Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$FindPrecedingBlocksProcessor;", "Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference;", "<init>", "(Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference;)V", "value", "Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "matchingOpenBlock", "getMatchingOpenBlock", "()Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "foundNotMatchingBlock", "", "block", "intellij.jinja"})
    private final class FindMatchingOpenBlock
    extends FindPrecedingBlocksProcessor {
        @Nullable
        private DjangoTagElementImpl matchingOpenBlock;

        @Nullable
        public final DjangoTagElementImpl getMatchingOpenBlock() {
            return this.matchingOpenBlock;
        }

        @Override
        protected boolean foundNotMatchingBlock(@Nullable DjangoTagElementImpl block) {
            this.matchingOpenBlock = block;
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\r\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$FindOpenBlockProcessor;", "Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$BlockProcessor;", "name", "", "<init>", "(Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference;Ljava/lang/String;)V", "value", "Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "openBlock", "getOpenBlock", "()Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "block", "", "endBlock", "intellij.jinja"})
    private final class FindOpenBlockProcessor
    implements BlockProcessor {
        @NotNull
        private final String name;
        @Nullable
        private DjangoTagElementImpl openBlock;

        public FindOpenBlockProcessor(String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Nullable
        public final DjangoTagElementImpl getOpenBlock() {
            return this.openBlock;
        }

        @Override
        public boolean block(@Nullable DjangoTagElementImpl block) {
            Jinja2ElementImpl blockName = (Jinja2ElementImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)block), Jinja2AbstractBlockNameReference.this.getElementType());
            if (blockName != null && Intrinsics.areEqual((Object)this.name, (Object)blockName.getName())) {
                this.openBlock = block;
                return false;
            }
            return true;
        }

        @Override
        public boolean endBlock(@Nullable DjangoTagElementImpl endBlock) {
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0014J\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$FindPrecedingBlocksProcessor;", "Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference$BlockProcessor;", "<init>", "(Lcom/intellij/jinja/ref/Jinja2AbstractBlockNameReference;)V", "closeTags", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "openBlocks", "Ljava/util/ArrayList;", "Lcom/intellij/jinja/psi/Jinja2ElementImpl;", "Lkotlin/collections/ArrayList;", "getOpenBlocks", "()Ljava/util/ArrayList;", "block", "", "foundNotMatchingBlock", "endBlock", "intellij.jinja"})
    private class FindPrecedingBlocksProcessor
    implements BlockProcessor {
        @NotNull
        private final Stack<DjangoTagElementImpl> closeTags = new Stack();
        @NotNull
        private final ArrayList<Jinja2ElementImpl> openBlocks = new ArrayList();

        @NotNull
        public final ArrayList<Jinja2ElementImpl> getOpenBlocks() {
            return this.openBlocks;
        }

        @Override
        public boolean block(@Nullable DjangoTagElementImpl block) {
            if (this.closeTags.empty()) {
                return this.foundNotMatchingBlock(block);
            }
            DjangoTagElementImpl cfr_ignored_0 = (DjangoTagElementImpl)((Object)this.closeTags.pop());
            return true;
        }

        protected boolean foundNotMatchingBlock(@Nullable DjangoTagElementImpl block) {
            Jinja2ElementImpl blockName = (Jinja2ElementImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)block), Jinja2AbstractBlockNameReference.this.getElementType());
            if (blockName != null) {
                this.openBlocks.add(blockName);
            }
            return true;
        }

        @Override
        public boolean endBlock(@Nullable DjangoTagElementImpl endBlock) {
            this.closeTags.push((Object)endBlock);
            return true;
        }
    }
}

