/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template;

import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.template.DjangoTemplateFileType;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2FilterNameImpl;
import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.jinja.template.psi.impl.Jinja2TagNameImpl;
import com.intellij.jinja.template.psi.impl.Jinja2VariableReferenceImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jinja/template/Jinja2TemplateElementGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createStringLiteral", "Lcom/intellij/jinja/psi/Jinja2StringLiteral;", "name", "", "createVariableReference", "Lcom/intellij/jinja/template/psi/impl/Jinja2VariableReferenceImpl;", "createMemberName", "Lcom/intellij/jinja/template/psi/impl/Jinja2MemberNameImpl;", "createTagName", "Lcom/intellij/jinja/template/psi/impl/Jinja2TagNameImpl;", "createNameIdentifier", "Lcom/intellij/lang/ASTNode;", "createTag", "Lcom/intellij/jinja/template/psi/impl/DjangoTagElementImpl;", "content", "createTempFile", "Lcom/intellij/psi/PsiFile;", "contents", "createFilterName", "Lcom/intellij/jinja/template/psi/impl/Jinja2FilterNameImpl;", "Companion", "intellij.jinja"})
public final class Jinja2TemplateElementGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public Jinja2TemplateElementGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Jinja2StringLiteral createStringLiteral(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean bl = PyStringLiteralCoreUtil.isQuoted((String)name);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiFile tempFile = this.createTempFile("{% extends " + name + " %}");
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tempFile), Jinja2StringLiteral.class);
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNull((Object)psiElement);
        return (Jinja2StringLiteral)psiElement;
    }

    @NotNull
    public final Jinja2VariableReferenceImpl createVariableReference(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile tempFile = this.createTempFile("{{ " + name + " }}");
        Class[] classArray = new Class[]{Jinja2VariableReferenceImpl.class};
        Object e = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)tempFile), (Class[])classArray).iterator().next();
        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
        return (Jinja2VariableReferenceImpl)((Object)e);
    }

    @NotNull
    public final Jinja2MemberNameImpl createMemberName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile tempFile = this.createTempFile("{% url " + name + " %}");
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tempFile), Jinja2MemberNameImpl.class);
        Intrinsics.checkNotNull((Object)psiElement);
        return (Jinja2MemberNameImpl)psiElement;
    }

    @NotNull
    public final Jinja2TagNameImpl createTagName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DjangoTagElementImpl tag = this.createTag(name, null);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tag), Jinja2TagNameImpl.class);
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNull((Object)psiElement);
        return (Jinja2TagNameImpl)psiElement;
    }

    @NotNull
    public final ASTNode createNameIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile tempFile = this.createTempFile("{% for " + name + " in books %}");
        ASTNode aSTNode = tempFile.getFirstChild().getFirstChild().getFirstChild().getNextSibling().getNextSibling().getNode().getFirstChildNode().getPsi().getNextSibling().getNextSibling().getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        return aSTNode;
    }

    private final DjangoTagElementImpl createTag(String name, String content) {
        PsiFile tempFile = null;
        tempFile = content == null || StringUtil.isEmptyOrSpaces((String)content) ? this.createTempFile("{% " + name + " %}") : this.createTempFile("{% " + name + " " + content + " %}");
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tempFile), DjangoTagElementImpl.class);
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNull((Object)psiElement);
        return (DjangoTagElementImpl)psiElement;
    }

    @NotNull
    public final PsiFile createTempFile(@Nullable String contents) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.project);
        String string = "temp." + DjangoTemplateFileType.INSTANCE.getDefaultExtension();
        Language language = DjangoTemplateLanguage.INSTANCE;
        String string2 = contents;
        Intrinsics.checkNotNull((Object)string2);
        PsiFile psiFile = psiFileFactory.createFileFromText(string, language, (CharSequence)string2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    @NotNull
    public final Jinja2FilterNameImpl createFilterName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PsiFile tempFile = this.createTempFile("{{ x|" + name + " }}");
        Class[] classArray = new Class[]{Jinja2FilterNameImpl.class};
        Object e = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)tempFile), (Class[])classArray).iterator().next();
        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
        return (Jinja2FilterNameImpl)e;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jinja/template/Jinja2TemplateElementGenerator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jinja/template/Jinja2TemplateElementGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jinja"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Jinja2TemplateElementGenerator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(Jinja2TemplateElementGenerator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (Jinja2TemplateElementGenerator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

