/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.parameters.PathVariableDeclaringReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.python.endpoints.HttpEndpointHandler;
import com.intellij.python.endpoints.HttpRouter;
import com.intellij.python.endpoints.HttpRouterProvider;
import com.intellij.python.endpoints.HttpRoutingNode;
import com.intellij.python.endpoints.ProjectWebStructure;
import com.intellij.python.endpoints.ProjectWebStructureKt;
import com.intellij.python.endpoints.RenderedEndpoint;
import com.intellij.python.endpoints.RoutingTableRecord;
import com.intellij.python.endpoints.UnknownHttpRouter;
import com.intellij.python.endpoints.WebStructureKt;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u0019\u0010\u0014R-\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0016\u001a\u0004\b \u0010!R-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001e0\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0016\u001a\u0004\b%\u0010!R-\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00110\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0016\u001a\u0004\b)\u0010!R!\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0016\u001a\u0004\b-\u0010\u0014\u00a8\u00061"}, d2={"Lcom/intellij/python/endpoints/WebApplication;", "", "provider", "Lcom/intellij/python/endpoints/HttpRouterProvider;", "rootRouter", "Lcom/intellij/python/endpoints/HttpRouter;", "<init>", "(Lcom/intellij/python/endpoints/HttpRouterProvider;Lcom/intellij/python/endpoints/HttpRouter;)V", "getProvider", "()Lcom/intellij/python/endpoints/HttpRouterProvider;", "getRootRouter", "()Lcom/intellij/python/endpoints/HttpRouter;", "title", "", "getTitle", "()Ljava/lang/String;", "authorities", "", "Lcom/intellij/microservices/url/Authority$Exact;", "getAuthorities", "()Ljava/util/List;", "authorities$delegate", "Lkotlin/Lazy;", "endpoints", "Lcom/intellij/python/endpoints/RenderedEndpoint;", "getEndpoints", "endpoints$delegate", "pyFunctions", "", "Lcom/intellij/python/endpoints/HttpEndpointHandler;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/jetbrains/python/psi/PyFunction;", "getPyFunctions", "()Ljava/util/Map;", "pyFunctions$delegate", "pyPathDeclarations", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "getPyPathDeclarations", "pyPathDeclarations$delegate", "urlParameters", "Lcom/intellij/microservices/url/parameters/PathVariableDeclaringReference;", "getUrlParameters", "urlParameters$delegate", "rawEndpoints", "Lcom/intellij/python/endpoints/WebApplication$Endpoint;", "getRawEndpoints", "rawEndpoints$delegate", "listEndpoints", "Endpoint", "intellij.python.endpoints"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebStructure.kt\ncom/intellij/python/endpoints/WebApplication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,406:1\n1#2:407\n1#2:423\n1#2:437\n1586#3:408\n1661#3,3:409\n1642#3,10:412\n1915#3:422\n1916#3:424\n1652#3:425\n1642#3,10:426\n1915#3:436\n1916#3:438\n1652#3:439\n1205#3,2:440\n1282#3,4:442\n1915#3,2:446\n1915#3:448\n1807#3,3:449\n1916#3:453\n18#4:452\n*S KotlinDebug\n*F\n+ 1 WebStructure.kt\ncom/intellij/python/endpoints/WebApplication\n*L\n327#1:423\n335#1:437\n320#1:408\n320#1:409,3\n327#1:412,10\n327#1:422\n327#1:424\n327#1:425\n335#1:426,10\n335#1:436\n335#1:438\n335#1:439\n342#1:440,2\n342#1:442,4\n367#1:446,2\n371#1:448\n372#1:449,3\n371#1:453\n374#1:452\n*E\n"})
public final class WebApplication {
    @NotNull
    private final HttpRouterProvider provider;
    @NotNull
    private final HttpRouter rootRouter;
    @NotNull
    private final Lazy authorities$delegate;
    @NotNull
    private final Lazy endpoints$delegate;
    @NotNull
    private final Lazy pyFunctions$delegate;
    @NotNull
    private final Lazy pyPathDeclarations$delegate;
    @NotNull
    private final Lazy urlParameters$delegate;
    @NotNull
    private final Lazy rawEndpoints$delegate;

    public WebApplication(@NotNull HttpRouterProvider provider, @NotNull HttpRouter rootRouter) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)rootRouter, (String)"rootRouter");
        this.provider = provider;
        this.rootRouter = rootRouter;
        this.authorities$delegate = LazyKt.lazy(() -> WebApplication.authorities_delegate$lambda$0(this));
        this.endpoints$delegate = LazyKt.lazy(() -> WebApplication.endpoints_delegate$lambda$0(this));
        this.pyFunctions$delegate = LazyKt.lazy(() -> WebApplication.pyFunctions_delegate$lambda$0(this));
        this.pyPathDeclarations$delegate = LazyKt.lazy(() -> WebApplication.pyPathDeclarations_delegate$lambda$0(this));
        this.urlParameters$delegate = LazyKt.lazy(() -> WebApplication.urlParameters_delegate$lambda$0(this));
        this.rawEndpoints$delegate = LazyKt.lazy(() -> WebApplication.rawEndpoints_delegate$lambda$0(this));
    }

    @NotNull
    public final HttpRouterProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final HttpRouter getRootRouter() {
        return this.rootRouter;
    }

    @NotNull
    public final String getTitle() {
        return this.rootRouter.getTitle();
    }

    @NotNull
    public final List<Authority.Exact> getAuthorities() {
        Lazy lazy = this.authorities$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<RenderedEndpoint> getEndpoints() {
        Lazy lazy = this.endpoints$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<HttpEndpointHandler, SmartPsiElementPointer<PyFunction>> getPyFunctions() {
        Lazy lazy = this.pyFunctions$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<HttpEndpointHandler, SmartPsiElementPointer<PyStringLiteralExpression>> getPyPathDeclarations() {
        Lazy lazy = this.pyPathDeclarations$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<HttpEndpointHandler, List<PathVariableDeclaringReference>> getUrlParameters() {
        Lazy lazy = this.urlParameters$delegate;
        return (Map)lazy.getValue();
    }

    private final List<Endpoint> getRawEndpoints() {
        Lazy lazy = this.rawEndpoints$delegate;
        return (List)lazy.getValue();
    }

    private final List<Endpoint> listEndpoints() {
        ProjectWebStructure projectStructure;
        Object object;
        ProjectWebStructure projectWebStructure;
        SmartPsiElementPointer<PsiElement> smartPsiElementPointer = this.rootRouter.getPointer();
        if (smartPsiElementPointer != null) {
            SmartPsiElementPointer<PsiElement> it = smartPsiElementPointer;
            boolean bl = false;
            Project project = it.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            projectWebStructure = ProjectWebStructureKt.getProjectWebStructure$default(project, null, 2, null);
        } else {
            projectWebStructure = null;
        }
        boolean bl = (object = (projectStructure = projectWebStructure)) != null && (object = ((ProjectWebStructure)object).getParents(this.rootRouter)) != null ? !object.isEmpty() : false;
        if (bl) {
            return CollectionsKt.emptyList();
        }
        List endpoints = new ArrayList();
        RoutingTableRecord genesis = new RoutingTableRecord(null, "", this.rootRouter);
        ArrayDeque route = new ArrayDeque((Collection)CollectionsKt.listOf((Object)genesis));
        WebApplication.listEndpoints$traverse(endpoints, projectStructure, "", this.rootRouter, (ArrayDeque<RoutingTableRecord>)route, this.provider);
        return endpoints;
    }

    private static final List authorities_delegate$lambda$0(WebApplication this$0) {
        return this$0.provider.getAuthorities(this$0.rootRouter);
    }

    /*
     * WARNING - void declaration
     */
    private static final List endpoints_delegate$lambda$0(WebApplication this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getRawEndpoints();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Endpoint endpoint = (Endpoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String path2 = endpoint.component1();
            List<RoutingTableRecord> route = endpoint.component2();
            HttpEndpointHandler handler = endpoint.component3();
            HttpRouterProvider customProvider = endpoint.component4();
            collection.add(WebStructureKt.renderEndpoint(customProvider, this$0.getAuthorities(), path2, (Collection<RoutingTableRecord>)route, handler));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map pyFunctions_delegate$lambda$0(WebApplication this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this$0.getRawEndpoints();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Endpoint endpoint = (Endpoint)element$iv$iv;
            boolean bl2 = false;
            List<RoutingTableRecord> route = endpoint.component2();
            HttpEndpointHandler handler = endpoint.component3();
            HttpRouterProvider customProvider = endpoint.component4();
            if (customProvider.resolveFunctionPointer((Collection<RoutingTableRecord>)route, handler) != null) {
                SmartPsiElementPointer<PyFunction> it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)handler, it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map pyPathDeclarations_delegate$lambda$0(WebApplication this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this$0.getRawEndpoints();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Endpoint endpoint = (Endpoint)element$iv$iv;
            boolean bl2 = false;
            List<RoutingTableRecord> route = endpoint.component2();
            HttpEndpointHandler handler = endpoint.component3();
            HttpRouterProvider customProvider = endpoint.component4();
            if (customProvider.resolvePathDeclarationPointer((Collection<RoutingTableRecord>)route, handler) != null) {
                SmartPsiElementPointer<PyStringLiteralExpression> it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)handler, it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map urlParameters_delegate$lambda$0(WebApplication this$0) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this$0.getRawEndpoints();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Endpoint endpoint = (Endpoint)element$iv$iv;
            boolean bl = false;
            List<RoutingTableRecord> route = endpoint.component2();
            HttpEndpointHandler handler = endpoint.component3();
            HttpRouterProvider customProvider = endpoint.component4();
            endpoint = TuplesKt.to((Object)handler, customProvider.resolvePathParameters((Collection<RoutingTableRecord>)route, handler));
            map.put(endpoint.getFirst(), endpoint.getSecond());
        }
        return destination$iv$iv;
    }

    private static final List rawEndpoints_delegate$lambda$0(WebApplication this$0) {
        return this$0.listEndpoints();
    }

    private static final void listEndpoints$traverse(List<Endpoint> endpoints, ProjectWebStructure projectStructure, String parentPath, HttpRouter httpRouter, ArrayDeque<RoutingTableRecord> route, HttpRouterProvider currentProvider) {
        String nodeBasePath = parentPath + httpRouter.getPrefixPath();
        Iterable $this$forEach$iv = httpRouter.getEndpointHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpEndpointHandler handler = (HttpEndpointHandler)element$iv;
            boolean bl = false;
            ((Collection)endpoints).add(new Endpoint(nodeBasePath, CollectionsKt.toList((Iterable)((Iterable)route)), handler, currentProvider));
        }
        $this$forEach$iv = httpRouter.getRoutingTable();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            boolean bl;
            RoutingTableRecord record;
            block10: {
                record = (RoutingTableRecord)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)route;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv2 = object.next();
                        RoutingTableRecord it = (RoutingTableRecord)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getNextRouter(), (Object)record.getNextRouter())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            Object it = object = record.getPath();
            boolean bl4 = false;
            Object object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
            if (object2 == null) {
                HttpRoutingNode $this$asSafely$iv = record.getNextRouter();
                boolean $i$f$asSafely = false;
                HttpRoutingNode httpRoutingNode = $this$asSafely$iv;
                if (!(httpRoutingNode instanceof HttpRouter)) {
                    httpRoutingNode = null;
                }
                HttpRouter httpRouter2 = (HttpRouter)httpRoutingNode;
                object2 = httpRouter2 != null ? httpRouter2.getDefaultMountPath() : null;
                if (object2 == null) {
                    object2 = "";
                }
            }
            Object mountPath = object2;
            String newBasePath = nodeBasePath + (String)mountPath;
            object = record.getNextRouter();
            if (object instanceof HttpRouter) {
                route.addLast((Object)record);
                WebApplication.listEndpoints$traverse(endpoints, projectStructure, newBasePath, (HttpRouter)record.getNextRouter(), route, currentProvider);
                route.removeLast();
                continue;
            }
            if (object instanceof UnknownHttpRouter) {
                WebApplication application;
                if (projectStructure == null) continue;
                boolean bl5 = false;
                if (projectStructure.getFqnRootIndex().get(((UnknownHttpRouter)record.getNextRouter()).getQualifiedName()) == null) continue;
                boolean bl6 = false;
                if (Intrinsics.areEqual((Object)record.getNextRouter(), (Object)application.rootRouter)) continue;
                WebApplication.listEndpoints$traverse(endpoints, projectStructure, newBasePath, application.rootRouter, route, application.provider);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/python/endpoints/WebApplication$Endpoint;", "", "path", "", "route", "", "Lcom/intellij/python/endpoints/RoutingTableRecord;", "handler", "Lcom/intellij/python/endpoints/HttpEndpointHandler;", "provider", "Lcom/intellij/python/endpoints/HttpRouterProvider;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/python/endpoints/HttpEndpointHandler;Lcom/intellij/python/endpoints/HttpRouterProvider;)V", "getPath", "()Ljava/lang/String;", "getRoute", "()Ljava/util/List;", "getHandler", "()Lcom/intellij/python/endpoints/HttpEndpointHandler;", "getProvider", "()Lcom/intellij/python/endpoints/HttpRouterProvider;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.python.endpoints"})
    private static final class Endpoint {
        @NotNull
        private final String path;
        @NotNull
        private final List<RoutingTableRecord> route;
        @NotNull
        private final HttpEndpointHandler handler;
        @NotNull
        private final HttpRouterProvider provider;

        public Endpoint(@NotNull String path2, @NotNull List<RoutingTableRecord> route, @NotNull HttpEndpointHandler handler, @NotNull HttpRouterProvider provider) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(route, (String)"route");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.path = path2;
            this.route = route;
            this.handler = handler;
            this.provider = provider;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<RoutingTableRecord> getRoute() {
            return this.route;
        }

        @NotNull
        public final HttpEndpointHandler getHandler() {
            return this.handler;
        }

        @NotNull
        public final HttpRouterProvider getProvider() {
            return this.provider;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final List<RoutingTableRecord> component2() {
            return this.route;
        }

        @NotNull
        public final HttpEndpointHandler component3() {
            return this.handler;
        }

        @NotNull
        public final HttpRouterProvider component4() {
            return this.provider;
        }

        @NotNull
        public final Endpoint copy(@NotNull String path2, @NotNull List<RoutingTableRecord> route, @NotNull HttpEndpointHandler handler, @NotNull HttpRouterProvider provider) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(route, (String)"route");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new Endpoint(path2, route, handler, provider);
        }

        public static /* synthetic */ Endpoint copy$default(Endpoint endpoint, String string, List list, HttpEndpointHandler httpEndpointHandler, HttpRouterProvider httpRouterProvider, int n, Object object) {
            if ((n & 1) != 0) {
                string = endpoint.path;
            }
            if ((n & 2) != 0) {
                list = endpoint.route;
            }
            if ((n & 4) != 0) {
                httpEndpointHandler = endpoint.handler;
            }
            if ((n & 8) != 0) {
                httpRouterProvider = endpoint.provider;
            }
            return endpoint.copy(string, list, httpEndpointHandler, httpRouterProvider);
        }

        @NotNull
        public String toString() {
            return "Endpoint(path=" + this.path + ", route=" + this.route + ", handler=" + this.handler + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + ((Object)this.route).hashCode();
            result = result * 31 + this.handler.hashCode();
            result = result * 31 + this.provider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint endpoint = (Endpoint)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)endpoint.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.route, endpoint.route)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.handler, (Object)endpoint.handler)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)endpoint.provider);
        }
    }
}

