/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints.webStructure;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.endpoints.ModuleWebApplication;
import com.intellij.python.endpoints.PyEndpointsBundle;
import com.intellij.python.endpoints.UrlPathsMethods;
import com.intellij.python.endpoints.WebStructureAction;
import com.intellij.python.endpoints.WebStructureActionFactory;
import com.intellij.python.endpoints.WebStructureUsagesCollector;
import com.intellij.python.endpoints.webStructure.GoToParentContextActionFactoryKt;
import com.intellij.python.endpoints.webStructure.NavigateBackGotoTargetHandler;
import com.intellij.python.endpoints.webStructure.WebStructureNavigationHandler;
import java.awt.event.MouseEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/python/endpoints/webStructure/GoToParentContextActionFactory;", "Lcom/intellij/python/endpoints/WebStructureActionFactory;", "<init>", "()V", "createActions", "Lkotlin/sequences/Sequence;", "Lcom/intellij/python/endpoints/WebStructureAction;", "originalWebApplicationContexts", "", "Lcom/intellij/python/endpoints/ModuleWebApplication;", "Lcom/intellij/python/endpoints/UrlPathsMethods;", "Lcom/intellij/python/endpoints/WebApplicationContexts;", "NavigateBackNavigationHandler", "intellij.python.endpoints"})
public final class GoToParentContextActionFactory
implements WebStructureActionFactory {
    @Override
    @NotNull
    public Sequence<WebStructureAction> createActions(@NotNull Map<ModuleWebApplication, UrlPathsMethods> originalWebApplicationContexts) {
        Intrinsics.checkNotNullParameter(originalWebApplicationContexts, (String)"originalWebApplicationContexts");
        WebStructureAction action = new WebStructureAction(GoToParentContextActionFactoryKt.access$getGO_TO_PARENT_CONTEXT_ACTION_ICON$p(), PyEndpointsBundle.INSTANCE.message("web.structure.line.marker.navigate.back", new Object[0]), PyEndpointsBundle.INSTANCE.message("web.structure.line.marker.navigate.back.accessible.name", new Object[0]), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)NavigateBackNavigationHandler.INSTANCE), (Function2<? super WebStructureUsagesCollector.Origin, ? super MouseEvent, Unit>)((Function2)GoToParentContextActionFactory::createActions$lambda$0));
        return SequencesKt.sequenceOf((Object)action);
    }

    private static final Unit createActions$lambda$0(WebStructureUsagesCollector.Origin origin, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        WebStructureUsagesCollector.INSTANCE.logNavigateBack(origin, mouseEvent);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/endpoints/webStructure/GoToParentContextActionFactory$NavigateBackNavigationHandler;", "Lcom/intellij/python/endpoints/webStructure/WebStructureNavigationHandler;", "<init>", "()V", "navigate", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "element", "Lcom/intellij/psi/PsiElement;", "runtimeWebApplicationContexts", "", "Lcom/intellij/python/endpoints/ModuleWebApplication;", "Lcom/intellij/python/endpoints/UrlPathsMethods;", "Lcom/intellij/python/endpoints/WebApplicationContexts;", "intellij.python.endpoints"})
    public static final class NavigateBackNavigationHandler
    implements WebStructureNavigationHandler {
        @NotNull
        public static final NavigateBackNavigationHandler INSTANCE = new NavigateBackNavigationHandler();

        private NavigateBackNavigationHandler() {
        }

        @Override
        public void navigate(@NotNull MouseEvent mouseEvent, @NotNull PsiElement element, @NotNull Map<ModuleWebApplication, UrlPathsMethods> runtimeWebApplicationContexts) {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(runtimeWebApplicationContexts, (String)"runtimeWebApplicationContexts");
            PsiFile file = element.getContainingFile();
            Editor[] editorArray = EditorFactory.getInstance().getEditors(file.getFileDocument());
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
            Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            NavigateBackGotoTargetHandler handler = new NavigateBackGotoTargetHandler(runtimeWebApplicationContexts, element);
            handler.invoke(element.getProject(), editor2, file);
        }
    }
}

