/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.duplocator;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.duplocator.PyDuplocatorSettings;
import com.intellij.python.pro.duplocator.PyTreeHasher;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyFileImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PySpecificHasher
extends NodeSpecificHasher {
    private final TreeHasher myTreeHasher;
    private final PyDuplocatorSettings mySettings;

    public PySpecificHasher(@NotNull PyDuplocatorSettings settings, @NotNull FragmentsCollector callback, boolean forIndexing) {
        if (settings == null) {
            PySpecificHasher.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            PySpecificHasher.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
        this.myTreeHasher = new PyTreeHasher(callback, settings, forIndexing);
    }

    public int getNodeCost(PsiElement node) {
        if (node instanceof PyImportStatementBase || node instanceof PyStatementList || node instanceof PyDocStringOwner || node instanceof PyReturnStatement || node instanceof PyParenthesizedExpression || node instanceof PyExpressionStatement) {
            return 0;
        }
        return 1;
    }

    public int getNodeHash(PsiElement node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof PyBinaryExpression) {
            PyElementType operator = ((PyBinaryExpression)node).getOperator();
            return operator == null ? 0 : operator.toString().hashCode();
        }
        if (node instanceof PyAssignmentStatement) {
            return PyTokenTypes.EQ.toString().hashCode();
        }
        if (node instanceof PyAugAssignmentStatement) {
            PsiElement operation = ((PyAugAssignmentStatement)node).getOperation();
            return operation == null ? 0 : operation.toString().hashCode();
        }
        if (node instanceof PyClass) {
            String name = ((PyClass)node).getName();
            return name == null ? 0 : name.hashCode();
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)node, PyDocStringOwner.class);
        String nodeText = node.getText();
        PsiElement nodeParent = node.getParent();
        if (node instanceof PyQualifiedExpression && !(nodeParent instanceof PyQualifiedExpression)) {
            if (nodeParent instanceof PyCallExpression) {
                if (!this.mySettings.DISTINGUISH_FUNCTIONS || !this.mySettings.DISTINGUISH_METHODS) {
                    return 0;
                }
            } else {
                if (parent instanceof PyFile && !this.mySettings.DISTINGUISH_VARIABLES) {
                    return 0;
                }
                if (parent instanceof PyClass && !this.mySettings.DISTINGUISH_FIELDS) {
                    return 0;
                }
                if (parent instanceof PyFunction) {
                    PyExpression qualifier;
                    if ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PyDocStringOwner.class)) instanceof PyClass ? ((qualifier = ((PyQualifiedExpression)node).getQualifier()) != null && "self".equals(qualifier.getText()) ? !this.mySettings.DISTINGUISH_FIELDS : !this.mySettings.DISTINGUISH_VARIABLES) : !this.mySettings.DISTINGUISH_VARIABLES) {
                        return 0;
                    }
                    return nodeText.hashCode();
                }
            }
            return nodeText.hashCode();
        }
        if (node instanceof PyStringLiteralExpression) {
            if (!this.mySettings.DISTINGUISH_LITERALS) {
                return 0;
            }
            return ((PyStringLiteralExpression)node).getStringValue().hashCode();
        }
        if (node instanceof PyLiteralExpression) {
            if (!this.mySettings.DISTINGUISH_LITERALS) {
                return 0;
            }
            return nodeText.hashCode();
        }
        if (node instanceof PyParameter) {
            if (!this.mySettings.DISTINGUISH_FUNCTIONS && !this.mySettings.DISTINGUISH_VARIABLES) {
                return 0;
            }
            return nodeText.hashCode();
        }
        if (node instanceof PyFunction) {
            if (!this.mySettings.DISTINGUISH_FUNCTIONS || !this.mySettings.DISTINGUISH_METHODS) {
                return 0;
            }
            String name = ((PyFunction)node).getName();
            if (name == null) {
                return 0;
            }
            int hash = name.hashCode();
            PyParameterList parameterList = ((PyFunction)node).getParameterList();
            for (PyParameter parameter : parameterList.getParameters()) {
                String parameterName = parameter.getName();
                if (!this.mySettings.DISTINGUISH_VARIABLES || parameterName == null) continue;
                hash = hash * 31 + parameterName.hashCode();
            }
            return hash;
        }
        return 0;
    }

    public List<PsiElement> getNodeChildren(PsiElement node) {
        if (node == null || node instanceof PyImportStatementBase) {
            return Collections.emptyList();
        }
        PsiElement[] elements = node.getChildren();
        ArrayList<PsiElement> selected = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            if (!PySpecificHasher.isAllowed(element)) continue;
            selected.add(PySpecificHasher.skipDummy(element));
        }
        return selected;
    }

    private static PsiElement skipDummy(PsiElement element) {
        PyStatement[] statements;
        if (element instanceof PyExpressionStatement) {
            return ((PyExpressionStatement)element).getExpression();
        }
        if (element instanceof PyStatementList && (statements = ((PyStatementList)element).getStatements()).length == 1) {
            return PySpecificHasher.skipDummy((PsiElement)statements[0]);
        }
        return element;
    }

    private static boolean isAllowed(PsiElement element) {
        return !(element instanceof PyImportStatementBase);
    }

    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            PySpecificHasher.$$$reportNull$$$0(2);
        }
        if (node2 == null) {
            PySpecificHasher.$$$reportNull$$$0(3);
        }
        if (!node1.getClass().equals(node2.getClass())) {
            return false;
        }
        if (node1 instanceof PyBinaryExpression && ((PyBinaryExpression)node1).getOperator() != ((PyBinaryExpression)node2).getOperator()) {
            return false;
        }
        if (node1 instanceof PyAugAssignmentStatement && ((PyAugAssignmentStatement)node1).getOperation() != ((PyAugAssignmentStatement)node2).getOperation()) {
            return false;
        }
        PsiElement parent = node1.getParent();
        if (node1 instanceof PyReferenceExpression && !node1.getText().equals(node2.getText()) && (parent instanceof PyFile && this.mySettings.DISTINGUISH_VARIABLES || parent instanceof PyClass && this.mySettings.DISTINGUISH_FIELDS || parent instanceof PyFunction && !this.mySettings.DISTINGUISH_VARIABLES)) {
            return false;
        }
        if (node1 instanceof PyStringLiteralExpression && this.mySettings.DISTINGUISH_LITERALS && !((PyStringLiteralExpression)node1).getStringValue().equals(((PyStringLiteralExpression)node2).getStringValue())) {
            return false;
        }
        if (node1 instanceof PyFunction && !((PyFunction)node1).getName().equals(((PyFunction)node2).getName()) && (this.mySettings.DISTINGUISH_FUNCTIONS || this.mySettings.DISTINGUISH_METHODS && parent instanceof PyClass)) {
            return false;
        }
        if (node1 instanceof PyLiteralExpression && this.mySettings.DISTINGUISH_LITERALS && !node1.getText().equals(node2.getText())) {
            return false;
        }
        if (node1 instanceof PyFunction) {
            PyParameter[] list2;
            if (!((PyFunction)node1).getName().equals(((PyFunction)node2).getName())) {
                return false;
            }
            PyParameter[] list1 = ((PyFunction)node1).getParameterList().getParameters();
            if (list1.length != (list2 = ((PyFunction)node2).getParameterList().getParameters()).length) {
                return false;
            }
            if (this.mySettings.DISTINGUISH_VARIABLES) {
                for (int i = 0; i != list1.length; ++i) {
                    PyParameter parameter1 = list1[i];
                    PyParameter parameter2 = list2[i];
                    if (parameter1.getName().equals(parameter2.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    public void visitNode(@NotNull PsiElement node) {
        PsiFile psiFile;
        if (node == null) {
            PySpecificHasher.$$$reportNull$$$0(4);
        }
        if ((psiFile = node.getContainingFile().getViewProvider().getPsi((Language)PythonLanguage.getInstance())) != null && psiFile.getFileType() == PythonFileType.INSTANCE) {
            for (PyStatement element : ((PyFileImpl)psiFile).getStatements()) {
                if (element instanceof PyImportStatementBase) continue;
                this.myTreeHasher.hash(PySpecificHasher.skipDummy((PsiElement)element), (NodeSpecificHasher)this);
            }
        }
    }

    public void hashingFinished() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/duplocator/PySpecificHasher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesEqual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

