/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.profiler.CallStat;
import com.intellij.python.profiler.CallTreeNodeData;
import com.intellij.python.profiler.CallTreeStat;
import com.intellij.python.profiler.CallTreeStatData;
import com.intellij.python.profiler.FuncStat;
import com.intellij.python.profiler.Function;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.FunctionStatData;
import com.intellij.python.profiler.ProfileStatData;
import com.intellij.python.profiler.Stats;
import com.intellij.python.profiler.TreeStats;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a8\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a?\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aP\u0010\u0019\u001a\u00020\u001a2\b\u0010\n\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2$\u0010\u001d\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u001f\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0013\u001a\u00020\u0014\u001aG\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020!0$j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020!`%2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010&\u001a#\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010)\u001a\u0018\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u0010\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0002\u001a\u0010\u0010-\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u0018\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a0\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\u0006\u00101\u001a\u00020\t\u001a \u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u00102\u001a\u000203\u001a \u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u00104\u001a\u000205\u001a\u0010\u00106\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u001c\u00107\u001a\u00020\u00012\b\b\u0001\u00108\u001a\u00020\u00012\b\b\u0001\u0010(\u001a\u00020\u0001H\u0007\u001a\u0016\u00109\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010:\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"EMPTY_STRING", "", "DEFAULT_THREAD_NAME", "DEFAULT_THREAD_ID", "createCallTree", "Lcom/intellij/python/profiler/CallTreeNodeData;", "tree", "Lcom/intellij/python/profiler/CallTreeStat;", "total", "", "parent", "samplingInterval", "", "stats", "Lcom/intellij/python/profiler/Stats;", "createCallStatsList", "", "Lcom/intellij/python/profiler/FunctionStat;", "Lcom/intellij/python/profiler/TreeStats;", "profileStats", "Lcom/intellij/python/profiler/ProfileStatData;", "projectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/python/profiler/Stats;Lcom/intellij/python/profiler/TreeStats;Lcom/intellij/python/profiler/ProfileStatData;[Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "walkTree", "", "Lcom/intellij/python/profiler/CallTreeStatData;", "node", "idToCallFuncStat", "", "Lkotlin/Triple;", "hasOnlyInternalCallers", "", "stat", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "(Lcom/intellij/python/profiler/FunctionStat;Ljava/util/HashMap;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isProjectRoot", "file", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isEntryPoint", "name", "isInternalCall", "isHelper", "allowedFunctionName", "functionName", "callId", "line", "call", "Lcom/intellij/python/profiler/CallStat;", "funcStat", "Lcom/intellij/python/profiler/FuncStat;", "moduleName", "functionPresentableName", "funcName", "hitsToOwnTimeMs", "hits", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nProfileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/ProfileDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,387:1\n1586#2:388\n1661#2,3:389\n1220#2,2:392\n1249#2,4:394\n777#2:398\n873#2,2:399\n777#2:401\n873#2,2:402\n13225#3,2:404\n*S KotlinDebug\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/ProfileDataKt\n*L\n135#1:388\n135#1:389,3\n137#1:392,2\n137#1:394,4\n154#1:398\n154#1:399,2\n160#1:401\n160#1:402,2\n235#1:404,2\n*E\n"})
public final class ProfileDataKt {
    @NotNull
    private static final String EMPTY_STRING = "";
    @NotNull
    public static final String DEFAULT_THREAD_NAME = "MainThread";
    @NotNull
    public static final String DEFAULT_THREAD_ID = "0";

    private static final CallTreeNodeData createCallTree(CallTreeStat tree, int total, CallTreeStat parent, double samplingInterval, Stats stats) {
        if (tree == null) {
            return null;
        }
        double perc = 1.0 * (double)tree.count / (double)total;
        CallTreeStat callTreeStat = parent;
        double percOfParent = 1.0 * (double)tree.count / (double)(callTreeStat != null ? callTreeStat.count : tree.count);
        CallTreeNodeData node = new CallTreeNodeData(tree, perc, percOfParent, samplingInterval, stats);
        for (CallTreeStat child : tree.children) {
            CallTreeNodeData childNode = ProfileDataKt.createCallTree(child, total, tree, samplingInterval, stats);
            if (childNode == null) continue;
            node.addChild(childNode);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FunctionStat> createCallStatsList(Stats stats, TreeStats tree, ProfileStatData profileStats, VirtualFile[] projectRoots) {
        if (tree != null) {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
            Map idToCallFuncStat = hashMap;
            ProfileDataKt.walkTree(null, tree.call_tree, tree.sampling_interval, idToCallFuncStat, profileStats);
            return CollectionsKt.toList((Iterable)idToCallFuncStat.values());
        }
        if (stats != null) {
            List list;
            boolean bl;
            Iterator<FuncStat> $this$associateByTo$iv$iv;
            Iterator funcStat;
            Object object;
            void $this$mapTo$iv$iv;
            List<Function> list2 = stats.getFunc_stats();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getFunc_stats(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Function function = (Function)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                FuncStat funcStat2 = ((Function)((Object)funcStat)).func_stat;
                Intrinsics.checkNotNullExpressionValue((Object)funcStat2, (String)"func_stat");
                object.add(new FunctionStatData(funcStat2, profileStats, null, null, 12, null));
            }
            List callsList = (List)destination$iv$iv;
            Iterable $this$associateBy$iv = callsList;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo232 = $this$associateBy$iv;
            Map map = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            funcStat = $this$associateByTo$iv$iv.iterator();
            while (funcStat.hasNext()) {
                void it;
                Object element$iv$iv = funcStat.next();
                FunctionStatData functionStatData = (FunctionStatData)element$iv$iv;
                object = map;
                boolean bl3 = false;
                object.put(ProfileDataKt.callId((CallStat)it), element$iv$iv);
            }
            Map idToCallFuncStat = map;
            for (Function f : stats.func_stats) {
                FuncStat funcStat3 = f.func_stat;
                Intrinsics.checkNotNullExpressionValue((Object)funcStat3, (String)"func_stat");
                FunctionStatData callStat = (FunctionStatData)idToCallFuncStat.get(ProfileDataKt.callId(funcStat3));
                if (callStat == null) continue;
                for (FuncStat funcStat4 : f.getCallers()) {
                    Intrinsics.checkNotNull((Object)funcStat4);
                    FunctionStatData caller = (FunctionStatData)idToCallFuncStat.get(ProfileDataKt.callId(funcStat4));
                    if (caller == null) continue;
                    callStat.addCaller(caller);
                }
            }
            HashMap<FunctionStat, Boolean> map2 = new HashMap<FunctionStat, Boolean>();
            Iterable $this$filter$iv = callsList;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : iterable2) {
                FunctionStatData stat = (FunctionStatData)element$iv$iv;
                bl = false;
                if (!(ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile()) && !ProfileDataKt.hasOnlyInternalCallers(stat, map2, projectRoots))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List filteredCallsList = (List)destination$iv$iv3;
            if (!filteredCallsList.isEmpty()) {
                list = filteredCallsList;
            } else {
                $this$filter$iv = callsList;
                $i$f$filter = false;
                Iterable iterable3 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : iterable3) {
                    FunctionStatData stat = (FunctionStatData)element$iv$iv;
                    bl = false;
                    if (!ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list = (List)destination$iv$iv2;
            }
            return list;
        }
        return null;
    }

    public static final void walkTree(@Nullable CallTreeStatData parent, @Nullable CallTreeStat node, double samplingInterval, @NotNull Map<Triple<String, String, Integer>, CallTreeStatData> idToCallFuncStat, @NotNull ProfileStatData profileStats) {
        Intrinsics.checkNotNullParameter(idToCallFuncStat, (String)"idToCallFuncStat");
        Intrinsics.checkNotNullParameter((Object)profileStats, (String)"profileStats");
        if (node == null) {
            return;
        }
        String string = node.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 4) {
            String funname = (String)parts.get(1);
            String funline = (String)parts.get(2);
            String filename = (String)parts.get(3);
            Triple<String, String, Integer> key = ProfileDataKt.callId(filename, funname, Integer.parseInt(funline));
            CallTreeStatData stat = idToCallFuncStat.get(key);
            if (stat == null) {
                stat = new CallTreeStatData(filename, funname, Integer.parseInt(funline), 0, samplingInterval, profileStats);
                idToCallFuncStat.put(key, stat);
            }
            CallTreeStatData callTreeStatData = stat;
            callTreeStatData.setHits(callTreeStatData.getHits() + node.count);
            if (parent != null) {
                parent.addChild(stat);
                stat.addCaller(parent);
            }
            for (CallTreeStat child : node.children) {
                ProfileDataKt.walkTree(stat, child, samplingInterval, idToCallFuncStat, profileStats);
            }
        }
    }

    private static final boolean hasOnlyInternalCallers(FunctionStat stat, HashMap<FunctionStat, Boolean> map, VirtualFile[] projectRoots) {
        if (map.get(stat) == null) {
            if (ProfileDataKt.isEntryPoint(stat.getName(), stat.getFile()) || ProfileDataKt.isProjectRoot(stat.getFile(), projectRoots)) {
                ((Map)map).put(stat, false);
            } else if (ProfileDataKt.isInternalCall(stat)) {
                ((Map)map).put(stat, true);
            } else {
                ((Map)map).put(stat, true);
            }
            if (!((Collection)stat.getCallers()).isEmpty()) {
                for (FunctionStat c : stat.getCallers()) {
                    if (ProfileDataKt.hasOnlyInternalCallers(c, map, projectRoots)) continue;
                    ((Map)map).put(stat, false);
                    break;
                }
            }
        }
        Boolean bl = map.get(stat);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private static final boolean isProjectRoot(String file, VirtualFile[] projectRoots) {
        boolean bl;
        block1: {
            VirtualFile[] $this$any$iv = projectRoots;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile root = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                String string = FileUtil.toSystemIndependentName((String)file);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
                CharSequence charSequence = string;
                String string2 = FileUtil.toSystemIndependentName((String)root.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isEntryPoint(String name, String file) {
        return Intrinsics.areEqual((Object)"<execfile>", (Object)name) || Intrinsics.areEqual((Object)"<built-in method exec>", (Object)name) || Intrinsics.areEqual((Object)"<built-in method builtins.exec>", (Object)name) || Intrinsics.areEqual((Object)"run", (Object)name) && StringsKt.contains$default((CharSequence)file, (CharSequence)"tcunittest.py", (boolean)false, (int)2, null);
    }

    private static final boolean isInternalCall(FunctionStat stat) {
        return !ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile()) || ProfileDataKt.isHelper(stat.getFile());
    }

    private static final boolean isHelper(String file) {
        return FileUtil.isAncestor((File)PythonHelpersLocator.Companion.getCommunityHelpersRoot().toFile(), (File)new File(file), (boolean)false);
    }

    private static final boolean allowedFunctionName(String functionName, String file) {
        return !ProfileDataKt.isEntryPoint(functionName, file) && !StringsKt.contains$default((CharSequence)functionName, (CharSequence)"_lsprof.Profiler", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)functionName, (Object)"stop_profiling");
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull String file, @NotNull String name, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Triple((Object)file, (Object)name, (Object)line);
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull CallStat call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return new Triple((Object)call.getFile(), (Object)call.getName(), (Object)call.getLine());
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull FuncStat funcStat) {
        Intrinsics.checkNotNullParameter((Object)funcStat, (String)"funcStat");
        return new Triple((Object)funcStat.file, (Object)funcStat.func_name, (Object)funcStat.line);
    }

    private static final String moduleName(String file) {
        String string = PathUtil.getFileName((String)file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public static final String functionPresentableName(@NlsSafe @NotNull String funcName, @NlsSafe @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)funcName, (Object)"<module>") ? ProfileDataKt.moduleName(file) : funcName;
    }

    public static final int hitsToOwnTimeMs(double samplingInterval, int hits) {
        return (int)((double)hits * samplingInterval * (double)1000);
    }

    public static final /* synthetic */ List access$createCallStatsList(Stats stats, TreeStats tree, ProfileStatData profileStats, VirtualFile[] projectRoots) {
        return ProfileDataKt.createCallStatsList(stats, tree, profileStats, projectRoots);
    }

    public static final /* synthetic */ CallTreeNodeData access$createCallTree(CallTreeStat tree, int total, CallTreeStat parent, double samplingInterval, Stats stats) {
        return ProfileDataKt.createCallTree(tree, total, parent, samplingInterval, stats);
    }
}

