/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.ProfilerSessionVirtualFileImpl;
import com.intellij.python.profiler.ProfilerView;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u000b\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J8\u0010 \u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$j\u0002`&2\u0006\u0010'\u001a\u00020(H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/python/profiler/ProfilerSessionEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/python/profiler/ProfilerSessionVirtualFileImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/profiler/ProfilerSessionVirtualFileImpl;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/python/profiler/ProfilerSessionVirtualFileImpl;", "profilerSessionComponent", "Ljavax/swing/JComponent;", "getComponent", "getPreferredFocusedComponent", "getName", "", "setState", "", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "createProfilerSessionComponent", "profileStats", "Lcom/intellij/python/profiler/ProfileStats;", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "parent", "Lcom/intellij/openapi/Disposable;", "intellij.python.profiler"})
public final class ProfilerSessionEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerSessionVirtualFileImpl file;
    @NotNull
    private final JComponent profilerSessionComponent;

    public ProfilerSessionEditor(@NotNull Project project, @NotNull ProfilerSessionVirtualFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.project = project;
        this.file = file;
        this.profilerSessionComponent = this.createProfilerSessionComponent(this.project, this.file.getProfileStats(), this.file.getLocalPathFunction(), (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProfilerSessionVirtualFileImpl getFile() {
        return this.file;
    }

    @NotNull
    public JComponent getComponent() {
        return this.profilerSessionComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.profilerSessionComponent;
    }

    @NotNull
    public String getName() {
        return this.file.getName();
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    public void dispose() {
    }

    private final JComponent createProfilerSessionComponent(Project project, ProfileStats profileStats, Function1<? super Path, ? extends Path> localPathFunction, Disposable parent) {
        JPanel panel = new JPanel(new BorderLayout());
        ProfilerView profileView = new ProfilerView();
        Disposer.register((Disposable)parent, (Disposable)profileView);
        profileView.init(project, profileStats, localPathFunction);
        panel.add(profileView.mainPanel);
        return panel;
    }
}

