/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a8\u0006\u000b"}, d2={"findSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "filename", "", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "intellij.python.profiler"})
public final class VirtualFilesKt {
    @NotNull
    public static final Collection<VirtualFile> findSources(@NotNull Project project, @NotNull String filename, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        Path path2 = Paths.get(filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path filePath2 = (Path)localPathFunction.invoke((Object)path2);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(((Object)filePath2).toString());
        if (virtualFile != null) {
            return CollectionsKt.listOf((Object)virtualFile);
        }
        Object object = ActionsKt.runReadAction(() -> VirtualFilesKt.findSources$lambda$0(filename, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Collection)object;
    }

    private static final Collection findSources$lambda$0(String $filename, Project $project) {
        return FilenameIndex.getVirtualFilesByName((String)$filename, (GlobalSearchScope)GlobalSearchScope.allScope((Project)$project));
    }
}

