/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyHelpersDownload
extends RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(PyHelpersDownload.class);

    private PyHelpersDownload(@Nullable Project project, @Nullable Component component, RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
        super(project, component, RemoteSdkUtil.createHelpersTransferConfig((RemoteCredentials)credentials, (RemoteSdkProperties)sdkProperties));
    }

    private void downloadFromRemote(final List<PathMappingSettings.PathMapping> mappings) {
        String myTitle = PythonRemoteInterpreterBundle.message("python.copying.remote.files", new Object[0]);
        new Task.Backgroundable(this.getProject(), myTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                CredentialsDeployable deployable = new CredentialsDeployable();
                PyHelpersDownload.this.getHelpersTransferConfig().createFileTransferConfig(deployable);
                deployable.setId("CopyFromRemote" + String.valueOf(deployable));
                try {
                    RemoteConnection connection = PyHelpersDownload.this.openConnection(this.getTitle(), (Deployable)deployable, indicator);
                    RemoteTransfer.RemoteSdkExecutionContext context = PyHelpersDownload.this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
                    context.setServerSideModification(false);
                    ArrayList<TransferOperation.Copy> operations = new ArrayList<TransferOperation.Copy>();
                    for (PathMappingSettings.PathMapping mapping : mappings) {
                        FileObject source = connection.resolveFile(mapping.getRemoteRoot());
                        FileObject target = DeploymentPathUtils.getLocalFile((String)mapping.getLocalRoot());
                        operations.add(new TransferOperation.Copy(source, target));
                    }
                    PyHelpersDownload.executeOperationsBatch((ProgressIndicator)indicator, (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
                }
                PyHelpersDownload.this.getHelpersTransferConfig().setHelpersVersionChecked(true);
                snapshot.logResponsivenessSinceCreation("Downloading remote files");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/remoteInterpreter/PyHelpersDownload$1", "run"));
            }
        }.queue();
    }

    public static void downloadFromRemote(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (credentials == null) {
            PyHelpersDownload.$$$reportNull$$$0(0);
        }
        if (sdkProperties == null) {
            PyHelpersDownload.$$$reportNull$$$0(1);
        }
        if (mappings == null) {
            PyHelpersDownload.$$$reportNull$$$0(2);
        }
        new PyHelpersDownload(project, component, credentials, sdkProperties).downloadFromRemote(mappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "credentials";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "mappings";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/remoteInterpreter/PyHelpersDownload";
        objectArray[2] = "downloadFromRemote";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

