/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.powerfuldataviewer.actions.CopyPropertiesAction;
import com.intellij.scientific.tables.utils.ScientificTablesCoroutineKt;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.python.console.PyConsoleProcessHandlers;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataView;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/scientific/PyDataViewToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isConsoleListenerInit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "shouldBeAvailable", "", "initializeDataTab", "addPythonConsoleListener", "addTabConnectedToConsole", "PyTableViewToggleAction", "ChangeContentXDebuggerManagerListener", "intellij.python.scientific"})
public final class PyDataViewToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final AtomicBoolean isConsoleListenerInit = new AtomicBoolean(false);

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.initializeDataTab(project, toolWindow);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    private final void initializeDataTab(Project project, ToolWindow toolWindow) {
        ScientificTablesCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            final /* synthetic */ PyDataViewToolWindowFactory this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        PyDataViewToolWindowFactory.access$addPythonConsoleListener(this.this$0, this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        PyDataView.Companion.getInstance(project).init(toolWindow);
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ChangeContentXDebuggerManagerListener(project));
        Topic topic2 = RunContentManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new RunContentWithExecutorListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void contentSelected(RunContentDescriptor descriptor, Executor executor) {
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                if (!(executor instanceof DefaultDebugExecutor) || descriptor == null) {
                    return;
                }
                ProcessHandler processHandler = descriptor.getProcessHandler();
                if (processHandler == null) {
                    return;
                }
                ProcessHandler handler = processHandler;
                PyDataView.Companion.getInstance(this.$project).updateTabs(handler);
            }
        });
        String string = PyScientificBundle.message("python.sci.resize.automatically", new Object[0]);
        PyTableViewToggleAction autoResizeAction2 = new PyTableViewToggleAction(project, string){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1, "python.debugger.dataView.autoresize");
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.setSelected(e, state);
                PyDataView.Companion.getInstance(this.$project).changeAutoResize(state);
            }
        };
        AnAction[] anActionArray = new AnAction[]{new PyTableViewToggleAction(PyScientificBundle.message("python.sci.colored.by.default", new Object[0]), "datagrid.heatmap.switchedByDefault"), autoResizeAction2, new CopyPropertiesAction()};
        DefaultActionGroup group = new DefaultActionGroup(anActionArray);
        toolWindow.setAdditionalGearActions((ActionGroup)group);
    }

    private final void addPythonConsoleListener(Project project) {
        if (this.isConsoleListenerInit.get()) {
            return;
        }
        this.isConsoleListenerInit.set(true);
        ToolWindow pythonConsole = ToolWindowManager.Companion.getInstance(project).getToolWindow("Python Console");
        if (pythonConsole == null) {
            return;
        }
        ContentManager contentManager = pythonConsole.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.addContentManagerListener(new ContentManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ PyDataViewToolWindowFactory this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PyDataView.Companion.getInstance(this.$project).closeDisconnectedFromConsoleTabs();
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!PyDataView.Companion.getInstance(this.$project).getVisibleTabs().isEmpty()) {
                    return;
                }
                this.this$0.addTabConnectedToConsole(this.$project);
            }
        });
    }

    public final void addTabConnectedToConsole(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance((Project)project);
        if (toolWindow == null) {
            return;
        }
        RunContentDescriptor descriptor = toolWindow.getSelectedContentDescriptor();
        if (descriptor == null) {
            return;
        }
        ProcessHandler handler = descriptor.getProcessHandler();
        if (handler == null) {
            return;
        }
        PydevConsoleCommunication communication = (PydevConsoleCommunication)handler.getUserData(PyConsoleProcessHandlers.pydevConsoleCommunicationKey);
        if (communication != null) {
            PyDataView.Companion.getInstance(project).addTab((PyFrameAccessor)communication);
        }
    }

    public static final /* synthetic */ void access$addPythonConsoleListener(PyDataViewToolWindowFactory $this, Project project) {
        $this.addPythonConsoleListener(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/scientific/PyDataViewToolWindowFactory$ChangeContentXDebuggerManagerListener;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "processStopped", "", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "intellij.python.scientific"})
    private static final class ChangeContentXDebuggerManagerListener
    implements XDebuggerManagerListener {
        @NotNull
        private final Project myProject;

        public ChangeContentXDebuggerManagerListener(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myProject = myProject;
        }

        public void processStopped(@NotNull XDebugProcess debugProcess) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            if (debugProcess instanceof PyDebugProcess) {
                PyDataView tableView = PyDataView.Companion.getInstance(this.myProject);
                ApplicationManager.getApplication().invokeLater(() -> ChangeContentXDebuggerManagerListener.processStopped$lambda$0(tableView, debugProcess), this.myProject.getDisposed());
            }
        }

        private static final boolean processStopped$lambda$0$0(XDebugProcess $debugProcess, PyFrameAccessor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof PyDebugProcess && it == $debugProcess;
        }

        private static final void processStopped$lambda$0(PyDataView $tableView, XDebugProcess $debugProcess) {
            $tableView.closeTabs(arg_0 -> ChangeContentXDebuggerManagerListener.processStopped$lambda$0$0($debugProcess, arg_0));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001e\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/scientific/PyDataViewToolWindowFactory$PyTableViewToggleAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "text", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "myPropertyKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.python.scientific"})
    public static class PyTableViewToggleAction
    extends DumbAwareToggleAction {
        @NotNull
        private final String myPropertyKey;

        public PyTableViewToggleAction(@Nullable String text, @NotNull String myPropertyKey) {
            Intrinsics.checkNotNullParameter((Object)myPropertyKey, (String)"myPropertyKey");
            super(text);
            this.myPropertyKey = myPropertyKey;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            return PropertiesComponent.getInstance((Project)project).getBoolean(this.myPropertyKey, true);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            PropertiesComponent.getInstance((Project)project).setValue(this.myPropertyKey, state, true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

