/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.actions.PyExecuteSelectionAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"isStructuredPyFile", "", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCellText", "", "getCellElement", "Lcom/intellij/psi/PsiElement;", "getValidOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.python.scientific"})
public final class PyCellActionHelperKt {
    public static final boolean isStructuredPyFile(@NotNull AnActionEvent $this$isStructuredPyFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isStructuredPyFile, (String)"<this>");
        Editor editor = (Editor)$this$isStructuredPyFile.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)$this$isStructuredPyFile.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        return PyExecuteSelectionAction.isPython((Editor)editor2) && PyCellUtil.hasCells((PsiFile)file);
    }

    @Nullable
    public static final String getCellText(@NotNull AnActionEvent $this$getCellText) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellText, (String)"<this>");
        PsiElement psiElement = PyCellActionHelperKt.getCellElement($this$getCellText);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        return PyCellUtil.getCodeInCell((PsiElement)PyCellUtil.getCellStart((PsiElement)element));
    }

    @Nullable
    public static final PsiElement getCellElement(@NotNull AnActionEvent $this$getCellElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellElement, (String)"<this>");
        Editor editor = (Editor)$this$getCellElement.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)$this$getCellElement.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        if (!PyExecuteSelectionAction.isPython((Editor)editor2)) {
            return null;
        }
        return PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)PyCellActionHelperKt.getValidOffset(editor2), PsiElement.class, (boolean)false);
    }

    private static final int getValidOffset(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        int documentLength = editor.getDocument().getTextLength();
        boolean bl = 1 <= documentLength ? documentLength <= offset : false;
        if (bl) {
            offset = documentLength - 1;
        }
        return offset;
    }
}

