/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.display;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.project.Project;
import com.intellij.python.scientific.DisplayMessageHandler;
import com.intellij.python.scientific.PythonScientificIcons;
import com.intellij.python.scientific.figures.base.FigureBase;
import com.intellij.python.scientific.figures.base.FigureUtil;
import com.intellij.python.scientific.figures.display.PlotsType;
import com.intellij.python.scientific.figures.interactive.InteractiveFigure;
import com.intellij.util.IconUtil;
import java.awt.image.BufferedImage;
import java.util.Base64;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/python/scientific/figures/display/AltairMessageHandler;", "Lcom/intellij/python/scientific/DisplayMessageHandler;", "<init>", "()V", "getApplicableMessageType", "", "createFigure", "Lcom/intellij/python/scientific/figures/base/FigureBase;", "dataObject", "Lcom/google/gson/JsonObject;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.scientific"})
final class AltairMessageHandler
implements DisplayMessageHandler {
    @Override
    @NotNull
    public String getApplicableMessageType() {
        return PlotsType.ALTAIR.getId();
    }

    @Override
    @NotNull
    public FigureBase createFigure(@NotNull JsonObject dataObject, @NotNull Project project) {
        BufferedImage bufferedImage;
        String imageString;
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String htmlString = dataObject.get("html_string").getAsString();
        JsonElement jsonElement = dataObject.get("image_base64");
        String string = imageString = jsonElement != null ? jsonElement.getAsString() : null;
        if (imageString != null) {
            byte[] bytes = Base64.getDecoder().decode(imageString);
            bufferedImage = FigureUtil.fromRawBytes(bytes);
        } else {
            bufferedImage = null;
        }
        BufferedImage image = bufferedImage;
        Icon icon = IconUtil.toSize((Icon)PythonScientificIcons.Altair, (int)64, (int)48);
        Intrinsics.checkNotNull((Object)htmlString);
        InteractiveFigure figure = InteractiveFigure.Companion.createDefault$default(InteractiveFigure.Companion, htmlString, image, icon, project, null, 16, null);
        return figure;
    }
}

