/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commandCodeProviders;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.scientific.py.tables.api.PyDevdID;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001f\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000e\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/py/tables/commandCodeProviders/Utils;", "", "<init>", "()V", "PYDEVD_TABLE_DIRECTORY", "", "PYDEVD_COMMAND_PREFIX", "PYDEVD_FUNCTION_NAME", "PYDEV_TABLE_EXCEPTION_PREFIX", "getTableFunctionsDefinitions", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "formatPythonCommands", "commands", "", "([Ljava/lang/String;)Ljava/lang/String;", "createCommandTemplateWithPythonTimeout", "tableVariable", "timeout", "", "functionsDefinitions", "commandToExecute", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "commandTemplate", "intellij.scientific.py.tables"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final String PYDEVD_TABLE_DIRECTORY = "pydev/_pydevd_bundle/tables";
    @NotNull
    private static final String PYDEVD_COMMAND_PREFIX = "# pydev_util_command";
    @NotNull
    private static final String PYDEVD_FUNCTION_NAME = "_jb_get_info_command";
    @NotNull
    public static final String PYDEV_TABLE_EXCEPTION_PREFIX = "_jb_get_info_command got exception: ";

    private Utils() {
    }

    @NotNull
    public final String getTableFunctionsDefinitions(@NotNull PyDevdID pydevdId) {
        Intrinsics.checkNotNullParameter((Object)((Object)pydevdId), (String)"pydevdId");
        String tableFileName = "pydev/_pydevd_bundle/tables/pydevd_" + pydevdId.getFileName() + ".py";
        Path tablePath = PythonHelpersLocator.Companion.findPathInHelpers(tableFileName);
        return PathsKt.readText$default((Path)tablePath, null, (int)1, null);
    }

    @NotNull
    public final String formatPythonCommands(String ... commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        return ArraysKt.joinToString$default((Object[])commands, (CharSequence)"\n", null, null, (int)0, null, Utils::formatPythonCommands$lambda$0, (int)30, null);
    }

    @NotNull
    public final String createCommandTemplateWithPythonTimeout(@NotNull String tableVariable, @Nullable Long timeout, @NotNull String functionsDefinitions, @NotNull String commandToExecute) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)functionsDefinitions, (String)"functionsDefinitions");
        Intrinsics.checkNotNullParameter((Object)commandToExecute, (String)"commandToExecute");
        StringBuilder $this$createCommandTemplateWithPythonTimeout_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createCommandTemplateWithPythonTimeout_u24lambda_u240.append(functionsDefinitions).append('\n');
        $this$createCommandTemplateWithPythonTimeout_u24lambda_u240.append(commandToExecute).append('\n');
        String functionsDefinitionsAndCommandToExecute = stringBuilder.toString();
        String string = StringUtil.escapeStringCharacters((String)tableVariable);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeStringCharacters(...)");
        String escapedTableVariable = string;
        String commandsWithIndentation = StringsKt.prependIndent((String)functionsDefinitionsAndCommandToExecute, (String)"    ");
        return "\n# pydev_util_command\n\ndef _jb_get_info_command():\n    initCommandResult = eval(compile(\"" + escapedTableVariable + "\", '<input>', 'eval'), globals(), None)\n" + commandsWithIndentation + "\n\ntry:\n    _jb_get_info_command()\nexcept (RuntimeError, Exception) as e:\n    print('_jb_get_info_command got exception: ', e)\nfinally:\n    del _jb_get_info_command\n";
    }

    @NotNull
    public final String commandTemplate(@NotNull String tableVariable, @NotNull String functionsDefinitions, @NotNull String commandToExecute) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)functionsDefinitions, (String)"functionsDefinitions");
        Intrinsics.checkNotNullParameter((Object)commandToExecute, (String)"commandToExecute");
        StringBuilder $this$commandTemplate_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$commandTemplate_u24lambda_u240.append(functionsDefinitions).append('\n');
        $this$commandTemplate_u24lambda_u240.append(commandToExecute).append('\n');
        String functionsDefinitionsAndCommandToExecute = stringBuilder.toString();
        String string = StringUtil.escapeStringCharacters((String)tableVariable);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeStringCharacters(...)");
        String escapedTableVariable = string;
        String commandsWithIndentation = StringsKt.prependIndent((String)functionsDefinitionsAndCommandToExecute, (String)"    ");
        return "\n# pydev_util_command\n\ndef _jb_get_info_command():\n    initCommandResult = eval(compile(\"" + escapedTableVariable + "\", '<input>', 'eval'), globals(), None)\n" + commandsWithIndentation + "\n\ntry:\n    _jb_get_info_command()\nexcept (RuntimeError, Exception) as e:\n    print('_jb_get_info_command got exception: ', e)\nfinally:\n    del _jb_get_info_command\n";
    }

    private static final CharSequence formatPythonCommands$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "print(" + it + ")";
    }
}

