/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections.tree;

import com.intellij.scientific.py.tables.inspections.api.InspectionTarget;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0003\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo;", "", "<init>", "()V", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "getText", "()Ljava/lang/String;", "GroupNodeInfo", "LeafNodeInfo", "Companion", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$GroupNodeInfo;", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$LeafNodeInfo;", "intellij.scientific.py.tables"})
public abstract sealed class InspectionDisplayInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_PERCENTAGE_FORMAT = "%.1f";

    private InspectionDisplayInfo() {
    }

    @NotNull
    public abstract String getText();

    public /* synthetic */ InspectionDisplayInfo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u0015\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$Companion;", "", "<init>", "()V", "createGroupInfo", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$GroupNodeInfo;", "inspectionName", "", "Lorg/jetbrains/annotations/Nls;", "columnsCount", "", "createLeafInfo", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$LeafNodeInfo;", "label", "Lcom/intellij/openapi/util/NlsSafe;", "rawValue", "tableRowsNumber", "appliesTo", "Lcom/intellij/scientific/py/tables/inspections/api/InspectionTarget;", "shouldShowPercentage", "", "formatWithPercentage", "DEFAULT_PERCENTAGE_FORMAT", "intellij.scientific.py.tables"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroupNodeInfo createGroupInfo(@NotNull String inspectionName, int columnsCount) {
            Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
            String columnLabel = columnsCount == 1 ? "column" : "columns";
            return new GroupNodeInfo(inspectionName, columnsCount + " " + columnLabel);
        }

        @NotNull
        public final LeafNodeInfo createLeafInfo(@NotNull String label, @NotNull String rawValue, int tableRowsNumber, @NotNull InspectionTarget appliesTo) {
            String string;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
            Intrinsics.checkNotNullParameter((Object)((Object)appliesTo), (String)"appliesTo");
            try {
                string = this.shouldShowPercentage(rawValue, tableRowsNumber, appliesTo) ? this.formatWithPercentage(rawValue, tableRowsNumber) : rawValue;
            }
            catch (Exception exception) {
                string = rawValue;
            }
            String processedValue = string;
            return new LeafNodeInfo(label, processedValue);
        }

        private final boolean shouldShowPercentage(String rawValue, int tableRowsNumber, InspectionTarget appliesTo) {
            return appliesTo == InspectionTarget.ROWS && StringsKt.toIntOrNull((String)rawValue) != null && tableRowsNumber > 0;
        }

        private final String formatWithPercentage(String rawValue, int tableRowsNumber) {
            int parsedValue = Integer.parseInt(rawValue);
            float sharePercentage = (float)parsedValue / (float)tableRowsNumber * (float)100;
            Locale locale = Locale.US;
            String string = InspectionDisplayInfo.DEFAULT_PERCENTAGE_FORMAT;
            Object[] objectArray = new Object[]{Float.valueOf(sharePercentage)};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String formattedShare = string2;
            return rawValue + " (" + formattedShare + "%)";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$GroupNodeInfo;", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo;", "inspectionName", "", "Lorg/jetbrains/annotations/Nls;", "columnCount", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getInspectionName", "()Ljava/lang/String;", "getColumnCount", "text", "getText", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.scientific.py.tables"})
    public static final class GroupNodeInfo
    extends InspectionDisplayInfo {
        @NotNull
        private final String inspectionName;
        @NotNull
        private final String columnCount;

        public GroupNodeInfo(@NotNull String inspectionName, @NotNull String columnCount) {
            Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
            Intrinsics.checkNotNullParameter((Object)columnCount, (String)"columnCount");
            super(null);
            this.inspectionName = inspectionName;
            this.columnCount = columnCount;
        }

        @NotNull
        public final String getInspectionName() {
            return this.inspectionName;
        }

        @NotNull
        public final String getColumnCount() {
            return this.columnCount;
        }

        @Override
        @NotNull
        public String getText() {
            return this.inspectionName;
        }

        @NotNull
        public final String component1() {
            return this.inspectionName;
        }

        @NotNull
        public final String component2() {
            return this.columnCount;
        }

        @NotNull
        public final GroupNodeInfo copy(@NotNull String inspectionName, @NotNull String columnCount) {
            Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
            Intrinsics.checkNotNullParameter((Object)columnCount, (String)"columnCount");
            return new GroupNodeInfo(inspectionName, columnCount);
        }

        public static /* synthetic */ GroupNodeInfo copy$default(GroupNodeInfo groupNodeInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = groupNodeInfo.inspectionName;
            }
            if ((n & 2) != 0) {
                string2 = groupNodeInfo.columnCount;
            }
            return groupNodeInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GroupNodeInfo(inspectionName=" + this.inspectionName + ", columnCount=" + this.columnCount + ")";
        }

        public int hashCode() {
            int result = this.inspectionName.hashCode();
            result = result * 31 + this.columnCount.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupNodeInfo)) {
                return false;
            }
            GroupNodeInfo groupNodeInfo = (GroupNodeInfo)other;
            if (!Intrinsics.areEqual((Object)this.inspectionName, (Object)groupNodeInfo.inspectionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.columnCount, (Object)groupNodeInfo.columnCount);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo$LeafNodeInfo;", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionDisplayInfo;", "columnName", "", "Lcom/intellij/openapi/util/NlsSafe;", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getColumnName", "()Ljava/lang/String;", "getValue", "text", "getText", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.scientific.py.tables"})
    public static final class LeafNodeInfo
    extends InspectionDisplayInfo {
        @NotNull
        private final String columnName;
        @NotNull
        private final String value;

        public LeafNodeInfo(@NotNull String columnName, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(null);
            this.columnName = columnName;
            this.value = value2;
        }

        @NotNull
        public final String getColumnName() {
            return this.columnName;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getText() {
            return this.columnName;
        }

        @NotNull
        public final String component1() {
            return this.columnName;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final LeafNodeInfo copy(@NotNull String columnName, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new LeafNodeInfo(columnName, value2);
        }

        public static /* synthetic */ LeafNodeInfo copy$default(LeafNodeInfo leafNodeInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = leafNodeInfo.columnName;
            }
            if ((n & 2) != 0) {
                string2 = leafNodeInfo.value;
            }
            return leafNodeInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "LeafNodeInfo(columnName=" + this.columnName + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.columnName.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LeafNodeInfo)) {
                return false;
            }
            LeafNodeInfo leafNodeInfo = (LeafNodeInfo)other;
            if (!Intrinsics.areEqual((Object)this.columnName, (Object)leafNodeInfo.columnName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)leafNodeInfo.value);
        }
    }
}

