/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public abstract class BaseLineFilter
extends CoverageFilter {
    private boolean myHasInstructions;
    private int myCurrentLine = -1;
    private static final int DEBUG_LINE = -1;
    private static final Class<?> DEBUG_FILTER_CLASS = BaseLineFilter.class;

    private void tryRemoveLine() {
        if (this.myCurrentLine != -1 && !this.myHasInstructions && this.shouldRemoveLine()) {
            this.myContext.removeLine(this.myCurrentLine);
            this.myCurrentLine = -1;
            this.onLineRemoved();
        }
    }

    protected abstract boolean shouldRemoveLine();

    protected void onLineRemoved() {
    }

    protected boolean hasInstructions() {
        return this.myHasInstructions;
    }

    protected void setHasInstructions() {
        this.myHasInstructions = true;
    }

    protected int getCurrentLine() {
        return this.myCurrentLine;
    }

    protected boolean wasLineSeenBefore() {
        return this.myContext.getLineData(this.myCurrentLine) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.tryRemoveLine();
        this.myCurrentLine = line;
        this.myHasInstructions = this.wasLineSeenBefore();
        super.visitLineNumber((int)var1_1, (Label)var2_2);
    }

    @Override
    public void visitEnd() {
        this.tryRemoveLine();
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitMethodInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(var1_1);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn((int)var1_1);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        super.visitJumpInsn((int)var1_1, (Label)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVarInsn(int opcode, int varIndex) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }
}

