/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui.painter.hints;

import androidx.compose.runtime.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.ui.painter.PainterProviderScope;
import org.jetbrains.jewel.ui.painter.PainterSvgPatchHint;
import org.jetbrains.jewel.ui.painter.hints.CssClassAttributesCache;
import org.jetbrains.jewel.ui.painter.hints.CssParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ExperimentalJewelApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\u0005*\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0012*\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0005*\u00020\bH\u0002J\f\u0010\u0016\u001a\u00020\u0005*\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/EmbeddedToInlineCssStyleSvgPatchHint;", "Lorg/jetbrains/jewel/ui/painter/PainterSvgPatchHint;", "<init>", "()V", "patch", "", "Lorg/jetbrains/jewel/ui/painter/PainterProviderScope;", "element", "Lorg/w3c/dom/Element;", "inlineStyleDeclarations", "cache", "Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache;", "parser", "Lorg/jetbrains/jewel/ui/painter/hints/CssParser;", "mergeStylePropertiesFromCssClasses", "", "", "classNames", "", "getElementsWithAttribute", "attributeName", "removeAllStyleElements", "removeOrphanedClassAttributes", "intellij.platform.jewel.ui"})
@ApiStatus.Experimental
@Immutable
@SourceDebugExtension(value={"SMAP\nEmbeddedToInlineCssStyleSvgPatchHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedToInlineCssStyleSvgPatchHint.kt\norg/jetbrains/jewel/ui/painter/hints/EmbeddedToInlineCssStyleSvgPatchHint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n777#2:417\n873#2,2:418\n1#3:420\n*S KotlinDebug\n*F\n+ 1 EmbeddedToInlineCssStyleSvgPatchHint.kt\norg/jetbrains/jewel/ui/painter/hints/EmbeddedToInlineCssStyleSvgPatchHint\n*L\n164#1:417\n164#1:418,2\n*E\n"})
public final class EmbeddedToInlineCssStyleSvgPatchHint
implements PainterSvgPatchHint {
    @NotNull
    public static final EmbeddedToInlineCssStyleSvgPatchHint INSTANCE = new EmbeddedToInlineCssStyleSvgPatchHint();
    public static final int $stable;

    private EmbeddedToInlineCssStyleSvgPatchHint() {
    }

    @Override
    public void patch(@NotNull PainterProviderScope $this$patch, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)$this$patch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        NodeList styleElements = element.getElementsByTagName("style");
        if (styleElements.getLength() == 0) {
            return;
        }
        CssParser parser = new CssParser();
        Intrinsics.checkNotNull((Object)styleElements);
        CssClassAttributesCache cache = CssClassAttributesCache.Companion.from(styleElements, parser);
        if (cache.isEmpty()) {
            this.removeAllStyleElements(element);
            this.removeOrphanedClassAttributes(element);
            return;
        }
        this.inlineStyleDeclarations(element, cache, parser);
    }

    /*
     * WARNING - void declaration
     */
    private final void inlineStyleDeclarations(Element $this$inlineStyleDeclarations, CssClassAttributesCache cache, CssParser parser) {
        String classAttributeName = "class";
        String styleAttributeName = "style";
        for (Element element : this.getElementsWithAttribute($this$inlineStyleDeclarations, classAttributeName)) {
            void $this$filterTo$iv$iv;
            int n;
            if (!element.hasAttribute(classAttributeName)) continue;
            String classAttribute = element.getAttribute(classAttributeName);
            Intrinsics.checkNotNull((Object)classAttribute);
            if (StringsKt.isBlank((CharSequence)classAttribute)) {
                element.removeAttribute(classAttributeName);
                continue;
            }
            Regex regex = new Regex("\\s+");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)classAttribute)).toString();
            List classNames = regex.split(charSequence, n = 0);
            Map<String, String> classStyleProperties = this.mergeStylePropertiesFromCssClasses(classNames, cache);
            if (classStyleProperties.isEmpty()) {
                element.removeAttribute(classAttributeName);
                continue;
            }
            Map existingDomStyleProperties = new LinkedHashMap();
            String existingDomStyle = element.getAttribute(styleAttributeName);
            Intrinsics.checkNotNull((Object)existingDomStyle);
            if (((CharSequence)existingDomStyle).length() > 0) {
                existingDomStyleProperties.putAll(parser.parseInlineStyle(existingDomStyle));
            }
            String classStyleValue = CollectionsKt.joinToString$default((Iterable)classStyleProperties.entrySet(), (CharSequence)";", null, null, (int)0, null, EmbeddedToInlineCssStyleSvgPatchHint::inlineStyleDeclarations$lambda$0, (int)30, null);
            String existingDomStyleValue = CollectionsKt.joinToString$default((Iterable)existingDomStyleProperties.entrySet(), (CharSequence)";", null, null, (int)0, null, EmbeddedToInlineCssStyleSvgPatchHint::inlineStyleDeclarations$lambda$1, (int)30, null);
            Object[] objectArray = new String[]{classStyleValue, existingDomStyleValue};
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String styleValue = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
            element.setAttribute(styleAttributeName, styleValue);
            element.removeAttribute(classAttributeName);
        }
        this.removeAllStyleElements($this$inlineStyleDeclarations);
    }

    private final Map<String, String> mergeStylePropertiesFromCssClasses(List<String> classNames, CssClassAttributesCache cache) {
        Map mergedStyles = new LinkedHashMap();
        for (String className : classNames) {
            Map<String, String> classStyleProperties = cache.getCssPropertiesFor(className);
            if (classStyleProperties == null) continue;
            mergedStyles.putAll(classStyleProperties);
        }
        return mergedStyles;
    }

    private final List<Element> getElementsWithAttribute(Element $this$getElementsWithAttribute, String attributeName) {
        List list;
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object object = xPath.evaluate("//*[@" + attributeName + "]", $this$getElementsWithAttribute, XPathConstants.NODESET);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
        NodeList eligibleNodes = (NodeList)object;
        List $this$getElementsWithAttribute_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = eligibleNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = eligibleNodes.item(i);
            boolean bl2 = false;
            if (!(node instanceof Element)) continue;
            $this$getElementsWithAttribute_u24lambda_u240.add(node);
        }
        return CollectionsKt.build((List)list);
    }

    private final void removeAllStyleElements(Element $this$removeAllStyleElements) {
        NodeList styleElements = $this$removeAllStyleElements.getElementsByTagName("style");
        for (int i = styleElements.getLength() - 1; -1 < i; --i) {
            Node styleElement = styleElements.item(i);
            Node node = styleElement.getParentNode();
            if (node == null) continue;
            node.removeChild(styleElement);
        }
    }

    private final void removeOrphanedClassAttributes(Element $this$removeOrphanedClassAttributes) {
        String classAttributeName = "class";
        for (Element element : this.getElementsWithAttribute($this$removeOrphanedClassAttributes, classAttributeName)) {
            if (!element.hasAttribute(classAttributeName)) continue;
            element.removeAttribute(classAttributeName);
        }
    }

    private static final CharSequence inlineStyleDeclarations$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + ":" + it.getValue();
    }

    private static final CharSequence inlineStyleDeclarations$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + ":" + it.getValue();
    }
}

