/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.css.inspections.invalid.CssValueInspectionUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidPropertyValueInspection
extends CssBaseInspection {
    private static final CssPropertyInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssPropertyInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(this){

            public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
                Collection descriptors;
                if (declaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((descriptors = CssPsiUtil.getFilteredPropertyDescriptors((CssDeclaration)declaration)).isEmpty()) {
                    return;
                }
                CssValueInspectionUtil.inspectCssValueAgainstDescriptors(descriptors, (CssValueOwner)declaration, holder, "css.inspections.property.mismatched.values", INVALID_VALUE_RANGE_PROVIDER, true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$1", "visitCssDeclaration"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection", "buildVisitor"));
    }

    private static final class CssPropertyInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssPropertyInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            if (valueOwner instanceof CssDeclaration) {
                int endOfValue;
                int startOfInvalidElements;
                TextRange range;
                CssDeclaration declaration = (CssDeclaration)valueOwner;
                TextRange declarationTextRange = declaration.getTextRange();
                int declarationStartOffset = declarationTextRange.getStartOffset();
                if (lastMatchedElement != null && !(range = TextRange.create((int)(startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset()), (int)(endOfValue = Math.max(declaration.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)))).isEmpty()) {
                    return range.shiftRight(-declarationStartOffset);
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$CssPropertyInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

