/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByCharRt;
import com.intellij.diff.comparison.ByLineRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.util.IntPair;
import com.intellij.util.fastutil.ints.IntList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0002\u001d\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0004J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H$J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H$J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diff/comparison/ChangeCorrector;", "", "myLength1", "", "myLength2", "myChanges", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "myIndicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(IILcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "getMyIndicator", "()Lcom/intellij/diff/comparison/CancellationChecker;", "myBuilder", "Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder;", "getMyBuilder", "()Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder;", "build", "execute", "", "matchGap", "start1", "end1", "start2", "end2", "getOriginalRange1", "Lcom/intellij/util/IntPair;", "index", "getOriginalRange2", "DefaultCharChangeCorrector", "SmartLineChangeCorrector", "intellij.platform.util.diff"})
public abstract class ChangeCorrector {
    private final int myLength1;
    private final int myLength2;
    @NotNull
    private final FairDiffIterable myChanges;
    @NotNull
    private final CancellationChecker myIndicator;
    @NotNull
    private final DiffIterableUtil.ChangeBuilder myBuilder;

    public ChangeCorrector(int myLength1, int myLength2, @NotNull FairDiffIterable myChanges, @NotNull CancellationChecker myIndicator) {
        Intrinsics.checkNotNullParameter((Object)myChanges, (String)"myChanges");
        Intrinsics.checkNotNullParameter((Object)myIndicator, (String)"myIndicator");
        this.myLength1 = myLength1;
        this.myLength2 = myLength2;
        this.myChanges = myChanges;
        this.myIndicator = myIndicator;
        this.myBuilder = new DiffIterableUtil.ChangeBuilder(this.myLength1, this.myLength2);
    }

    @NotNull
    protected final CancellationChecker getMyIndicator() {
        return this.myIndicator;
    }

    @NotNull
    protected final DiffIterableUtil.ChangeBuilder getMyBuilder() {
        return this.myBuilder;
    }

    @NotNull
    public final FairDiffIterable build() {
        this.execute();
        return DiffIterableUtil.fair(this.myBuilder.finish());
    }

    protected final void execute() {
        int last1 = 0;
        int last2 = 0;
        for (Range ch : this.myChanges.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                IntPair range1 = this.getOriginalRange1(ch.start1 + i);
                IntPair range2 = this.getOriginalRange2(ch.start2 + i);
                int start1 = range1.first;
                int start2 = range2.first;
                int end1 = range1.second;
                int end2 = range2.second;
                this.matchGap(last1, start1, last2, start2);
                this.myBuilder.markEqual(start1, start2, end1, end2);
                last1 = end1;
                last2 = end2;
            }
        }
        this.matchGap(last1, this.myLength1, last2, this.myLength2);
    }

    protected abstract void matchGap(int var1, int var2, int var3, int var4);

    @NotNull
    protected abstract IntPair getOriginalRange1(int var1);

    @NotNull
    protected abstract IntPair getOriginalRange2(int var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector;", "Lcom/intellij/diff/comparison/ChangeCorrector;", "myCodePoints1", "Lcom/intellij/diff/comparison/ByCharRt$CodePointsOffsets;", "myCodePoints2", "myText1", "", "myText2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Lcom/intellij/diff/comparison/ByCharRt$CodePointsOffsets;Lcom/intellij/diff/comparison/ByCharRt$CodePointsOffsets;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "matchGap", "", "start1", "", "end1", "start2", "end2", "getOriginalRange1", "Lcom/intellij/util/IntPair;", "index", "getOriginalRange2", "intellij.platform.util.diff"})
    public static final class DefaultCharChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final ByCharRt.CodePointsOffsets myCodePoints1;
        @NotNull
        private final ByCharRt.CodePointsOffsets myCodePoints2;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public DefaultCharChangeCorrector(@NotNull ByCharRt.CodePointsOffsets myCodePoints1, @NotNull ByCharRt.CodePointsOffsets myCodePoints2, @NotNull CharSequence myText1, @NotNull CharSequence myText2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)myCodePoints1, (String)"myCodePoints1");
            Intrinsics.checkNotNullParameter((Object)myCodePoints2, (String)"myCodePoints2");
            Intrinsics.checkNotNullParameter((Object)myText1, (String)"myText1");
            Intrinsics.checkNotNullParameter((Object)myText2, (String)"myText2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(myText1.length(), myText2.length(), changes, indicator);
            this.myCodePoints1 = myCodePoints1;
            this.myCodePoints2 = myCodePoints2;
            this.myText1 = myText1;
            this.myText2 = myText2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            CharSequence inner1 = this.myText1.subSequence(start1, end1);
            CharSequence inner2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable innerChanges = ByCharRt.compare(inner1, inner2, this.getMyIndicator());
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.getMyBuilder().markEqual(start1 + chunk.start1, start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
        }

        @Override
        @NotNull
        protected IntPair getOriginalRange1(int index) {
            int startOffset = this.myCodePoints1.charOffset(index);
            int endOffset = this.myCodePoints1.charOffsetAfter(index);
            return new IntPair(startOffset, endOffset);
        }

        @Override
        @NotNull
        protected IntPair getOriginalRange2(int index) {
            int startOffset = this.myCodePoints2.charOffset(index);
            int endOffset = this.myCodePoints2.charOffsetAfter(index);
            return new IntPair(startOffset, endOffset);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0014J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector;", "Lcom/intellij/diff/comparison/ChangeCorrector;", "myIndexes1", "Lcom/intellij/util/fastutil/ints/IntList;", "myIndexes2", "myLines1", "", "Lcom/intellij/diff/comparison/ByLineRt$Line;", "myLines2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Lcom/intellij/util/fastutil/ints/IntList;Lcom/intellij/util/fastutil/ints/IntList;Ljava/util/List;Ljava/util/List;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "matchGap", "", "start1", "", "end1", "start2", "end2", "getOriginalRange1", "Lcom/intellij/util/IntPair;", "index", "getOriginalRange2", "intellij.platform.util.diff"})
    public static final class SmartLineChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final IntList myIndexes1;
        @NotNull
        private final IntList myIndexes2;
        @NotNull
        private final List<ByLineRt.Line> myLines1;
        @NotNull
        private final List<ByLineRt.Line> myLines2;

        public SmartLineChangeCorrector(@NotNull IntList myIndexes1, @NotNull IntList myIndexes2, @NotNull List<ByLineRt.Line> myLines1, @NotNull List<ByLineRt.Line> myLines2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)myIndexes1, (String)"myIndexes1");
            Intrinsics.checkNotNullParameter((Object)myIndexes2, (String)"myIndexes2");
            Intrinsics.checkNotNullParameter(myLines1, (String)"myLines1");
            Intrinsics.checkNotNullParameter(myLines2, (String)"myLines2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(myLines1.size(), myLines2.size(), changes, indicator);
            this.myIndexes1 = myIndexes1;
            this.myIndexes2 = myIndexes2;
            this.myLines1 = myLines1;
            this.myLines2 = myLines2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myLines1, this.myLines2, start1, start2, end1, end2);
            List<ByLineRt.Line> inner1 = this.myLines1.subList(expand.start1, expand.end1);
            List<ByLineRt.Line> inner2 = this.myLines2.subList(expand.start2, expand.end2);
            FairDiffIterable innerChanges = DiffIterableUtil.diff(inner1, inner2, this.getMyIndicator());
            this.getMyBuilder().markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.getMyBuilder().markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.getMyBuilder().markEqual(expand.end1, expand.end2, end1, end2);
        }

        @Override
        @NotNull
        protected IntPair getOriginalRange1(int index) {
            int offset = this.myIndexes1.get(index);
            return new IntPair(offset, offset + 1);
        }

        @Override
        @NotNull
        protected IntPair getOriginalRange2(int index) {
            int offset = this.myIndexes2.get(index);
            return new IntPair(offset, offset + 1);
        }
    }
}

