/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings.KeyBindingsMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.JsonKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.KeyBindingsParserKt;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/KeyBindingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "file", "Ljava/io/File;", "processKeyBindings", "root", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "toRemove", "", "", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "toAdd", "addCustomShortcut", "foreignCommandId", "foreignShortcuts", "parseShortcuts", "str", "getKeyStroke", "Ljavax/swing/KeyStroke;", "s", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nKeyBindingsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/KeyBindingsParser\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n32#2,2:114\n129#3:116\n158#3,3:117\n129#3:120\n158#3,3:121\n383#4,7:124\n383#4,7:131\n1915#5,2:138\n*S KotlinDebug\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/KeyBindingsParser\n*L\n37#1:114,2\n51#1:116\n51#1:117,3\n52#1:120\n52#1:121,3\n74#1:124,7\n78#1:131,7\n106#1:138,2\n*E\n"})
public final class KeyBindingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final Map<String, List<KeyboardShortcut>> toRemove;
    @NotNull
    private final Map<String, List<KeyboardShortcut>> toAdd;
    @NotNull
    private static final String COMMAND = "command";
    @NotNull
    private static final String KEY = "key";

    public KeyBindingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.toRemove = new LinkedHashMap();
        this.toAdd = new LinkedHashMap();
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            KeyBindingsParserKt.access$getLogger$p().info("Processing a file: " + file);
            JsonNode jsonNode = JsonKt.getVsCodeJsonMapper().readTree(file);
            ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
            if (arrayNode == null) {
                throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.ARRAY).toString());
            }
            ArrayNode root = arrayNode;
            this.processKeyBindings(root);
        }
        catch (Throwable t) {
            KeyBindingsParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processKeyBindings(ArrayNode root) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object commandId;
        Object object;
        Iterator iterator = root.elements();
        if (iterator != null) {
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            while (object.hasNext()) {
                Object element$iv = object.next();
                JsonNode it = (JsonNode)element$iv;
                boolean bl = false;
                try {
                    ObjectNode binding;
                    Object object2;
                    if ((it instanceof ObjectNode ? (ObjectNode)it : null) == null || (object2 = (binding = binding).get(COMMAND)) == null || (object2 = object2.textValue()) == null) continue;
                    commandId = object2;
                    Object object3 = binding.get(KEY);
                    if (object3 == null || (object3 = object3.textValue()) == null) continue;
                    Object shortcuts = object3;
                    this.addCustomShortcut((String)commandId, (String)shortcuts);
                }
                catch (Throwable t) {
                    KeyBindingsParserKt.access$getLogger$p().warn(t);
                }
            }
        }
        Map<String, List<KeyboardShortcut>> $this$map$iv = this.toAdd;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator bl = $this$mapTo$iv$iv2.entrySet().iterator();
        while (bl.hasNext()) {
            Object item$iv$iv;
            commandId = item$iv$iv = bl.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String k = (String)commandId.getKey();
            List v = (List)commandId.getValue();
            collection.add(new KeyBinding(k, v, null, 4, null));
        }
        List t1 = (List)destination$iv$iv;
        Map<String, List<KeyboardShortcut>> $this$map$iv2 = this.toRemove;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            String k = (String)entry.getKey();
            List v = (List)entry.getValue();
            collection.add(new KeyBinding(k, v, null, 4, null));
        }
        List t2 = (List)destination$iv$iv2;
        if (!((Collection)t1).isEmpty() || !((Collection)t2).isEmpty()) {
            Keymap km = this.settings.getKeymap();
            if (km == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            this.settings.setKeymap(new PatchedKeymap(km.getTransferableId(), km, t1, t2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCustomShortcut(String foreignCommandId, String foreignShortcuts) {
        block7: {
            String key$iv;
            KeyboardShortcut shortcuts;
            String commandId;
            block6: {
                void $this$getOrPut$iv;
                KeyboardShortcut keyboardShortcut;
                String string = KeyBindingsMappings.INSTANCE.commandIdMap(foreignCommandId);
                if (string == null) {
                    return;
                }
                commandId = string;
                try {
                    keyboardShortcut = this.parseShortcuts(foreignShortcuts);
                }
                catch (Throwable t) {
                    KeyBindingsParserKt.access$getLogger$p().warn("Could not parse " + foreignCommandId + ": " + foreignShortcuts);
                    keyboardShortcut = null;
                }
                KeyboardShortcut keyboardShortcut2 = keyboardShortcut;
                if (keyboardShortcut2 == null) {
                    return;
                }
                shortcuts = keyboardShortcut2;
                if (!StringsKt.startsWith$default((CharSequence)foreignCommandId, (char)'-', (boolean)false, (int)2, null)) break block6;
                Map<String, List<KeyboardShortcut>> map = this.toRemove;
                key$iv = commandId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                }
                List<KeyboardShortcut> list = this.toRemove.get(commandId);
                if (list == null) break block7;
                list.add(shortcuts);
                break block7;
            }
            Map<String, List<KeyboardShortcut>> $this$getOrPut$iv = this.toAdd;
            key$iv = commandId;
            boolean $i$f$getOrPut = false;
            List<KeyboardShortcut> value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
            }
            List<KeyboardShortcut> list = this.toAdd.get(commandId);
            if (list == null) break block7;
            list.add(shortcuts);
        }
    }

    private final KeyboardShortcut parseShortcuts(String str) {
        if (((CharSequence)str).length() == 0) {
            return null;
        }
        char[] cArray = new char[]{' '};
        List strokes = StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        KeyStroke keyStroke = this.getKeyStroke((String)CollectionsKt.getOrNull((List)strokes, (int)0));
        if (keyStroke == null) {
            return null;
        }
        KeyStroke firstKeyStroke = keyStroke;
        String secondStrokeRaw = (String)CollectionsKt.getOrNull((List)strokes, (int)1);
        KeyStroke secondKeyStroke = this.getKeyStroke(secondStrokeRaw);
        if (secondStrokeRaw != null && secondKeyStroke == null) {
            return null;
        }
        return new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
    }

    private final KeyStroke getKeyStroke(String s) {
        CharSequence charSequence = s;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String string = s.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        char[] cArray = new char[]{'+'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String normalizedShortcut = KeyBindingsMappings.INSTANCE.shortcutMap(it);
            sb.append(normalizedShortcut + " ");
        }
        return KeyStroke.getKeyStroke(((Object)StringsKt.dropLast((CharSequence)sb, (int)1)).toString());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/KeyBindingsParser$Companion;", "", "<init>", "()V", "COMMAND", "", "KEY", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

