/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstAnnotationOwner;
import com.jetbrains.python.ast.PyAstAssignmentExpression;
import com.jetbrains.python.ast.PyAstAssignmentStatement;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstForPart;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstPossibleClassMember;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstQualifiedNameOwner;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstReferenceOwner;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.PyAstTypeCommentOwner;
import com.jetbrains.python.ast.PyAstTypeDeclarationStatement;
import com.jetbrains.python.ast.PyAstWithItem;
import com.jetbrains.python.ast.PyAstWithStatement;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstTargetExpression
extends PyAstQualifiedExpression,
PsiNamedElement,
PsiNameIdentifierOwner,
PyAstDocStringOwner,
PyAstQualifiedNameOwner,
PyAstReferenceOwner,
PyAstPossibleClassMember,
PyAstTypeCommentOwner,
PyAstAnnotationOwner {
    public static final PyAstTargetExpression[] EMPTY_ARRAY = new PyAstTargetExpression[0];
    public static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<PyAstExpression, PyAstTargetExpression> FIND_ASSIGNED_VALUE_PROVIDER = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("python.findAssignedValue", expression -> CachedValueProvider.Result.create((Object)expression.findAssignedValueInternal(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));

    @Nullable
    default public String getName() {
        ASTNode node = this.getNameElement();
        return node != null ? node.getText() : null;
    }

    default public int getTextOffset() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    default public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    default public PsiElement getNameIdentifier() {
        ASTNode nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getPsi();
    }

    @Override
    default public String getReferencedName() {
        return this.getName();
    }

    default public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PyAstTargetExpression.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    default public PyAstAnnotation getAnnotation() {
        PyAstTargetExpression topTarget = this;
        while (topTarget.getParent() instanceof PyAstParenthesizedExpression) {
            topTarget = topTarget.getParent();
        }
        PsiElement parent = topTarget.getParent();
        if (parent != null) {
            PyAstAssignmentStatement assignment = (PyAstAssignmentStatement)ObjectUtils.tryCast((Object)parent, PyAstAssignmentStatement.class);
            if (assignment != null) {
                PyAstExpression[] targets = assignment.getRawTargets();
                if (targets.length == 1 && targets[0] == topTarget) {
                    return assignment.getAnnotation();
                }
            } else if (parent instanceof PyAstTypeDeclarationStatement) {
                return ((PyAstTypeDeclarationStatement)parent).getAnnotation();
            }
        }
        return null;
    }

    @Override
    @Nullable
    default public PyAstExpression getQualifier() {
        ASTNode qualifier = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        return qualifier != null ? (PyAstExpression)qualifier.getPsi() : null;
    }

    @Override
    default public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    @Nullable
    default public PyAstClass getContainingClass() {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PyAstFunction.class, PyAstClass.class});
        if (parent instanceof PyAstClass) {
            return (PyAstClass)parent;
        }
        if (parent instanceof PyAstFunction) {
            return ((PyAstFunction)parent).getContainingClass();
        }
        return null;
    }

    @Override
    @Nullable
    default public PyAstStringLiteralExpression getDocStringExpression() {
        PyAstExpression expression;
        PsiElement nextSibling;
        PsiElement parent = this.getParent();
        if ((parent instanceof PyAstAssignmentStatement || parent instanceof PyAstTypeDeclarationStatement) && (nextSibling = PyPsiUtilsCore.getNextNonCommentSibling(parent, true)) instanceof PyAstExpressionStatement && (expression = ((PyAstExpressionStatement)nextSibling).getExpression()) instanceof PyAstStringLiteralExpression) {
            return (PyAstStringLiteralExpression)expression;
        }
        return null;
    }

    @Nullable
    default public PyAstExpression findAssignedValue() {
        PyPsiUtilsCore.assertValid(this);
        return (PyAstExpression)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, FIND_ASSIGNED_VALUE_PROVIDER);
    }

    @Nullable
    private PyAstExpression findAssignedValueInternal() {
        PyAstImportElement importElement;
        PyAstAssignmentStatement assignment = (PyAstAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstAssignmentStatement.class);
        if (assignment != null) {
            List<? extends Pair<? extends PyAstExpression, ? extends PyAstExpression>> mapping = assignment.getTargetsToValuesMapping();
            for (Pair<? extends PyAstExpression, ? extends PyAstExpression> pair : mapping) {
                PyAstExpression assigned_to = (PyAstExpression)pair.getFirst();
                if (assigned_to != this) continue;
                return (PyAstExpression)pair.getSecond();
            }
        }
        if ((importElement = (PyAstImportElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstImportElement.class)) != null) {
            return importElement.getImportReferenceExpression();
        }
        PyAstAssignmentExpression assignmentExpression = (PyAstAssignmentExpression)ObjectUtils.tryCast((Object)this.getParent(), PyAstAssignmentExpression.class);
        if (assignmentExpression != null) {
            return assignmentExpression.getAssignedValue();
        }
        return null;
    }

    @Nullable
    default public QualifiedName getAssignedQName() {
        PyAstExpression value = this.findAssignedValue();
        return value instanceof PyAstReferenceExpression ? ((PyAstReferenceExpression)value).asQualifiedName() : null;
    }

    @Nullable
    default public QualifiedName getCalleeName() {
        PyAstExpression value = this.findAssignedValue();
        return value instanceof PyAstCallExpression ? PyPsiUtilsCore.asQualifiedName(((PyAstCallExpression)value).getCallee()) : null;
    }

    default public boolean hasAssignedValue() {
        return true;
    }

    @Override
    @Nullable
    default public String getDocStringValue() {
        return DocStringUtilCore.getDocStringValue(this);
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyTargetExpression(this);
    }

    @Override
    @Nullable
    default public PsiComment getTypeComment() {
        PsiComment comment = null;
        PyAstAssignmentStatement assignment = (PyAstAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstAssignmentStatement.class);
        if (assignment != null) {
            PyAstExpression assignedValue = assignment.getAssignedValue();
            if (assignedValue != null && !PsiTreeUtil.isAncestor((PsiElement)assignedValue, (PsiElement)this, (boolean)false)) {
                comment = (PsiComment)ObjectUtils.tryCast((Object)PyPsiUtilsCore.getNextNonWhitespaceSiblingOnSameLine((PsiElement)assignedValue), PsiComment.class);
            }
        } else {
            PyAstWithItem withPart;
            PyAstStatementListContainer forOrWith = null;
            PyAstForPart forPart = (PyAstForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstForPart.class);
            if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)forPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = forPart;
            }
            if ((withPart = (PyAstWithItem)PsiTreeUtil.getParentOfType((PsiElement)this, PyAstWithItem.class)) != null && PsiTreeUtil.isAncestor((PsiElement)withPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = (PyAstStatementListContainer)ObjectUtils.tryCast((Object)withPart.getParent(), PyAstWithStatement.class);
            }
            if (forOrWith != null) {
                comment = PyUtilCore.getCommentOnHeaderLine(forOrWith);
            }
        }
        return comment != null && PyUtilCore.getTypeCommentValue(comment.getText()) != null ? comment : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/ast/PyAstTargetExpression", "setName"));
    }
}

