/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt$getInsertStatements$;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a&\u0010\u0004\u001a\u0004\u0018\u00010\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0010\u001a\u00020\u0011\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\r*\u0002H\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015\u001a#\u0010$\u001a\u00020\u0011*\u00020\"2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00110&\u00a2\u0006\u0002\b(\u00a8\u0006)"}, d2={"addGroupBy", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "groupByClause", "createGroupByClause", "expressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "getElementForGroupBy", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "dropListItem", "", "T", "(Lcom/intellij/psi/PsiElement;)V", "areEquivalent", "", "e1", "e2", "isAcceptableDelimiter", "e", "statementDelimiter", "", "getInsertStatements", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/psi/SqlInsertStatement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "onlyValues", "modifyDocument", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Document;", "Lkotlin/ExtensionFunctionType;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nintentionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 intentionUtils.kt\ncom/intellij/sql/intentions/IntentionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,148:1\n296#2,2:149\n1786#2,3:151\n479#3:154\n1253#3,2:155\n*S KotlinDebug\n*F\n+ 1 intentionUtils.kt\ncom/intellij/sql/intentions/IntentionUtilsKt\n*L\n30#1:149,2\n91#1:151,3\n122#1:154\n132#1:155,2\n*E\n"})
public final class IntentionUtilsKt {
    @Nullable
    public static final SqlGroupByClause addGroupBy(@NotNull SqlQueryExpression $this$addGroupBy, @NotNull SqlGroupByClause groupByClause) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$addGroupBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)groupByClause, (String)"groupByClause");
        SqlTableExpression sqlTableExpression = $this$addGroupBy.getTableExpression();
        if (sqlTableExpression == null) {
            return null;
        }
        SqlTableExpression tableExpression = sqlTableExpression;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)$this$addGroupBy);
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra()) {
            psiElement = null;
        } else if (dbms2.isClickHouse()) {
            Object v5;
            block11: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first = ((SqlClause)it).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v5 = element$iv;
                    break block11;
                }
                v5 = null;
            }
            if ((psiElement = (PsiElement)v5) == null) {
                psiElement = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        PsiElement anchor = psiElement;
        PsiElement psiElement2 = tableExpression.addBefore((PsiElement)groupByClause, anchor);
        return psiElement2 instanceof SqlGroupByClause ? (SqlGroupByClause)psiElement2 : null;
    }

    @Nullable
    public static final SqlGroupByClause createGroupByClause(@NotNull List<? extends SqlExpression> expressions, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SqlPsiElementFactory.createGroupByClause(CollectionsKt.joinToString$default((Iterable)expressions, null, null, null, (int)0, null, arg_0 -> IntentionUtilsKt.createGroupByClause$lambda$0(dialect, arg_0), (int)31, null), dialect, project);
    }

    private static final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    public static final /* synthetic */ <T extends PsiElement> void dropListItem(T $this$dropListItem) {
        Intrinsics.checkNotNullParameter($this$dropListItem, (String)"<this>");
        boolean $i$f$dropListItem = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement prevItem = PsiTreeUtil.getPrevSiblingOfType($this$dropListItem, PsiElement.class);
        PsiElement from = null;
        Object to = null;
        if (prevItem != null) {
            PsiElement psiElement = prevItem.getNextSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNextSibling(...)");
            from = psiElement;
            to = $this$dropListItem;
        } else {
            from = $this$dropListItem;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object object = PsiTreeUtil.getNextSiblingOfType($this$dropListItem, PsiElement.class);
            if (object == null || (object = object.getPrevSibling()) == null) {
                object = $this$dropListItem;
            }
            to = object;
        }
        $this$dropListItem.getParent().deleteChildRange(from, to);
    }

    private static final boolean areEquivalent(PsiElement e1, PsiElement e2) {
        boolean bl;
        block9: {
            if (e1 == e2) {
                return true;
            }
            if ((e1 instanceof PsiWhiteSpace || e1 instanceof PsiComment) && (e2 instanceof PsiWhiteSpace || e2 instanceof PsiComment)) {
                return true;
            }
            if (e1 instanceof SqlResultSetExpression && e2 instanceof SqlResultSetExpression) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)e1), (Object)PsiUtilCore.getElementType((PsiElement)e2))) {
                return false;
            }
            if (e1 instanceof LeafPsiElement) {
                return e2 instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)e1).getText(), (Object)((LeafPsiElement)e2).getText());
            }
            List list = SqlImplUtil.sqlChildren(e1).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List children1 = list;
            List list2 = SqlImplUtil.sqlChildren(e2).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
            List children2 = list2;
            if (children1.size() != children2.size()) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)children1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    Object e = children1.get(i2);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    PsiElement psiElement = (PsiElement)e;
                    Object e3 = children2.get(i2);
                    Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                    if (IntentionUtilsKt.areEquivalent(psiElement, (PsiElement)e3)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isAcceptableDelimiter(PsiElement e, String statementDelimiter) {
        return e instanceof PsiWhiteSpace || e instanceof PsiComment || e instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)e).getText(), (Object)statementDelimiter) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e), (Object)SqlTokens.ORAP_DELIMITER_TOKEN);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<SqlInsertStatement> getInsertStatements(@NotNull Editor editor, @NotNull PsiFile file, boolean onlyValues) {
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int startOffset = selectionModel2.getSelectionStart();
        int endOffset = selectionModel2.getSelectionEnd();
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), SqlInsertStatement.class, (boolean)false);
        if (sqlInsertStatement == null) {
            return SequencesKt.emptySequence();
        }
        SqlInsertStatement fromStatement = sqlInsertStatement;
        String string = DbSqlUtilCore.getDelimiterAt((PsiFile)file, (int)startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDelimiterAt(...)");
        String delimiter = string;
        Sequence statements2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super PsiElement>, Continuation<? super Unit>, Object>(fromStatement, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SqlInsertStatement $fromStatement;
            {
                this.$fromStatement = $fromStatement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = SqlImplUtil.siblings((PsiElement)this.$fromStatement);
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"siblings(...)");
                        $this$forEach$iv = (Iterable)v0;
                        $i$f$forEach = 0;
                        var5_6 = $this$forEach$iv.iterator();
lbl11:
                        // 5 sources

                        while (var5_6.hasNext()) {
                            element$iv = var5_6.next();
                            it = (PsiElement)element$iv;
                            $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = 0;
                            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.SQL_DUMMY_BLOCK)) break block0;
                            v1 = SqlImplUtil.sqlChildren(it);
                            Intrinsics.checkNotNullExpressionValue(v1, (String)"sqlChildren(...)");
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            this.L$2 = var5_6;
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                            this.I$0 = $i$f$forEach;
                            this.I$1 = $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1;
                            this.label = 1;
                            v2 = $this$sequence.yieldAll((Iterable)v1, (Continuation)this);
                            if (v2 != var9_3) continue;
                            return var9_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = this.I$1;
                        $i$f$forEach = this.I$0;
                        it = (PsiElement)this.L$4;
                        element$iv = this.L$3;
                        var5_6 = (Iterator)this.L$2;
                        $this$forEach$iv = (Iterable)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl11
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                this.L$2 = var5_6;
                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                this.I$0 = $i$f$forEach;
                this.I$1 = $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1;
                this.label = 2;
                v3 = $this$sequence.yield((Object)it, (Continuation)this);
                if (v3 != var9_3) ** GOTO lbl11
                return var9_3;
                {
                    case 2: {
                        $i$a$-forEach-IntentionUtilsKt$getInsertStatements$statements$1$1 = this.I$1;
                        $i$f$forEach = this.I$0;
                        it = (PsiElement)this.L$4;
                        element$iv = this.L$3;
                        var5_6 = (Iterator)this.L$2;
                        $this$forEach$iv = (Iterable)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super PsiElement> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Sequence sequence = SequencesKt.takeWhile((Sequence)statements2, arg_0 -> IntentionUtilsKt.getInsertStatements$lambda$0(delimiter, arg_0));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getInsertStatements$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        statements2 = sequence2;
        Function1 checkStatement = arg_0 -> IntentionUtilsKt.getInsertStatements$lambda$1(onlyValues, fromStatement, arg_0);
        if (selectionModel2.hasSelection()) {
            boolean bl;
            block7: {
                if (UtilsKt.getValuesKeyword(fromStatement) == null) {
                    return SequencesKt.emptySequence();
                }
                if (fromStatement.getTextRange().getStartOffset() != startOffset) {
                    return SequencesKt.emptySequence();
                }
                Sequence $this$all$iv = statements2 = SequencesKt.takeWhile((Sequence)statements2, arg_0 -> IntentionUtilsKt.getInsertStatements$lambda$2(endOffset, arg_0));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    if (((Boolean)checkStatement.invoke(element$iv)).booleanValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) {
                return SequencesKt.emptySequence();
            }
        } else {
            statements2 = SequencesKt.takeWhile((Sequence)statements2, (Function1)checkStatement);
        }
        return statements2;
    }

    public static final void modifyDocument(@NotNull PsiFile $this$modifyDocument, @NotNull Function1<? super Document, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyDocument, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$this$modifyDocument.getProject());
        Document document = documentManager.getDocument($this$modifyDocument);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            action.invoke((Object)document);
        }
    }

    private static final CharSequence createGroupByClause$lambda$0(SqlLanguageDialect $dialect, SqlExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Dbms dbms = $dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Object object = IntentionUtilsKt.getElementForGroupBy(it, dbms);
        return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getInsertStatements$lambda$0(String $delimiter, PsiElement it) {
        if (it instanceof SqlInsertStatement) return true;
        Intrinsics.checkNotNull((Object)it);
        if (!IntentionUtilsKt.isAcceptableDelimiter(it, $delimiter)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getInsertStatements$lambda$1(boolean $onlyValues, SqlInsertStatement $fromStatement, SqlInsertStatement s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if ($onlyValues) {
            SqlInsertDmlInstruction sqlInsertDmlInstruction = s.getDmlInstruction();
            if (sqlInsertDmlInstruction == null) return false;
            SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
            if (sqlValuesExpression == null) return false;
        }
        if (!IntentionUtilsKt.areEquivalent((PsiElement)s, (PsiElement)$fromStatement)) return false;
        return true;
    }

    private static final boolean getInsertStatements$lambda$2(int $endOffset, SqlInsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTextRange().getEndOffset() <= $endOffset;
    }
}

