/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithOrdinalityClause;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0014J\b\u0010\f\u001a\u00020\rH$J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002R\u0014\u0010\t\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;", "Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getDasType", "Lcom/intellij/database/types/DasType;", "computeDasType", "dasTypeWithoutOrdinality", "getDasTypeWithoutOrdinality", "()Lcom/intellij/database/types/DasType;", "getTable", "Lcom/intellij/database/model/PsiTable;", "ordinalityColumn", "Lcom/intellij/sql/psi/SqlTypedDefinition;", "getOrdinalityColumn", "()Lcom/intellij/sql/psi/SqlTypedDefinition;", "calcOrdinalityColumn", "FakeDefinition", "OrdinalityColumn", "intellij.database.sql.core.impl"})
public abstract class SqlExplicitTableExpressionWithOrdinalityBase
extends SqlExplicitTableExpressionImpl {
    public SqlExplicitTableExpressionWithOrdinalityBase(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        return this.getDasTypeWithCaching();
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        DasType type = this.getDasTypeWithoutOrdinality();
        if (!(type instanceof SqlTableType)) {
            return type;
        }
        SqlTypedDefinition sqlTypedDefinition = this.getOrdinalityColumn();
        if (sqlTypedDefinition == null) {
            return type;
        }
        SqlTypedDefinition ordinality = sqlTypedDefinition;
        SqlTableType sqlTableType = ((SqlTableType)type).add((SqlTableType)new TableBasedSqlTableTypeImpl(CollectionsKt.listOf((Object)ordinality), (PsiElement)this.getTable()));
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"add(...)");
        return (DasType)sqlTableType;
    }

    @NotNull
    protected DasType getDasTypeWithoutOrdinality() {
        return super.getDasType();
    }

    @NotNull
    protected abstract PsiTable getTable();

    private final SqlTypedDefinition getOrdinalityColumn() {
        return (SqlTypedDefinition)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this), () -> SqlExplicitTableExpressionWithOrdinalityBase._get_ordinalityColumn_$lambda$0(this));
    }

    private final SqlTypedDefinition calcOrdinalityColumn() {
        SqlWithOrdinalityClause sqlWithOrdinalityClause = this.findChildByClass(SqlWithOrdinalityClause.class);
        if (sqlWithOrdinalityClause == null) {
            return null;
        }
        SqlWithOrdinalityClause ordinality = sqlWithOrdinalityClause;
        return new OrdinalityColumn(this.getTable(), ordinality);
    }

    private static final CachedValueProvider.Result _get_ordinalityColumn_$lambda$0(SqlExplicitTableExpressionWithOrdinalityBase this$0) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.calcOrdinalityColumn(), (Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0013\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0019\u0010 \u001a\u00060\u0000R\u00020\u000b2\u000b\u0010!\u001a\u00070\u0012\u00a2\u0006\u0002\b\"H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\u0012\u0010$\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0082\u0004J\n\u0010)\u001a\u00020*H\u0096\u0080\u0004R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$FakeDefinition;", "Lcom/intellij/psi/impl/RenameableFakePsiElement;", "Lcom/intellij/sql/psi/SqlDefinition;", "Lcom/intellij/sql/psi/SqlNameElement;", "parent", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;Lcom/intellij/psi/PsiElement;)V", "getDbms", "Lcom/intellij/database/Dbms;", "outer", "Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;", "getOuter", "()Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;", "isNameQuoted", "", "getNameIdentifier", "getName", "", "getTypeName", "getIcon", "Ljavax/swing/Icon;", "getNameElement", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isPlainIdentifier", "isQuotedIdentifier", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "acceptChildren", "setName", "name", "Lorg/jetbrains/annotations/NonNls;", "getNavigationElement", "isEquivalentTo", "another", "equals", "other", "", "hashCode", "", "intellij.database.sql.core.impl"})
    public abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent) {
            super(parent);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlPsiUtilKt.getSqlDialect((PsiElement)SqlExplicitTableExpressionWithOrdinalityBase.this).getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            return dbms;
        }

        private final SqlExplicitTableExpressionWithOrdinalityBase getOuter() {
            return SqlExplicitTableExpressionWithOrdinalityBase.this;
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted((SqlNameElement)this.getNameElement());
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return (PsiElement)this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            Object object = nameElement;
            if (object == null || (object = object.getName()) == null) {
                String string = DasUtil.NO_NAME;
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NO_NAME");
            }
            return object;
        }

        @Nullable
        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentationCore.getIcon((DasObject)((DasObject)this));
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(@Nullable SqlVisitor visitor2) {
        }

        public void acceptChildren(@Nullable SqlVisitor visitor2) {
        }

        @NotNull
        public FakeDefinition setName(@NotNull String name) throws IncorrectOperationException {
            block0: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                SqlNameElement sqlNameElement = this.getNameElement();
                if (sqlNameElement == null) break block0;
                sqlNameElement.setName(name);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return (PsiElement)this.getOuter();
        }

        public boolean isEquivalentTo(@Nullable PsiElement another) {
            return another != null && Intrinsics.areEqual(another.getClass(), ((Object)((Object)this)).getClass()) && Intrinsics.areEqual((Object)((Object)this.getOuter()), (Object)((Object)((FakeDefinition)another).getOuter()));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
                return false;
            }
            FakeDefinition definition = (FakeDefinition)((Object)other);
            return Intrinsics.areEqual((Object)((Object)this.getOuter()), (Object)((Object)definition.getOuter()));
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.getOuter()};
            return Objects.hash(objectArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$OrdinalityColumn;", "Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$FakeDefinition;", "Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;", "Lcom/intellij/sql/psi/SqlTypedDefinition;", "table", "Lcom/intellij/database/model/PsiTable;", "myClause", "Lcom/intellij/sql/psi/SqlWithOrdinalityClause;", "<init>", "(Lcom/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase;Lcom/intellij/database/model/PsiTable;Lcom/intellij/sql/psi/SqlWithOrdinalityClause;)V", "getTypeElement", "Lcom/intellij/sql/psi/SqlTypeElement;", "getName", "", "getDasParent", "Lcom/intellij/database/model/DasObject;", "getKind", "Lcom/intellij/database/model/ObjectKind;", "getDasType", "Lcom/intellij/database/types/DasType;", "isNotNull", "", "getDefault", "getNavigationElement", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.core.impl"})
    private final class OrdinalityColumn
    extends FakeDefinition
    implements SqlTypedDefinition {
        @NotNull
        private final SqlWithOrdinalityClause myClause;

        public OrdinalityColumn(@NotNull PsiTable table, SqlWithOrdinalityClause myClause) {
            Intrinsics.checkNotNullParameter((Object)myClause, (String)"myClause");
            super((PsiElement)table);
            this.myClause = myClause;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            SqlDefinition ordinalityDefinition = this.myClause.getAliasDefinition();
            if (ordinalityDefinition != null) {
                String string = ordinalityDefinition.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }
            String string = this.myClause.getLastChild().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        @Nullable
        public DasObject getDasParent() {
            return (DasObject)((PsiTable)this.getParent());
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            return objectKind;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = SqlPsiUtilKt.getTypeSystem((SqlElement)this).getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getIntType(...)");
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlDefinition sqlDefinition = this.myClause.getAliasDefinition();
            return sqlDefinition != null ? (PsiElement)sqlDefinition : (PsiElement)this.myClause;
        }
    }
}

